/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.jdic.tray.internal.impl;

import java.awt.AlphaComposite;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.awt.image.WritableRaster;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.ListIterator;
import javax.swing.Icon;
import javax.swing.JDialog;
import javax.swing.JPopupMenu;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import org.jdesktop.jdic.tray.internal.TrayIconService;
import sun.awt.image.IntegerComponentRaster;

public class WinTrayIconService
implements TrayIconService {
    private JPopupMenu menu;
    private Icon icon;
    private boolean autoSize;
    private byte[] caption = "JDIC TrayIcon".getBytes();
    private long hicon;
    private Image oldIconImage;
    private static HashMap map = new HashMap();
    private LinkedList actionList = new LinkedList();
    private LinkedList balloonListeners = new LinkedList();
    static int noIcons;
    int iconID = noIcons++;
    AnimationObserver observer;
    private final int WINDOWS_TASKBAR_ICON_WIDTH = 16;
    private final int WINDOWS_TASKBAR_ICON_HEIGHT = 16;
    static PopupParent popupParentFrame;
    boolean created;

    public static void removeAllIcons() {
        for (int i = 0; i < noIcons; ++i) {
            WinTrayIconService.removeIcon(i);
        }
    }

    public WinTrayIconService() {
        if (popupParentFrame == null) {
            popupParentFrame = new PopupParent();
        }
    }

    private native long createIconIndirect(int[] var1, byte[] var2, int var3, int var4, int var5, int var6, int var7);

    private native void createIcon(long var1, int var3, byte[] var4);

    private native void updateNativeIcon(long var1, int var3, byte[] var4);

    private native void showBalloonMessage(long var1, int var3, byte[] var4, byte[] var5, int var6);

    private native void deleteHIcon(long var1);

    private native int[] getRectangleOnScreen(int var1);

    private static native void removeIcon(int var0);

    public void showBalloonMessage(String caption, String text, int type) {
        byte[] batitle = caption == null ? new byte[]{} : caption.getBytes();
        byte[] bacontent = text == null ? new byte[]{} : text.getBytes();
        this.showBalloonMessage(this.hicon, this.iconID, batitle, bacontent, type);
    }

    public void addNotify() {
        if (popupParentFrame == null) {
            popupParentFrame = new PopupParent();
        }
        popupParentFrame.pack();
        map.put(new Integer(this.iconID), this);
        this.observer = new AnimationObserver();
        this.updateIcon(null);
        this.created = true;
    }

    private void updateBufferedImage() {
    }

    public void setPopupMenu(JPopupMenu m) {
        this.menu = m;
        if (this.menu != null) {
            this.menu.setLightWeightPopupEnabled(false);
            this.menu.addPopupMenuListener(new PopupMenuListener(){

                public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                }

                public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
                    popupParentFrame.setVisible(false);
                    popupParentFrame.toBack();
                }

                public void popupMenuCanceled(PopupMenuEvent e) {
                }
            });
            popupParentFrame.addWindowFocusListener(new WindowFocusListener(){

                public void windowGainedFocus(WindowEvent e) {
                }

                public void windowLostFocus(WindowEvent e) {
                    WinTrayIconService.this.menu.setVisible(false);
                }
            });
        }
    }

    protected long createNativeIcon(BufferedImage bimage, int w, int h, int xHotSpot, int yHotSpot) {
        int[] pixels = ((DataBufferInt)bimage.getRaster().getDataBuffer()).getData();
        WritableRaster raster = bimage.getRaster();
        byte[] andMask = new byte[w * h / 8];
        int npixels = pixels.length;
        for (int i = 0; i < npixels; ++i) {
            int ibyte = i / 8;
            int omask = 1 << 7 - i % 8;
            if ((pixels[i] & 0xFF000000) != 0 || ibyte >= andMask.length) continue;
            int n = ibyte;
            andMask[n] = (byte)(andMask[n] | omask);
        }
        int ficW = raster.getWidth();
        if (raster instanceof IntegerComponentRaster) {
            ficW = ((IntegerComponentRaster)raster).getScanlineStride();
        }
        return this.createIconIndirect(((DataBufferInt)bimage.getRaster().getDataBuffer()).getData(), andMask, ficW, raster.getWidth(), raster.getHeight(), xHotSpot, yHotSpot);
    }

    public void processEvent(int mouseState, int x, int y) {
        switch (mouseState) {
            case 512: {
                break;
            }
            case 514: {
                ListIterator li = this.actionList.listIterator(0);
                while (li.hasNext()) {
                    ActionListener al = (ActionListener)li.next();
                    al.actionPerformed(new ActionEvent(this, 1001, "PressAction", System.currentTimeMillis(), 0));
                }
                break;
            }
            case 517: {
                if (this.menu == null) break;
                Point p = new Point(x, y);
                Dimension d = this.menu.getPreferredSize();
                Dimension s = Toolkit.getDefaultToolkit().getScreenSize();
                p.x = p.x + d.width > s.width ? p.x - d.width : p.x;
                p.y = p.y + d.height > s.height ? p.y - d.height : p.y;
                popupParentFrame.setVisible(true);
                this.menu.show(popupParentFrame.getContentPane(), p.x, p.y);
                popupParentFrame.toFront();
                break;
            }
            case 1029: {
                ListIterator ml = this.balloonListeners.listIterator(0);
                while (ml.hasNext()) {
                    ActionListener listener = (ActionListener)ml.next();
                    listener.actionPerformed(new ActionEvent(this, 1001, "PressAction", System.currentTimeMillis(), 0));
                }
                break;
            }
        }
    }

    public static synchronized void notifyEvent(int id, final int mouseState, final int x, final int y) {
        final WinTrayIconService instance = (WinTrayIconService)map.get(new Integer(id));
        if (instance == null) {
            return;
        }
        try {
            EventQueue.invokeLater(new Runnable(){

                public void run() {
                    instance.processEvent(mouseState, x, y);
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateIcon(Image iconImage) {
        if (this.icon != null) {
            Graphics2D g;
            if (iconImage == null) {
                iconImage = new BufferedImage(this.icon.getIconWidth(), this.icon.getIconHeight(), 2);
                g = (Graphics2D)((BufferedImage)iconImage).getGraphics();
                g.setComposite(AlphaComposite.Src);
                this.icon.paintIcon(this.observer, g, 0, 0);
                this.oldIconImage = iconImage;
            }
            BufferedImage tmpImage = new BufferedImage(16, 16, 2);
            g = (Graphics2D)tmpImage.getGraphics();
            try {
                g.setComposite(AlphaComposite.Src);
                g.drawImage(iconImage, 0, 0, 16, 16, null);
            }
            finally {
                g.dispose();
            }
            tmpImage.flush();
            if (this.hicon != 0L) {
                this.deleteHIcon(this.hicon);
            }
            this.hicon = this.createNativeIcon(tmpImage, 16, 16, 0, 0);
            if (this.created) {
                this.updateNativeIcon(this.hicon, this.iconID, this.caption);
            } else {
                this.createIcon(this.hicon, this.iconID, this.caption);
            }
        }
    }

    public void setIcon(Icon i) {
        this.icon = i;
        if (this.created) {
            this.observer.setUpdate(false);
            this.observer = new AnimationObserver();
            this.updateIcon(null);
        }
    }

    public void setCaption(String s) {
        this.caption = (s == null ? "" : s).getBytes();
        if (this.created) {
            this.observer.setUpdate(false);
            this.observer = new AnimationObserver();
            this.updateIcon(null);
        }
    }

    public void setIconAutoSize(boolean b) {
    }

    public void addActionListener(ActionListener l) {
        this.actionList.add(l);
    }

    public void removeActionListener(ActionListener l) {
        this.actionList.remove(l);
    }

    public Point getLocationOnScreen() {
        int[] rect = this.getRectangleOnScreen(this.iconID);
        return new Point(rect[0], rect[1]);
    }

    void remove() {
        WinTrayIconService.removeIcon(this.iconID);
        if (this.hicon != 0L) {
            this.deleteHIcon(this.hicon);
        }
        map.remove(new Integer(this.iconID));
        this.created = false;
        if (map.size() == 0) {
            popupParentFrame.dispose();
            popupParentFrame = null;
        }
    }

    private static void restartTaskbar() {
        Iterator keyiterator = map.keySet().iterator();
        while (keyiterator.hasNext()) {
            WinTrayIconService iconService = (WinTrayIconService)map.get(keyiterator.next());
            if (!iconService.created) continue;
            iconService.remove();
            iconService.addNotify();
        }
    }

    public void addBalloonActionListener(ActionListener al) {
        this.balloonListeners.add(al);
    }

    public void removeBalloonActionListener(ActionListener al) {
        this.balloonListeners.remove(al);
    }

    static {
        Runtime.getRuntime().addShutdownHook(new Thread(){

            public void run() {
                WinTrayIconService.removeAllIcons();
            }
        });
    }

    private class AnimationObserver
    extends Component {
        boolean update = true;

        private AnimationObserver() {
        }

        public void setUpdate(boolean b) {
            this.update = b;
        }

        public boolean imageUpdate(Image img, int infoflags, int x, int y, int width, int height) {
            if (this.update && WinTrayIconService.this.created) {
                WinTrayIconService.this.updateIcon(img);
            }
            return this.update;
        }
    }

    static class PopupParent
    extends JDialog {
        public PopupParent() {
            super((Frame)null, "JDIC Tray Icon");
            try {
                Method setAlwaysOnTop = this.getClass().getMethod("setAlwaysOnTop", Boolean.TYPE);
                setAlwaysOnTop.invoke((Object)this, Boolean.TRUE);
            }
            catch (NoSuchMethodException e) {
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.setUndecorated(true);
            this.setBounds(0, 0, 0, 0);
        }
    }
}

