/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.jdic.filetypes.internal;

import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.jdesktop.jdic.filetypes.internal.AppAssociationReader;
import org.jdesktop.jdic.filetypes.internal.WinRegistryUtil;

public class WinAppAssociationReader
implements AppAssociationReader {
    public String getDescriptionByMimeType(String mimeType) {
        String temFileExt = WinRegistryUtil.getFileExtByMimeType(mimeType);
        if (temFileExt != null) {
            return this.getDescriptionByFileExt(temFileExt);
        }
        return null;
    }

    public String getDescriptionByFileExt(String fileExt) {
        return WinRegistryUtil.getDescriptionByFileExt(fileExt);
    }

    public String getMimeTypeByURL(URL url) {
        return WinRegistryUtil.getMimeTypeByURL(url);
    }

    public List getFileExtListByMimeType(String mimeType) {
        String fileExt = WinRegistryUtil.getFileExtByMimeType(mimeType);
        if (fileExt != null) {
            ArrayList<String> fileExtList = new ArrayList<String>();
            fileExtList.add(fileExt);
            return fileExtList;
        }
        return null;
    }

    public String getMimeTypeByFileExt(String fileExt) {
        return WinRegistryUtil.getMimeTypeByFileExt(fileExt);
    }

    public String getIconFileNameByMimeType(String mimeType) {
        String temFileExt = WinRegistryUtil.getFileExtByMimeType(mimeType);
        if (temFileExt != null) {
            return this.getIconFileNameByFileExt(temFileExt);
        }
        return null;
    }

    public String getIconFileNameByFileExt(String fileExt) {
        return WinRegistryUtil.getIconFileNameByFileExt(fileExt);
    }

    public List getActionListByMimeType(String mimeType) {
        String temFileExt = WinRegistryUtil.getFileExtByMimeType(mimeType);
        if (temFileExt != null) {
            return this.getActionListByFileExt(temFileExt);
        }
        return null;
    }

    public List getActionListByFileExt(String fileExt) {
        return WinRegistryUtil.getActionListByFileExt(fileExt);
    }

    public boolean isMimeTypeExist(String mimeType) {
        return WinRegistryUtil.isMimeTypeExist(mimeType);
    }

    public boolean isFileExtExist(String fileExt) {
        return WinRegistryUtil.isFileExtExist(fileExt);
    }
}

