/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.jdic.desktop.internal.impl;

import java.io.File;
import java.net.URL;
import org.jdesktop.jdic.desktop.internal.impl.WinAPIWrapper;

public class WinUtility {
    private WinUtility() {
    }

    private static String getFileExtension(File file) {
        String trimFileStr = file.toString().trim();
        if (trimFileStr == null || trimFileStr == "") {
            return null;
        }
        int strIndex = trimFileStr.lastIndexOf(File.separator);
        String filePart = trimFileStr.substring(strIndex + 1, trimFileStr.length());
        if ((strIndex = filePart.lastIndexOf(".")) == -1 || strIndex == filePart.length() - 1) {
            return null;
        }
        String fileExt = filePart.substring(strIndex, filePart.length());
        return fileExt;
    }

    public static String getVerbCommand(File file, String verb) {
        String fileExt = WinUtility.getFileExtension(file);
        if (fileExt == null) {
            return null;
        }
        return WinAPIWrapper.WinAssocQueryString(fileExt, verb);
    }

    public static String getVerbCommand(URL url, String verb) {
        String protocolType = url.getProtocol().trim();
        if (protocolType.compareToIgnoreCase("file") == 0) {
            protocolType = "http";
        }
        if (protocolType == null) {
            return null;
        }
        return WinAPIWrapper.WinAssocQueryString(protocolType, verb);
    }

    static String getDefaultMailer() {
        String defaultMailer = WinAPIWrapper.WinRegQueryValueEx(-2147483646, "SOFTWARE\\Clients\\Mail", "");
        return defaultMailer;
    }

    static String getMozMailerLocation(String defMailer) {
        String mailerPath = WinAPIWrapper.WinRegQueryValueEx(-2147483646, "SOFTWARE\\Clients\\Mail\\" + defMailer + "\\shell\\open\\command", "");
        int lastSpace = mailerPath.lastIndexOf(32);
        return mailerPath.substring(0, lastSpace);
    }

    static boolean isMapiSupported() {
        String regMapi = WinAPIWrapper.WinRegQueryValueEx(-2147483646, "SOFTWARE\\Microsoft\\Windows Messaging Subsystem", "MAPI");
        return regMapi != null && regMapi.equals("1");
    }
}

