/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.jdic.desktop.internal.impl;

import java.net.URL;
import org.jdesktop.jdic.desktop.internal.BrowserService;
import org.jdesktop.jdic.desktop.internal.LaunchFailedException;
import org.jdesktop.jdic.desktop.internal.impl.WinAPIWrapper;
import org.jdesktop.jdic.desktop.internal.impl.WinUtility;

public class WinBrowserService
implements BrowserService {
    private static final String IE_NAME_PATTERN = "iexplore";
    private static final String[] RESERVED_TARGET_NAMES = new String[]{"_top", "_self", "_parent"};

    private String convertTargetName(String target) {
        boolean isTargetNameReserved = false;
        for (int index = 0; index < RESERVED_TARGET_NAMES.length; ++index) {
            if (!target.equals(RESERVED_TARGET_NAMES[index])) continue;
            isTargetNameReserved = true;
            break;
        }
        if (!isTargetNameReserved) {
            return target;
        }
        char[] reversedChars = new char[target.length()];
        for (int i = 0; i < target.length(); ++i) {
            reversedChars[i] = target.charAt(target.length() - i - 1);
        }
        String reversedTarget = new String(reversedChars);
        String convertedTarget = reversedTarget + "?" + reversedTarget + "?" + reversedTarget;
        return convertedTarget;
    }

    public void show(URL url) throws LaunchFailedException {
        boolean findOpenNew = false;
        String verbCmd = WinUtility.getVerbCommand(url, "opennew");
        if (verbCmd != null) {
            findOpenNew = true;
        } else {
            verbCmd = WinUtility.getVerbCommand(url, "open");
        }
        if (verbCmd != null) {
            boolean result = findOpenNew ? WinAPIWrapper.WinShellExecute(url.toString(), "opennew") : WinAPIWrapper.WinShellExecute(url.toString(), "open");
            if (!result) {
                throw new LaunchFailedException("Failed to launch the default browser");
            }
        } else {
            throw new LaunchFailedException("No default browser associated with this URL");
        }
    }

    public void show(URL url, String target) throws LaunchFailedException {
        String verbCommand = WinUtility.getVerbCommand(url, "open");
        if (verbCommand.toLowerCase().indexOf(IE_NAME_PATTERN) == -1) {
            throw new LaunchFailedException("The default browser doesn't support targeting URL feature.");
        }
        boolean result = WinAPIWrapper.WinBrowseURLInIE(url.toString(), this.convertTargetName(target));
        if (!result) {
            throw new LaunchFailedException("Failed to invoke the default browser.");
        }
    }
}

