/*
 * Decompiled with CFR 0.152.
 */
package com.sun.pdfview.function;

import com.sun.pdfview.PDFObject;
import com.sun.pdfview.PDFParseException;
import com.sun.pdfview.function.PDFFunction;
import java.io.IOException;
import java.nio.ByteBuffer;

public class FunctionType0
extends PDFFunction {
    protected static final int LINEAR_INTERPOLATION = 1;
    protected static final int CUBIC_INTERPOLATION = 3;
    private int[] size;
    private int bitsPerSample;
    private int order = 1;
    private float[] encode;
    private float[] decode;
    private int[][] samples;

    protected FunctionType0() {
        super(0);
    }

    @Override
    protected void parse(PDFObject pDFObject) throws IOException {
        Object[] objectArray;
        Object object;
        PDFObject pDFObject2;
        PDFObject pDFObject3 = pDFObject.getDictRef("Size");
        if (pDFObject3 == null) {
            throw new PDFParseException("Size required for function type 0!");
        }
        PDFObject[] pDFObjectArray = pDFObject3.getArray();
        int[] nArray = new int[pDFObjectArray.length];
        for (int i = 0; i < pDFObjectArray.length; ++i) {
            nArray[i] = pDFObjectArray[i].getIntValue();
        }
        this.setSize(nArray);
        PDFObject pDFObject4 = pDFObject.getDictRef("BitsPerSample");
        if (pDFObject4 == null) {
            throw new PDFParseException("BitsPerSample required for function type 0!");
        }
        this.setBitsPerSample(pDFObject4.getIntValue());
        PDFObject pDFObject5 = pDFObject.getDictRef("Order");
        if (pDFObject5 != null) {
            this.setOrder(pDFObject5.getIntValue());
        }
        if ((pDFObject2 = pDFObject.getDictRef("Encode")) != null) {
            object = pDFObject2.getArray();
            objectArray = new float[((PDFObject[])object).length];
            for (int i = 0; i < ((Object)object).length; ++i) {
                objectArray[i] = ((PDFObject)object[i]).getFloatValue();
            }
            this.setEncode((float[])objectArray);
        }
        if ((object = pDFObject.getDictRef("Decode")) != null) {
            objectArray = ((PDFObject)object).getArray();
            float[] fArray = new float[objectArray.length];
            for (int i = 0; i < objectArray.length; ++i) {
                fArray[i] = objectArray[i].getFloatValue();
            }
            this.setDecode(fArray);
        }
        this.setSamples(this.readSamples(pDFObject.getStreamBuffer()));
    }

    @Override
    protected void doFunction(float[] fArray, int n, float[] fArray2, int n2) {
        int n3;
        float[] fArray3 = new float[this.getNumInputs()];
        for (n3 = 0; n3 < this.getNumInputs(); ++n3) {
            fArray3[n3] = FunctionType0.interpolate(fArray[n3 + n], this.getDomain(2 * n3), this.getDomain(2 * n3 + 1), this.getEncode(2 * n3), this.getEncode(2 * n3 + 1));
            fArray3[n3] = Math.max(fArray3[n3], 0.0f);
            fArray3[n3] = Math.min(fArray3[n3], (float)(this.size[n3] - 1));
        }
        for (n3 = 0; n3 < this.getNumOutputs(); ++n3) {
            fArray2[n3 + n2] = this.getOrder() == 1 ? this.multilinearInterpolate(fArray3, n3) : this.multicubicInterpolate(fArray3, n3);
        }
        for (n3 = 0; n3 < fArray2.length; ++n3) {
            fArray2[n3 + n2] = FunctionType0.interpolate(fArray2[n3 + n2], 0.0f, (float)Math.pow(2.0, this.getBitsPerSample()) - 1.0f, this.getDecode(2 * n3), this.getDecode(2 * n3 + 1));
        }
    }

    protected int getSize(int n) {
        return this.size[n];
    }

    protected void setSize(int[] nArray) {
        this.size = nArray;
    }

    protected int getBitsPerSample() {
        return this.bitsPerSample;
    }

    protected void setBitsPerSample(int n) {
        this.bitsPerSample = n;
    }

    protected int getOrder() {
        return this.order;
    }

    protected void setOrder(int n) {
        this.order = n;
    }

    protected float getEncode(int n) {
        if (this.encode != null) {
            return this.encode[n];
        }
        if (n % 2 == 0) {
            return 0.0f;
        }
        return this.getSize(n / 2) - 1;
    }

    protected void setEncode(float[] fArray) {
        this.encode = fArray;
    }

    protected float getDecode(int n) {
        if (this.decode != null) {
            return this.decode[n];
        }
        return this.getRange(n);
    }

    protected void setDecode(float[] fArray) {
        this.decode = fArray;
    }

    protected int getSample(int[] nArray, int n) {
        int n2 = 1;
        int n3 = 0;
        for (int i = 0; i < nArray.length; ++i) {
            n3 += n2 * nArray[i];
            n2 *= this.getSize(i);
        }
        return this.samples[n3][n];
    }

    protected void setSamples(int[][] nArray) {
        this.samples = nArray;
    }

    private int[][] readSamples(ByteBuffer byteBuffer) {
        int n = 1;
        for (int i = 0; i < this.getNumInputs(); ++i) {
            n *= this.getSize(i);
        }
        int[][] nArray = new int[n][this.getNumOutputs()];
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        for (int i = 0; i < this.getNumInputs(); ++i) {
            for (int j = 0; j < this.getSize(i); ++j) {
                for (int k = 0; k < this.getNumOutputs(); ++k) {
                    int n5 = 0;
                    byte by = byteBuffer.get(n3);
                    for (int i2 = this.getBitsPerSample(); i2 > 0; --i2) {
                        int n6 = by >> 7 - n2 & 1;
                        n5 |= n6 << i2 - 1;
                        if (++n2 != 8) continue;
                        n2 = 0;
                        ++n3;
                        if (i2 <= 1) continue;
                        by = byteBuffer.get(n3);
                    }
                    nArray[n4][k] = n5;
                }
                ++n4;
            }
        }
        return nArray;
    }

    private float multilinearInterpolate(float[] fArray, int n) {
        float f;
        int n2;
        float[] fArray2 = new float[fArray.length];
        for (n2 = 0; n2 < fArray2.length; ++n2) {
            fArray2[n2] = (float)((double)fArray[n2] - Math.floor(fArray[n2]));
        }
        n2 = 0;
        float f2 = f = this.getSample(fArray, n2, n);
        for (int i = 0; i < fArray2.length; ++i) {
            int n3 = 0;
            float f3 = -1.0f;
            for (int j = 0; j < fArray2.length; ++j) {
                if (!(fArray2[j] > f3)) continue;
                f3 = fArray2[j];
                n3 = j;
            }
            float f4 = this.getSample(fArray, n2 |= 1 << n3, n);
            f2 = f += fArray2[n3] * (f4 - f2);
            fArray2[n3] = -1.0f;
        }
        return f;
    }

    private float multicubicInterpolate(float[] fArray, int n) {
        System.out.println("Cubic interpolation not supported!");
        return this.multilinearInterpolate(fArray, n);
    }

    public static float interpolate(float f, float f2, float f3, float f4, float f5) {
        float f6 = (f5 - f4) / (f3 - f2);
        f6 *= f - f2;
        return f6 += f4;
    }

    private float getSample(float[] fArray, int n, int n2) {
        int[] nArray = new int[fArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = (n & 1 << i) == 0 ? (int)Math.floor(fArray[i]) : (int)Math.ceil(fArray[i]);
        }
        return this.getSample(nArray, n2);
    }
}

