/*
 * Decompiled with CFR 0.152.
 */
package com.sun.pdfview.font.ttf;

import com.sun.pdfview.font.ttf.GlyfCompound;
import com.sun.pdfview.font.ttf.GlyfSimple;
import java.nio.ByteBuffer;

public class Glyf {
    private boolean isCompound;
    private short numContours;
    private short minX;
    private short minY;
    private short maxX;
    private short maxY;

    protected Glyf() {
    }

    public static Glyf getGlyf(ByteBuffer byteBuffer) {
        short s = byteBuffer.getShort();
        Glyf glyf = null;
        if (s == 0) {
            glyf = new Glyf();
        } else if (s == -1) {
            glyf = new GlyfCompound();
        } else if (s > 0) {
            glyf = new GlyfSimple();
        } else {
            throw new IllegalArgumentException("Unknown glyf type: " + s);
        }
        glyf.setNumContours(s);
        glyf.setMinX(byteBuffer.getShort());
        glyf.setMinY(byteBuffer.getShort());
        glyf.setMaxX(byteBuffer.getShort());
        glyf.setMaxY(byteBuffer.getShort());
        glyf.setData(byteBuffer);
        return glyf;
    }

    public void setData(ByteBuffer byteBuffer) {
    }

    public ByteBuffer getData() {
        ByteBuffer byteBuffer = ByteBuffer.allocate(this.getLength());
        byteBuffer.putShort(this.getNumContours());
        byteBuffer.putShort(this.getMinX());
        byteBuffer.putShort(this.getMinY());
        byteBuffer.putShort(this.getMaxX());
        byteBuffer.putShort(this.getMaxY());
        return byteBuffer;
    }

    public short getLength() {
        return 10;
    }

    public boolean isCompound() {
        return this.isCompound;
    }

    protected void setCompound(boolean bl) {
        this.isCompound = bl;
    }

    public short getNumContours() {
        return this.numContours;
    }

    protected void setNumContours(short s) {
        this.numContours = s;
    }

    public short getMinX() {
        return this.minX;
    }

    protected void setMinX(short s) {
        this.minX = s;
    }

    public short getMinY() {
        return this.minY;
    }

    protected void setMinY(short s) {
        this.minY = s;
    }

    public short getMaxX() {
        return this.maxX;
    }

    protected void setMaxX(short s) {
        this.maxX = s;
    }

    public short getMaxY() {
        return this.maxY;
    }

    protected void setMaxY(short s) {
        this.maxY = s;
    }
}

