/*
 * Decompiled with CFR 0.152.
 */
package com.sun.pdfview.font.ttf;

import com.sun.pdfview.font.ttf.CMap;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.SortedMap;
import java.util.TreeMap;

public class CMapFormat4
extends CMap {
    public SortedMap<Segment, Object> segments = Collections.synchronizedSortedMap(new TreeMap());

    protected CMapFormat4(short s) {
        super((short)4, s);
        char[] cArray = new char[]{'\u0000'};
        this.addSegment((short)-1, (short)-1, cArray);
    }

    public void addSegment(short s, short s2, char[] cArray) {
        if (cArray.length != s2 - s + 1) {
            throw new IllegalArgumentException("Wrong number of entries in map");
        }
        Segment segment = new Segment(s, s2, true);
        this.segments.remove(segment);
        this.segments.put(segment, cArray);
    }

    public void addSegment(short s, short s2, short s3) {
        Segment segment = new Segment(s, s2, false);
        this.segments.remove(segment);
        this.segments.put(segment, new Integer(s3));
    }

    public void removeSegment(short s, short s2) {
        Segment segment = new Segment(s, s2, true);
        this.segments.remove(segment);
    }

    @Override
    public short getLength() {
        short s = 16;
        s = (short)(s + this.segments.size() * 8);
        for (Segment segment : this.segments.keySet()) {
            if (!segment.hasMap) continue;
            char[] cArray = (char[])this.segments.get(segment);
            s = (short)(s + cArray.length * 2);
        }
        return s;
    }

    @Override
    public byte map(byte by) {
        char c = this.map((char)by);
        if (c < '\uffffff80' || c > '\u007f') {
            return 0;
        }
        return (byte)c;
    }

    @Override
    public char map(char c) {
        char c2 = this.doMap(c);
        if (c2 != '\u0000') {
            return c2;
        }
        c = c > '\uf000' ? (char)(c - 61440) : (char)(c + 61440);
        return this.doMap(c);
    }

    public char doMap(char c) {
        for (Segment segment : this.segments.keySet()) {
            if (segment.endCode < c) continue;
            if (segment.startCode <= c) {
                if (segment.hasMap) {
                    char[] cArray = (char[])this.segments.get(segment);
                    return cArray[c - segment.startCode];
                }
                Integer n = (Integer)this.segments.get(segment);
                return (char)(c + n);
            }
            return '\u0000';
        }
        return '\u0000';
    }

    @Override
    public char reverseMap(short s) {
        for (Segment segment : this.segments.keySet()) {
            int n;
            Object object;
            if (segment.hasMap) {
                object = (char[])this.segments.get(segment);
                for (n = 0; n < ((Object)object).length; ++n) {
                    if (object[n] != s) continue;
                    return (char)(segment.startCode + n);
                }
                continue;
            }
            object = (Integer)this.segments.get(segment);
            n = segment.startCode + (Integer)object;
            int n2 = segment.endCode + (Integer)object;
            if (s < n || s > n2) continue;
            return (char)(s - (Integer)object);
        }
        return '\u0000';
    }

    @Override
    public void setData(int n, ByteBuffer byteBuffer) {
        int n2;
        int n3 = byteBuffer.getShort() / 2;
        short s = byteBuffer.getShort();
        short s2 = byteBuffer.getShort();
        short s3 = byteBuffer.getShort();
        short[] sArray = new short[n3];
        short[] sArray2 = new short[n3];
        short[] sArray3 = new short[n3];
        short[] sArray4 = new short[n3];
        int n4 = 16 + 8 * n3;
        for (n2 = 0; n2 < n3; ++n2) {
            sArray[n2] = byteBuffer.getShort();
        }
        byteBuffer.getShort();
        for (n2 = 0; n2 < n3; ++n2) {
            sArray2[n2] = byteBuffer.getShort();
        }
        for (n2 = 0; n2 < n3; ++n2) {
            sArray3[n2] = byteBuffer.getShort();
        }
        for (n2 = 0; n2 < n3; ++n2) {
            sArray4[n2] = byteBuffer.getShort();
            if (sArray4[n2] <= 0) {
                this.addSegment(sArray2[n2], sArray[n2], sArray3[n2]);
                continue;
            }
            int n5 = byteBuffer.position() - 2 + sArray4[n2];
            int n6 = sArray[n2] - sArray2[n2] + 1;
            char[] cArray = new char[n6];
            byteBuffer.mark();
            for (int i = 0; i < n6; ++i) {
                byteBuffer.position(n5 + i * 2);
                cArray[i] = byteBuffer.getChar();
            }
            byteBuffer.reset();
            this.addSegment(sArray2[n2], sArray[n2], cArray);
        }
    }

    @Override
    public ByteBuffer getData() {
        ByteBuffer byteBuffer = ByteBuffer.allocate(this.getLength());
        byteBuffer.putShort(this.getFormat());
        byteBuffer.putShort(this.getLength());
        byteBuffer.putShort(this.getLanguage());
        byteBuffer.putShort((short)(this.getSegmentCount() * 2));
        byteBuffer.putShort(this.getSearchRange());
        byteBuffer.putShort(this.getEntrySelector());
        byteBuffer.putShort(this.getRangeShift());
        for (Segment object : this.segments.keySet()) {
            byteBuffer.putShort((short)object.endCode);
        }
        byteBuffer.putShort((short)0);
        for (Segment segment : this.segments.keySet()) {
            byteBuffer.putShort((short)segment.startCode);
        }
        for (Segment segment : this.segments.keySet()) {
            if (!segment.hasMap) {
                Integer n = (Integer)this.segments.get(segment);
                byteBuffer.putShort(n.shortValue());
                continue;
            }
            byteBuffer.putShort((short)0);
        }
        int n = 16 + 8 * this.getSegmentCount();
        for (Segment segment : this.segments.keySet()) {
            if (segment.hasMap) {
                byteBuffer.putShort((short)(n - byteBuffer.position()));
                byteBuffer.mark();
                byteBuffer.position(n);
                char[] cArray = (char[])this.segments.get(segment);
                for (int i = 0; i < cArray.length; ++i) {
                    byteBuffer.putChar(cArray[i]);
                }
                byteBuffer.reset();
                n += cArray.length * 2;
                continue;
            }
            byteBuffer.putShort((short)0);
        }
        byteBuffer.position(n);
        byteBuffer.flip();
        return byteBuffer;
    }

    public short getSegmentCount() {
        return (short)this.segments.size();
    }

    public short getSearchRange() {
        double d = Math.floor(Math.log(this.getSegmentCount()) / Math.log(2.0));
        double d2 = Math.pow(2.0, d);
        return (short)(2.0 * d2);
    }

    public short getEntrySelector() {
        int n = this.getSearchRange() / 2;
        return (short)(Math.log(n) / Math.log(2.0));
    }

    public short getRangeShift() {
        return (short)(2 * this.getSegmentCount() - this.getSearchRange());
    }

    @Override
    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        String string = "        ";
        stringBuffer.append(super.toString());
        stringBuffer.append(string + "SegmentCount : " + this.getSegmentCount() + "\n");
        stringBuffer.append(string + "SearchRange  : " + this.getSearchRange() + "\n");
        stringBuffer.append(string + "EntrySelector: " + this.getEntrySelector() + "\n");
        stringBuffer.append(string + "RangeShift   : " + this.getRangeShift() + "\n");
        for (Segment segment : this.segments.keySet()) {
            stringBuffer.append(string);
            stringBuffer.append("Segment: " + Integer.toHexString(segment.startCode));
            stringBuffer.append("-" + Integer.toHexString(segment.endCode) + " ");
            stringBuffer.append("hasMap: " + segment.hasMap + " ");
            if (!segment.hasMap) {
                stringBuffer.append("delta: " + this.segments.get(segment));
            }
            stringBuffer.append("\n");
        }
        return stringBuffer.toString();
    }

    class Segment
    implements Comparable {
        int endCode;
        int startCode;
        boolean hasMap;

        public Segment(short s, short s2, boolean bl) {
            this.endCode = 0xFFFF & s2;
            this.startCode = 0xFFFF & s;
            this.hasMap = bl;
        }

        public boolean equals(Object object) {
            return this.compareTo(object) == 0;
        }

        public int compareTo(Object object) {
            if (!(object instanceof Segment)) {
                return -1;
            }
            Segment segment = (Segment)object;
            if (segment.endCode >= this.startCode && segment.endCode <= this.endCode || segment.startCode >= this.startCode && segment.startCode <= this.endCode) {
                return 0;
            }
            if (this.endCode > segment.endCode) {
                return 1;
            }
            if (this.endCode < segment.endCode) {
                return -1;
            }
            return 0;
        }
    }
}

