/*
 * Decompiled with CFR 0.152.
 */
package com.sun.pdfview.font;

import com.sun.pdfview.PDFObject;
import com.sun.pdfview.PDFPage;
import com.sun.pdfview.PDFParser;
import com.sun.pdfview.font.PDFFont;
import com.sun.pdfview.font.PDFFontDescriptor;
import com.sun.pdfview.font.PDFGlyph;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class Type3Font
extends PDFFont {
    HashMap<String, PDFObject> rsrc = new HashMap();
    Map charProcs;
    Rectangle2D bbox;
    AffineTransform at;
    float[] widths;
    int firstChar;
    int lastChar;

    public Type3Font(String string, PDFObject pDFObject, HashMap<String, PDFObject> hashMap, PDFFontDescriptor pDFFontDescriptor) throws IOException {
        super(string, pDFFontDescriptor);
        if (hashMap != null) {
            this.rsrc.putAll(hashMap);
        }
        PDFObject pDFObject2 = pDFObject.getDictRef("FontMatrix");
        float[] fArray = new float[6];
        for (int i = 0; i < 6; ++i) {
            fArray[i] = pDFObject2.getAt(i).getFloatValue();
        }
        this.at = new AffineTransform(fArray);
        float f = fArray[0] + fArray[2];
        PDFObject pDFObject3 = pDFObject.getDictRef("Resources");
        if (pDFObject3 != null) {
            this.rsrc.putAll(pDFObject3.getDictionary());
        }
        this.charProcs = pDFObject.getDictRef("CharProcs").getDictionary();
        PDFObject[] pDFObjectArray = pDFObject.getDictRef("FontBBox").getArray();
        float[] fArray2 = new float[4];
        for (int i = 0; i < 4; ++i) {
            fArray2[i] = pDFObjectArray[i].getFloatValue();
        }
        this.bbox = new Rectangle2D.Float(fArray2[0], fArray2[1], fArray2[2] - fArray2[0], fArray2[3] - fArray2[1]);
        if (this.bbox.isEmpty()) {
            this.bbox = null;
        }
        PDFObject[] pDFObjectArray2 = pDFObject.getDictRef("Widths").getArray();
        this.widths = new float[pDFObjectArray2.length];
        for (int i = 0; i < pDFObjectArray2.length; ++i) {
            this.widths[i] = pDFObjectArray2[i].getFloatValue();
        }
        this.firstChar = pDFObject.getDictRef("FirstChar").getIntValue();
        this.lastChar = pDFObject.getDictRef("LastChar").getIntValue();
    }

    public int getFirstChar() {
        return this.firstChar;
    }

    public int getLastChar() {
        return this.lastChar;
    }

    @Override
    protected PDFGlyph getGlyph(char c, String string) {
        if (string == null) {
            throw new IllegalArgumentException("Glyph name required for Type3 font!Source character: " + c);
        }
        PDFObject pDFObject = (PDFObject)this.charProcs.get(string);
        if (pDFObject == null) {
            return new PDFGlyph(c, string, new GeneralPath(), new Point2D.Float(0.0f, 0.0f));
        }
        try {
            PDFPage pDFPage = new PDFPage(this.bbox, 0);
            pDFPage.addXform(this.at);
            PDFParser pDFParser = new PDFParser(pDFPage, pDFObject.getStream(), this.rsrc);
            pDFParser.go(true);
            float f = 0.0f;
            int n = c - this.firstChar;
            if (n >= 0 && n < this.widths.length) {
                f = this.widths[n];
            }
            Point2D point2D = new Point2D.Float(f, 0.0f);
            point2D = this.at.transform(point2D, null);
            return new PDFGlyph(c, string, pDFPage, point2D);
        }
        catch (IOException iOException) {
            System.out.println("IOException in Type3 font: " + iOException);
            iOException.printStackTrace();
            return null;
        }
    }
}

