/*
 * Decompiled with CFR 0.152.
 */
package com.sun.pdfview.font;

import com.sun.pdfview.PDFObject;
import com.sun.pdfview.font.FlPoint;
import com.sun.pdfview.font.FontSupport;
import com.sun.pdfview.font.OutlineFont;
import com.sun.pdfview.font.PDFFontDescriptor;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.NoninvertibleTransformException;
import java.io.IOException;

public class Type1CFont
extends OutlineFont {
    String[] chr2name = new String[256];
    byte[] data;
    int pos;
    byte[] subrs;
    float[] stack = new float[100];
    int stackptr = 0;
    String[] names;
    int[] glyphnames;
    int[] encoding = new int[256];
    String fontname;
    AffineTransform at = new AffineTransform(0.001f, 0.0f, 0.0f, 0.001f, 0.0f, 0.0f);
    int num;
    float fnum;
    int type;
    static int CMD = 0;
    static int NUM = 1;
    static int FLT = 2;
    int charstringtype = 2;
    float[] temps = new float[32];
    int charsetbase = 0;
    int encodingbase = 0;
    int charstringbase = 0;
    int privatebase = 0;
    int privatesize = 0;
    int gsubrbase = 0;
    int lsubrbase = 0;
    int gsubrsoffset = 0;
    int lsubrsoffset = 0;
    int nglyphs = 1;

    public Type1CFont(String string, PDFObject pDFObject, PDFFontDescriptor pDFFontDescriptor) throws IOException {
        super(string, pDFObject, pDFFontDescriptor);
        PDFObject pDFObject2 = pDFFontDescriptor.getFontFile3();
        this.data = pDFObject2.getStream();
        this.pos = 0;
        this.parse();
    }

    private void printData() {
        char[] cArray = new char[17];
        int n = 0;
        for (int i = 0; i < this.data.length; ++i) {
            int n2 = this.data[i] & 0xFF;
            cArray[n++] = n2 == 0 ? 46 : (n2 < 32 || n2 >= 127 ? 63 : (char)n2);
            if (n2 < 16) {
                System.out.print("0" + Integer.toHexString(n2));
            } else {
                System.out.print(Integer.toHexString(n2));
            }
            if ((i & 0xF) == 15) {
                System.out.println("      " + new String(cArray));
                n = 0;
                continue;
            }
            if ((i & 7) == 7) {
                System.out.print("  ");
                cArray[n++] = 32;
                continue;
            }
            if ((i & 1) != 1) continue;
            System.out.print(" ");
        }
        System.out.println();
    }

    private int readNext(boolean bl) {
        this.num = this.data[this.pos++] & 0xFF;
        if (this.num == 30 && !bl) {
            this.readFNum();
            this.type = FLT;
            return this.type;
        }
        if (this.num == 28) {
            this.num = (this.data[this.pos] << 8) + (this.data[this.pos + 1] & 0xFF);
            this.pos += 2;
            this.type = NUM;
            return this.type;
        }
        if (this.num == 29 && !bl) {
            this.num = (this.data[this.pos] & 0xFF) << 24 | (this.data[this.pos + 1] & 0xFF) << 16 | (this.data[this.pos + 2] & 0xFF) << 8 | this.data[this.pos + 3] & 0xFF;
            this.pos += 4;
            this.type = NUM;
            return this.type;
        }
        if (this.num == 12) {
            this.num = 1000 + (this.data[this.pos++] & 0xFF);
            this.type = CMD;
            return this.type;
        }
        if (this.num < 32) {
            this.type = CMD;
            return this.type;
        }
        if (this.num < 247) {
            this.num -= 139;
            this.type = NUM;
            return this.type;
        }
        if (this.num < 251) {
            this.num = (this.num - 247) * 256 + (this.data[this.pos++] & 0xFF) + 108;
            this.type = NUM;
            return this.type;
        }
        if (this.num < 255) {
            this.num = -(this.num - 251) * 256 - (this.data[this.pos++] & 0xFF) - 108;
            this.type = NUM;
            return this.type;
        }
        if (!bl) {
            this.printData();
            throw new RuntimeException("Got a 255 code while reading dict");
        }
        this.fnum = (float)((this.data[this.pos] & 0xFF) << 24 | (this.data[this.pos + 1] & 0xFF) << 16 | (this.data[this.pos + 2] & 0xFF) << 8 | this.data[this.pos + 3] & 0xFF) / 65536.0f;
        this.pos += 4;
        this.type = FLT;
        return this.type;
    }

    public void readFNum() {
        float f = 0.0f;
        boolean bl = false;
        int n = 0;
        int n2 = 0;
        float f2 = 1.0f;
        byte by = this.data[this.pos++];
        while (true) {
            if (by == -35) {
                by = this.data[this.pos++];
            }
            int n3 = by >> 4 & 0xF;
            by = (byte)(by << 4 | 0xD);
            if (n3 < 10) {
                if (n != 0) {
                    n2 = n2 * 10 + n3;
                    continue;
                }
                if (f2 == 1.0f) {
                    f = f * 10.0f + (float)n3;
                    continue;
                }
                f += (float)n3 * f2;
                f2 /= 10.0f;
                continue;
            }
            if (n3 == 10) {
                f2 = 0.1f;
                continue;
            }
            if (n3 == 11) {
                n = 1;
                continue;
            }
            if (n3 == 12) {
                n = -1;
                continue;
            }
            if (n3 != 14) break;
            bl = true;
        }
        this.fnum = (float)(bl ? -1 : 1) * f * (float)Math.pow(10.0, n2 * n);
    }

    private int readInt(int n) {
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            n2 = n2 << 8 | this.data[this.pos++] & 0xFF;
        }
        return n2;
    }

    private int readByte() {
        return this.data[this.pos++] & 0xFF;
    }

    public int getIndexSize(int n) {
        int n2 = this.pos;
        this.pos = n;
        int n3 = this.readInt(2);
        if (n3 <= 0) {
            return 2;
        }
        int n4 = this.readByte();
        if (n4 < 1 || n4 > 4) {
            throw new RuntimeException("Offsize: " + n4 + ", must be in range 1-4.");
        }
        this.pos += n3 * n4;
        int n5 = this.readInt(n4);
        this.pos = n2;
        return 2 + (n3 + 1) * n4 + n5;
    }

    public int getTableLength(int n) {
        int n2 = this.pos;
        this.pos = n;
        int n3 = this.readInt(2);
        if (n3 <= 0) {
            return 2;
        }
        this.pos = n2;
        return n3;
    }

    Range getIndexEntry(int n, int n2) {
        int n3 = this.pos;
        this.pos = n;
        int n4 = this.readInt(2);
        int n5 = this.readByte();
        if (n5 < 1 || n5 > 4) {
            throw new RuntimeException("Offsize: " + n5 + ", must be in range 1-4.");
        }
        this.pos += n5 * n2;
        int n6 = this.readInt(n5);
        Range range = new Range(n6 + 2 + n + n5 * (n4 + 1), this.readInt(n5) - n6);
        this.pos = n3;
        return range;
    }

    private void readDict(Range range) {
        this.pos = range.getStart();
        while (this.pos < range.getEnd()) {
            int n = this.readCommand(false);
            if (n == 1006) {
                this.charstringtype = (int)this.stack[0];
            } else if (n == 1007) {
                this.at = this.stackptr == 4 ? new AffineTransform(this.stack[0], this.stack[1], this.stack[2], this.stack[3], 0.0f, 0.0f) : new AffineTransform(this.stack[0], this.stack[1], this.stack[2], this.stack[3], this.stack[4], this.stack[5]);
            } else if (n == 15) {
                this.charsetbase = (int)this.stack[0];
            } else if (n == 16) {
                this.encodingbase = (int)this.stack[0];
            } else if (n == 17) {
                this.charstringbase = (int)this.stack[0];
            } else if (n == 18) {
                this.privatesize = (int)this.stack[0];
                this.privatebase = (int)this.stack[1];
            } else if (n == 19) {
                this.lsubrbase = this.privatebase + (int)this.stack[0];
                this.lsubrsoffset = this.calcoffset(this.lsubrbase);
            }
            this.stackptr = 0;
        }
    }

    private int readCommand(boolean bl) {
        int n;
        while ((n = this.readNext(bl)) != CMD) {
            this.stack[this.stackptr++] = n == NUM ? (float)this.num : this.fnum;
        }
        return this.num;
    }

    private void readEncodingData(int n) {
        if (n == 0) {
            System.arraycopy(FontSupport.standardEncoding, 0, this.encoding, 0, FontSupport.standardEncoding.length);
        } else if (n == 1) {
            System.out.println("**** EXPERT ENCODING!");
        } else {
            this.pos = n;
            int n2 = this.readByte();
            if ((n2 & 0x7F) == 0) {
                int n3 = this.readByte();
                int n4 = 1;
                while (n4 < n3 + 1) {
                    int n5 = this.readByte() & 0xFF;
                    this.encoding[n5] = n4++;
                }
            } else if ((n2 & 0x7F) == 1) {
                int n6 = this.readByte();
                int n7 = 1;
                for (int i = 0; i < n6; ++i) {
                    int n8 = this.readByte();
                    int n9 = this.readByte();
                    for (int j = n8; j < n8 + n9 + 1; ++j) {
                        this.encoding[j] = n7++;
                    }
                }
            } else {
                System.out.println("Bad encoding type: " + n2);
            }
        }
    }

    private void readGlyphNames(int n) {
        block10: {
            int n2;
            block11: {
                block9: {
                    if (n == 0) {
                        this.glyphnames = new int[229];
                        for (int i = 0; i < this.glyphnames.length; ++i) {
                            this.glyphnames[i] = i;
                        }
                        return;
                    }
                    if (n == 1) {
                        this.glyphnames = FontSupport.type1CExpertCharset;
                        return;
                    }
                    if (n == 2) {
                        this.glyphnames = FontSupport.type1CExpertSubCharset;
                        return;
                    }
                    this.glyphnames = new int[this.nglyphs];
                    this.glyphnames[0] = 0;
                    this.pos = n;
                    n2 = this.readByte();
                    if (n2 != 0) break block9;
                    for (int i = 1; i < this.nglyphs; ++i) {
                        this.glyphnames[i] = this.readInt(2);
                    }
                    break block10;
                }
                if (n2 != 1) break block11;
                int n3 = 1;
                while (n3 < this.nglyphs) {
                    int n4 = this.readInt(2);
                    int n5 = this.readByte() + 1;
                    for (int i = 0; i < n5; ++i) {
                        this.glyphnames[n3++] = n4++;
                    }
                }
                break block10;
            }
            if (n2 != 2) break block10;
            int n6 = 1;
            while (n6 < this.nglyphs) {
                int n7 = this.readInt(2);
                int n8 = this.readInt(2) + 1;
                for (int i = 0; i < n8; ++i) {
                    this.glyphnames[n6++] = n7++;
                }
            }
        }
    }

    private void readNames(int n) {
        this.pos = n;
        int n2 = this.readInt(2);
        this.names = new String[n2];
        for (int i = 0; i < n2; ++i) {
            Range range = this.getIndexEntry(n, i);
            this.names[i] = new String(this.data, range.getStart(), range.getLen());
        }
    }

    private void parse() throws IOException {
        int n = this.readByte();
        int n2 = this.readByte();
        int n3 = this.readByte();
        int n4 = this.readByte();
        int n5 = n3;
        int n6 = n5 + this.getIndexSize(n5);
        int n7 = n6 + this.getIndexSize(n6);
        this.gsubrbase = n7 + this.getIndexSize(n7);
        this.gsubrsoffset = this.calcoffset(this.gsubrbase);
        this.readNames(n7);
        this.pos = n6;
        if (this.readInt(2) != 1) {
            this.printData();
            throw new RuntimeException("More than one font in this file!");
        }
        Range range = this.getIndexEntry(n5, 0);
        this.fontname = new String(this.data, range.getStart(), range.getLen());
        this.readDict(this.getIndexEntry(n6, 0));
        this.readDict(new Range(this.privatebase, this.privatesize));
        this.pos = this.charstringbase;
        this.nglyphs = this.readInt(2);
        this.readGlyphNames(this.charsetbase);
        this.readEncodingData(this.encodingbase);
    }

    private int getNameIndex(String string) {
        int n = FontSupport.findName(string, FontSupport.stdNames);
        if (n == -1) {
            n = FontSupport.findName(string, this.names) + FontSupport.stdNames.length;
        }
        if (n == -1) {
            n = 0;
        }
        return n;
    }

    private String safe(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c >= ' ' && c < '\u0080') {
                stringBuffer.append(c);
                continue;
            }
            stringBuffer.append("<" + c + ">");
        }
        return stringBuffer.toString();
    }

    private synchronized GeneralPath readGlyph(int n, int n2) {
        FlPoint flPoint = new FlPoint();
        Range range = this.getIndexEntry(n, n2);
        GeneralPath generalPath = new GeneralPath();
        int n3 = this.pos;
        this.stackptr = 0;
        this.parseGlyph(range, generalPath, flPoint);
        this.pos = n3;
        generalPath.transform(this.at);
        return generalPath;
    }

    public int calcoffset(int n) {
        int n2 = this.getTableLength(n);
        if (n2 < 1240) {
            return 107;
        }
        if (n2 < 33900) {
            return 1131;
        }
        return 32768;
    }

    public String getSID(int n) {
        if (n < FontSupport.stdNames.length) {
            return FontSupport.stdNames[n];
        }
        return this.names[n -= FontSupport.stdNames.length];
    }

    private void buildAccentChar(float f, float f2, char c, char c2, GeneralPath generalPath) {
        GeneralPath generalPath2 = this.getOutline(c2, this.getWidth(c2, null));
        AffineTransform affineTransform = AffineTransform.getTranslateInstance(f, f2);
        try {
            affineTransform.concatenate(this.at.createInverse());
        }
        catch (NoninvertibleTransformException noninvertibleTransformException) {
            // empty catch block
        }
        generalPath2.transform(affineTransform);
        GeneralPath generalPath3 = this.getOutline(c, this.getWidth(c, null));
        try {
            AffineTransform affineTransform2 = this.at.createInverse();
            generalPath3.transform(affineTransform2);
        }
        catch (NoninvertibleTransformException noninvertibleTransformException) {
            // empty catch block
        }
        generalPath.append(generalPath3, false);
        generalPath.append(generalPath2, false);
    }

    void parseGlyph(Range range, GeneralPath generalPath, FlPoint flPoint) {
        this.pos = range.getStart();
        int n = 0;
        block48: while (this.pos < range.getEnd()) {
            int n2 = this.readCommand(true);
            int n3 = 0;
            switch (n2) {
                case 1: 
                case 3: {
                    this.stackptr = 0;
                    continue block48;
                }
                case 4: {
                    if (this.stackptr > 1) {
                        this.stack[0] = this.stack[1];
                    }
                    flPoint.y += this.stack[0];
                    if (flPoint.open) {
                        generalPath.closePath();
                    }
                    flPoint.open = false;
                    generalPath.moveTo(flPoint.x, flPoint.y);
                    this.stackptr = 0;
                    continue block48;
                }
                case 5: {
                    int n4 = 0;
                    while (n4 < this.stackptr) {
                        flPoint.x += this.stack[n4++];
                        flPoint.y += this.stack[n4++];
                        generalPath.lineTo(flPoint.x, flPoint.y);
                    }
                    flPoint.open = true;
                    this.stackptr = 0;
                    continue block48;
                }
                case 6: {
                    int n4 = 0;
                    while (n4 < this.stackptr) {
                        if ((n4 & 1) == 0) {
                            flPoint.x += this.stack[n4++];
                        } else {
                            flPoint.y += this.stack[n4++];
                        }
                        generalPath.lineTo(flPoint.x, flPoint.y);
                    }
                    flPoint.open = true;
                    this.stackptr = 0;
                    continue block48;
                }
                case 7: {
                    int n4 = 0;
                    while (n4 < this.stackptr) {
                        if ((n4 & 1) == 0) {
                            flPoint.y += this.stack[n4++];
                        } else {
                            flPoint.x += this.stack[n4++];
                        }
                        generalPath.lineTo(flPoint.x, flPoint.y);
                    }
                    flPoint.open = true;
                    this.stackptr = 0;
                    continue block48;
                }
                case 8: {
                    float f5;
                    float f2;
                    float f3;
                    float f4;
                    int n4 = 0;
                    while (n4 < this.stackptr) {
                        f4 = flPoint.x + this.stack[n4++];
                        f3 = flPoint.y + this.stack[n4++];
                        f2 = f4 + this.stack[n4++];
                        f5 = f3 + this.stack[n4++];
                        flPoint.x = f2 + this.stack[n4++];
                        flPoint.y = f5 + this.stack[n4++];
                        generalPath.curveTo(f4, f3, f2, f5, flPoint.x, flPoint.y);
                    }
                    flPoint.open = true;
                    this.stackptr = 0;
                    continue block48;
                }
                case 10: {
                    n3 = this.pos;
                    int n4 = (int)this.stack[--this.stackptr] + this.lsubrsoffset;
                    Range range2 = this.getIndexEntry(this.lsubrbase, n4);
                    this.parseGlyph(range2, generalPath, flPoint);
                    this.pos = n3;
                    continue block48;
                }
                case 11: {
                    return;
                }
                case 14: {
                    if (this.stackptr == 5) {
                        this.buildAccentChar(this.stack[1], this.stack[2], (char)this.stack[3], (char)this.stack[4], generalPath);
                    }
                    if (flPoint.open) {
                        generalPath.closePath();
                    }
                    flPoint.open = false;
                    this.stackptr = 0;
                    continue block48;
                }
                case 18: {
                    n += this.stackptr / 2;
                    this.stackptr = 0;
                    continue block48;
                }
                case 19: 
                case 20: {
                    this.pos += ((n += this.stackptr / 2) - 1) / 8 + 1;
                    this.stackptr = 0;
                    continue block48;
                }
                case 21: {
                    if (this.stackptr > 2) {
                        this.stack[0] = this.stack[1];
                        this.stack[1] = this.stack[2];
                    }
                    flPoint.x += this.stack[0];
                    flPoint.y += this.stack[1];
                    if (flPoint.open) {
                        generalPath.closePath();
                    }
                    generalPath.moveTo(flPoint.x, flPoint.y);
                    flPoint.open = false;
                    this.stackptr = 0;
                    continue block48;
                }
                case 22: {
                    if (this.stackptr > 1) {
                        this.stack[0] = this.stack[1];
                    }
                    flPoint.x += this.stack[0];
                    if (flPoint.open) {
                        generalPath.closePath();
                    }
                    generalPath.moveTo(flPoint.x, flPoint.y);
                    flPoint.open = false;
                    this.stackptr = 0;
                    continue block48;
                }
                case 23: {
                    n += this.stackptr / 2;
                    this.stackptr = 0;
                    continue block48;
                }
                case 24: {
                    float f5;
                    float f2;
                    float f3;
                    float f4;
                    int n4 = 0;
                    while (n4 < this.stackptr - 2) {
                        f4 = flPoint.x + this.stack[n4++];
                        f3 = flPoint.y + this.stack[n4++];
                        f2 = f4 + this.stack[n4++];
                        f5 = f3 + this.stack[n4++];
                        flPoint.x = f2 + this.stack[n4++];
                        flPoint.y = f5 + this.stack[n4++];
                        generalPath.curveTo(f4, f3, f2, f5, flPoint.x, flPoint.y);
                    }
                    flPoint.x += this.stack[n4++];
                    flPoint.y += this.stack[n4++];
                    generalPath.lineTo(flPoint.x, flPoint.y);
                    flPoint.open = true;
                    this.stackptr = 0;
                    continue block48;
                }
                case 25: {
                    int n4 = 0;
                    while (n4 < this.stackptr - 6) {
                        flPoint.x += this.stack[n4++];
                        flPoint.y += this.stack[n4++];
                        generalPath.lineTo(flPoint.x, flPoint.y);
                    }
                    float f4 = flPoint.x + this.stack[n4++];
                    float f3 = flPoint.y + this.stack[n4++];
                    float f2 = f4 + this.stack[n4++];
                    float f5 = f3 + this.stack[n4++];
                    flPoint.x = f2 + this.stack[n4++];
                    flPoint.y = f5 + this.stack[n4++];
                    generalPath.curveTo(f4, f3, f2, f5, flPoint.x, flPoint.y);
                    flPoint.open = true;
                    this.stackptr = 0;
                    continue block48;
                }
                case 26: {
                    float f5;
                    float f2;
                    float f3;
                    float f4;
                    int n4 = 0;
                    if ((this.stackptr & 1) == 1) {
                        flPoint.x += this.stack[n4++];
                    }
                    while (n4 < this.stackptr) {
                        f4 = flPoint.x;
                        f3 = flPoint.y + this.stack[n4++];
                        f2 = f4 + this.stack[n4++];
                        f5 = f3 + this.stack[n4++];
                        flPoint.x = f2;
                        flPoint.y = f5 + this.stack[n4++];
                        generalPath.curveTo(f4, f3, f2, f5, flPoint.x, flPoint.y);
                    }
                    flPoint.open = true;
                    this.stackptr = 0;
                    continue block48;
                }
                case 27: {
                    float f5;
                    float f2;
                    float f3;
                    float f4;
                    int n4 = 0;
                    if ((this.stackptr & 1) == 1) {
                        flPoint.y += this.stack[n4++];
                    }
                    while (n4 < this.stackptr) {
                        f4 = flPoint.x + this.stack[n4++];
                        f3 = flPoint.y;
                        f2 = f4 + this.stack[n4++];
                        f5 = f3 + this.stack[n4++];
                        flPoint.x = f2 + this.stack[n4++];
                        flPoint.y = f5;
                        generalPath.curveTo(f4, f3, f2, f5, flPoint.x, flPoint.y);
                    }
                    flPoint.open = true;
                    this.stackptr = 0;
                    continue block48;
                }
                case 29: {
                    n3 = this.pos;
                    int n4 = (int)this.stack[--this.stackptr] + this.gsubrsoffset;
                    Range range3 = this.getIndexEntry(this.gsubrbase, n4);
                    this.parseGlyph(range3, generalPath, flPoint);
                    this.pos = n3;
                    continue block48;
                }
                case 30: {
                    n3 = 4;
                }
                case 31: {
                    int n5;
                    float f5;
                    float f2;
                    float f3;
                    float f4;
                    int n4 = 0;
                    while (n4 < this.stackptr) {
                        n5 = (n4 + n3 & 4) == 0 ? 1 : 0;
                        f4 = flPoint.x + (n5 != 0 ? this.stack[n4++] : 0.0f);
                        f3 = flPoint.y + (n5 != 0 ? 0.0f : this.stack[n4++]);
                        f2 = f4 + this.stack[n4++];
                        f5 = f3 + this.stack[n4++];
                        flPoint.x = f2 + (n5 != 0 ? 0.0f : this.stack[n4++]);
                        flPoint.y = f5 + (n5 != 0 ? this.stack[n4++] : 0.0f);
                        if (n4 == this.stackptr - 1) {
                            if (n5 != 0) {
                                flPoint.x += this.stack[n4++];
                            } else {
                                flPoint.y += this.stack[n4++];
                            }
                        }
                        generalPath.curveTo(f4, f3, f2, f5, flPoint.x, flPoint.y);
                    }
                    flPoint.open = true;
                    this.stackptr = 0;
                    continue block48;
                }
                case 1000: {
                    this.stackptr = 0;
                    continue block48;
                }
                case 1003: {
                    float f4 = this.stack[--this.stackptr];
                    float f3 = this.stack[--this.stackptr];
                    this.stack[this.stackptr++] = f4 != 0.0f && f3 != 0.0f ? 1.0f : 0.0f;
                    continue block48;
                }
                case 1004: {
                    float f4 = this.stack[--this.stackptr];
                    float f3 = this.stack[--this.stackptr];
                    this.stack[this.stackptr++] = f4 != 0.0f || f3 != 0.0f ? 1.0f : 0.0f;
                    continue block48;
                }
                case 1005: {
                    float f4 = this.stack[--this.stackptr];
                    this.stack[this.stackptr++] = f4 == 0.0f ? 1.0f : 0.0f;
                    continue block48;
                }
                case 1009: {
                    this.stack[this.stackptr - 1] = Math.abs(this.stack[this.stackptr - 1]);
                    continue block48;
                }
                case 1010: {
                    float f4 = this.stack[--this.stackptr];
                    float f3 = this.stack[--this.stackptr];
                    this.stack[this.stackptr++] = f4 + f3;
                    continue block48;
                }
                case 1011: {
                    float f4 = this.stack[--this.stackptr];
                    float f3 = this.stack[--this.stackptr];
                    this.stack[this.stackptr++] = f3 - f4;
                    continue block48;
                }
                case 1012: {
                    float f4 = this.stack[--this.stackptr];
                    float f3 = this.stack[--this.stackptr];
                    this.stack[this.stackptr++] = f3 / f4;
                    continue block48;
                }
                case 1014: {
                    this.stack[this.stackptr - 1] = -this.stack[this.stackptr - 1];
                    continue block48;
                }
                case 1015: {
                    float f4 = this.stack[--this.stackptr];
                    float f3 = this.stack[--this.stackptr];
                    this.stack[this.stackptr++] = f4 == f3 ? 1.0f : 0.0f;
                    continue block48;
                }
                case 1018: {
                    --this.stackptr;
                    continue block48;
                }
                case 1020: {
                    float f4;
                    int n4 = (int)this.stack[--this.stackptr];
                    this.temps[n4] = f4 = this.stack[--this.stackptr];
                    continue block48;
                }
                case 1021: {
                    int n4 = (int)this.stack[--this.stackptr];
                    this.stack[this.stackptr++] = this.temps[n4];
                    continue block48;
                }
                case 1022: {
                    if (this.stack[this.stackptr - 2] > this.stack[this.stackptr - 1]) {
                        this.stack[this.stackptr - 4] = this.stack[this.stackptr - 3];
                    }
                    this.stackptr -= 3;
                    continue block48;
                }
                case 1023: {
                    this.stack[this.stackptr++] = (float)Math.random();
                    continue block48;
                }
                case 1024: {
                    float f4 = this.stack[--this.stackptr];
                    float f3 = this.stack[--this.stackptr];
                    this.stack[this.stackptr++] = f3 * f4;
                    continue block48;
                }
                case 1026: {
                    this.stack[this.stackptr - 1] = (float)Math.sqrt(this.stack[this.stackptr - 1]);
                    continue block48;
                }
                case 1027: {
                    float f4 = this.stack[this.stackptr - 1];
                    this.stack[this.stackptr++] = f4;
                    continue block48;
                }
                case 1028: {
                    float f4 = this.stack[this.stackptr - 1];
                    this.stack[this.stackptr - 1] = this.stack[this.stackptr - 2];
                    this.stack[this.stackptr - 2] = f4;
                    continue block48;
                }
                case 1029: {
                    int n4 = (int)this.stack[this.stackptr - 1];
                    if (n4 < 0) {
                        n4 = 0;
                    }
                    this.stack[this.stackptr - 1] = this.stack[this.stackptr - 2 - n4];
                    continue block48;
                }
                case 1030: {
                    int n4 = (int)this.stack[--this.stackptr];
                    int n5 = (int)this.stack[--this.stackptr];
                    n4 = n4 > 0 ? (n4 %= n5) : n5 - -n4 % n5;
                    if (n4 <= 0) continue block48;
                    float[] fArray = new float[n5];
                    System.arraycopy(this.stack, this.stackptr - 1 - n4, fArray, 0, n4);
                    System.arraycopy(this.stack, this.stackptr - 1 - n5, fArray, n4, n5 - n4);
                    System.arraycopy(fArray, 0, this.stack, this.stackptr - 1 - n5, n5);
                    continue block48;
                }
                case 1034: {
                    float f;
                    float f4 = flPoint.x + this.stack[0];
                    float f3 = f = flPoint.y;
                    float f2 = f4 + this.stack[1];
                    float f5 = f3 + this.stack[2];
                    flPoint.x = f2 + this.stack[3];
                    flPoint.y = f5;
                    generalPath.curveTo(f4, f3, f2, f5, flPoint.x, flPoint.y);
                    f4 = flPoint.x + this.stack[4];
                    f3 = flPoint.y;
                    f2 = f4 + this.stack[5];
                    f5 = f;
                    flPoint.x = f2 + this.stack[6];
                    flPoint.y = f5;
                    generalPath.curveTo(f4, f3, f2, f5, flPoint.x, flPoint.y);
                    flPoint.open = true;
                    this.stackptr = 0;
                    continue block48;
                }
                case 1035: {
                    float f4 = flPoint.x + this.stack[0];
                    float f3 = flPoint.y + this.stack[1];
                    float f2 = f4 + this.stack[2];
                    float f5 = f3 + this.stack[3];
                    flPoint.x = f2 + this.stack[4];
                    flPoint.y = f5 + this.stack[5];
                    generalPath.curveTo(f4, f3, f2, f5, flPoint.x, flPoint.y);
                    f4 = flPoint.x + this.stack[6];
                    f3 = flPoint.y + this.stack[7];
                    f2 = f4 + this.stack[8];
                    f5 = f3 + this.stack[9];
                    flPoint.x = f2 + this.stack[10];
                    flPoint.y = f5 + this.stack[11];
                    generalPath.curveTo(f4, f3, f2, f5, flPoint.x, flPoint.y);
                    flPoint.open = true;
                    this.stackptr = 0;
                    continue block48;
                }
                case 1036: {
                    float f = flPoint.y;
                    float f4 = flPoint.x + this.stack[0];
                    float f3 = flPoint.y + this.stack[1];
                    float f2 = f4 + this.stack[2];
                    float f5 = f3 + this.stack[3];
                    flPoint.x = f2 + this.stack[4];
                    flPoint.y = f5;
                    generalPath.curveTo(f4, f3, f2, f5, flPoint.x, flPoint.y);
                    f4 = flPoint.x + this.stack[5];
                    f3 = flPoint.y;
                    f2 = f4 + this.stack[6];
                    f5 = f3 + this.stack[7];
                    flPoint.x = f2 + this.stack[8];
                    flPoint.y = f;
                    generalPath.curveTo(f4, f3, f2, f5, flPoint.x, flPoint.y);
                    flPoint.open = true;
                    this.stackptr = 0;
                    continue block48;
                }
                case 1037: {
                    float f = flPoint.y;
                    float f6 = flPoint.x;
                    float f4 = flPoint.x + this.stack[0];
                    float f3 = flPoint.y + this.stack[1];
                    float f2 = f4 + this.stack[2];
                    float f5 = f3 + this.stack[3];
                    flPoint.x = f2 + this.stack[4];
                    flPoint.y = f5 + this.stack[5];
                    generalPath.curveTo(f4, f3, f2, f5, flPoint.x, flPoint.y);
                    f4 = flPoint.x + this.stack[6];
                    f3 = flPoint.y + this.stack[7];
                    f2 = f4 + this.stack[8];
                    f5 = f3 + this.stack[9];
                    if (Math.abs(f2 - f6) > Math.abs(f5 - f)) {
                        flPoint.x = f2 + this.stack[10];
                        flPoint.y = f;
                    } else {
                        flPoint.x = f6;
                        flPoint.y = f5 + this.stack[10];
                    }
                    generalPath.curveTo(f4, f3, f2, f5, flPoint.x, flPoint.y);
                    flPoint.open = true;
                    this.stackptr = 0;
                    continue block48;
                }
            }
            System.out.println("ERROR! TYPE1C CHARSTRING CMD IS " + n2);
        }
    }

    @Override
    protected GeneralPath getOutline(String string, float f) {
        int n = this.getNameIndex(string);
        for (int i = 0; i < this.glyphnames.length; ++i) {
            if (this.glyphnames[i] != n) continue;
            return this.readGlyph(this.charstringbase, i);
        }
        return this.readGlyph(this.charstringbase, 0);
    }

    @Override
    protected GeneralPath getOutline(char c, float f) {
        int n = c & 0xFF;
        if (this.encodingbase == 0 || this.encodingbase == 1) {
            for (int i = 0; i < this.glyphnames.length; ++i) {
                if (this.glyphnames[i] != this.encoding[n]) continue;
                return this.readGlyph(this.charstringbase, i);
            }
        } else if (n > 0 && n < this.encoding.length) {
            return this.readGlyph(this.charstringbase, this.encoding[n]);
        }
        return this.readGlyph(this.charstringbase, 0);
    }

    class Range {
        private int start;
        private int len;

        public Range(int n, int n2) {
            this.start = n;
            this.len = n2;
        }

        public final int getStart() {
            return this.start;
        }

        public final int getLen() {
            return this.len;
        }

        public final int getEnd() {
            return this.start + this.len;
        }

        public String toString() {
            return "Range: start: " + this.start + ", len: " + this.len;
        }
    }
}

