/*
 * Decompiled with CFR 0.152.
 */
package com.sun.pdfview.font;

import com.sun.pdfview.PDFObject;
import com.sun.pdfview.PDFParseException;
import com.sun.pdfview.font.BuiltinFont;
import com.sun.pdfview.font.CIDFontType2;
import com.sun.pdfview.font.PDFFontDescriptor;
import com.sun.pdfview.font.PDFFontEncoding;
import com.sun.pdfview.font.PDFGlyph;
import com.sun.pdfview.font.TTFFont;
import com.sun.pdfview.font.Type0Font;
import com.sun.pdfview.font.Type1CFont;
import com.sun.pdfview.font.Type1Font;
import com.sun.pdfview.font.Type3Font;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class PDFFont {
    private String subtype;
    private String baseFont;
    private PDFFontEncoding encoding;
    private PDFFontDescriptor descriptor;
    private byte[] unicodeMap;
    private Map<Character, PDFGlyph> charCache;

    public static synchronized PDFFont getFont(PDFObject pDFObject, HashMap<String, PDFObject> hashMap) throws IOException {
        PDFFont pDFFont = (PDFFont)pDFObject.getCache();
        if (pDFFont != null) {
            return pDFFont;
        }
        String string = null;
        PDFFontEncoding pDFFontEncoding = null;
        PDFFontDescriptor pDFFontDescriptor = null;
        byte[] byArray = null;
        String string2 = pDFObject.getDictRef("Subtype").getStringValue();
        if (string2 == null) {
            string2 = pDFObject.getDictRef("S").getStringValue();
        }
        PDFObject pDFObject2 = pDFObject.getDictRef("BaseFont");
        PDFObject pDFObject3 = pDFObject.getDictRef("Encoding");
        PDFObject pDFObject4 = pDFObject.getDictRef("FontDescriptor");
        PDFObject pDFObject5 = pDFObject.getDictRef("ToUnicode");
        if (pDFObject2 != null) {
            string = pDFObject2.getStringValue();
        } else {
            pDFObject2 = pDFObject.getDictRef("Name");
            if (pDFObject2 != null) {
                string = pDFObject2.getStringValue();
            }
        }
        if (pDFObject3 != null) {
            pDFFontEncoding = new PDFFontEncoding(string2, pDFObject3);
        }
        pDFFontDescriptor = pDFObject4 != null ? new PDFFontDescriptor(pDFObject4) : new PDFFontDescriptor(string);
        if (pDFObject5 != null && pDFObject5.getType() == 7) {
            byArray = pDFObject5.getStream();
        }
        if (string2.equals("Type0")) {
            pDFFont = new Type0Font(string, pDFObject, pDFFontDescriptor);
        } else if (string2.equals("Type1")) {
            pDFFont = pDFFontDescriptor == null ? new BuiltinFont(string, pDFObject) : (pDFFontDescriptor.getFontFile() != null ? new Type1Font(string, pDFObject, pDFFontDescriptor) : (pDFFontDescriptor.getFontFile3() != null ? new Type1CFont(string, pDFObject, pDFFontDescriptor) : new BuiltinFont(string, pDFObject, pDFFontDescriptor)));
        } else if (string2.equals("TrueType")) {
            pDFFont = pDFFontDescriptor.getFontFile2() != null ? new TTFFont(string, pDFObject, pDFFontDescriptor) : new BuiltinFont(string, pDFObject, pDFFontDescriptor);
        } else if (string2.equals("Type3")) {
            pDFFont = new Type3Font(string, pDFObject, hashMap, pDFFontDescriptor);
        } else if (string2.equals("CIDFontType2") && pDFFontDescriptor.getFontFile2() != null) {
            pDFFont = new CIDFontType2(string, pDFObject, pDFFontDescriptor);
        } else if (string2.equals("CIDFontType0") && pDFFontDescriptor.getFontFile2() != null) {
            pDFFont = new CIDFontType2(string, pDFObject, pDFFontDescriptor);
        } else {
            throw new PDFParseException("Don't know how to handle a '" + string2 + "' font");
        }
        pDFFont.setSubtype(string2);
        pDFFont.setEncoding(pDFFontEncoding);
        pDFFont.setUnicodeMap(byArray);
        pDFObject.setCache(pDFFont);
        return pDFFont;
    }

    public String getSubtype() {
        return this.subtype;
    }

    public void setSubtype(String string) {
        this.subtype = string;
    }

    public String getBaseFont() {
        return this.baseFont;
    }

    public void setBaseFont(String string) {
        this.baseFont = string;
    }

    public PDFFontEncoding getEncoding() {
        return this.encoding;
    }

    public void setEncoding(PDFFontEncoding pDFFontEncoding) {
        this.encoding = pDFFontEncoding;
    }

    public PDFFontDescriptor getDescriptor() {
        return this.descriptor;
    }

    public void setDescriptor(PDFFontDescriptor pDFFontDescriptor) {
        this.descriptor = pDFFontDescriptor;
    }

    public byte[] getUnicodeMap() {
        return this.unicodeMap;
    }

    public void setUnicodeMap(byte[] byArray) {
        this.unicodeMap = byArray;
    }

    public List<PDFGlyph> getGlyphs(String string) {
        List<PDFGlyph> list = null;
        if (this.encoding != null) {
            list = this.encoding.getGlyphs(this, string);
        } else {
            char[] cArray = string.toCharArray();
            list = new ArrayList<PDFGlyph>(cArray.length);
            for (int i = 0; i < cArray.length; ++i) {
                char c = (char)(cArray[i] & 0xFF);
                list.add(this.getCachedGlyph(c, null));
            }
        }
        return list;
    }

    public PDFGlyph getCachedGlyph(char c, String string) {
        PDFGlyph pDFGlyph;
        if (this.charCache == null) {
            this.charCache = new HashMap<Character, PDFGlyph>();
        }
        if ((pDFGlyph = this.charCache.get(new Character(c))) == null) {
            pDFGlyph = this.getGlyph(c, string);
            this.charCache.put(new Character(c), pDFGlyph);
        }
        return pDFGlyph;
    }

    protected PDFFont(String string, PDFFontDescriptor pDFFontDescriptor) {
        this.setBaseFont(string);
        this.setDescriptor(pDFFontDescriptor);
    }

    protected abstract PDFGlyph getGlyph(char var1, String var2);

    public String toString() {
        return this.getBaseFont();
    }

    public boolean equals(Object object) {
        if (!(object instanceof PDFFont)) {
            return false;
        }
        return ((PDFFont)object).getBaseFont().equals(this.getBaseFont());
    }

    public int hashCode() {
        return this.getBaseFont().hashCode();
    }
}

