/*
 * Decompiled with CFR 0.152.
 */
package com.sun.pdfview;

import com.sun.pdfview.BaseWatchable;
import com.sun.pdfview.PDFFile;
import com.sun.pdfview.PDFImage;
import com.sun.pdfview.PDFObject;
import com.sun.pdfview.PDFPage;
import com.sun.pdfview.PDFPaint;
import com.sun.pdfview.PDFParseException;
import com.sun.pdfview.PDFTextFormat;
import com.sun.pdfview.colorspace.PDFColorSpace;
import com.sun.pdfview.colorspace.PatternSpace;
import com.sun.pdfview.font.PDFFont;
import com.sun.pdfview.pattern.PDFShader;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Stack;

public class PDFParser
extends BaseWatchable {
    public static final String DEBUG_DCTDECODE_DATA = "debugdctdecode";
    private Stack<Object> stack;
    private Stack<ParserState> parserStates;
    private ParserState state;
    private GeneralPath path;
    private int clip;
    private int loc;
    private boolean resend = false;
    private Tok tok;
    private boolean catchexceptions;
    private WeakReference pageRef;
    private PDFPage cmds;
    byte[] stream;
    HashMap<String, PDFObject> resources;
    public static int debuglevel = 4000;
    boolean errorwritten = false;

    public static void debug(String string, int n) {
        if (n > debuglevel) {
            System.out.println(PDFParser.escape(string));
        }
    }

    public static String escape(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < string.length(); ++i) {
            int n = string.charAt(i);
            if (n != 10 && (n < 32 || n >= 127)) {
                n = 63;
            }
            stringBuffer.append((char)n);
        }
        return stringBuffer.toString();
    }

    public static void setDebugLevel(int n) {
        debuglevel = n;
    }

    public PDFParser(PDFPage pDFPage, byte[] byArray, HashMap<String, PDFObject> hashMap) {
        this.pageRef = new WeakReference<PDFPage>(pDFPage);
        this.resources = hashMap;
        if (hashMap == null) {
            this.resources = new HashMap();
        }
        this.stream = byArray;
    }

    private void throwback() {
        this.resend = true;
    }

    private Tok nextToken() {
        if (this.resend) {
            this.resend = false;
            return this.tok;
        }
        this.tok = new Tok();
        while (this.loc < this.stream.length && PDFFile.isWhiteSpace(this.stream[this.loc])) {
            ++this.loc;
        }
        if (this.loc >= this.stream.length) {
            this.tok.type = -1;
            return this.tok;
        }
        byte by = this.stream[this.loc++];
        while (by == 37) {
            StringBuffer stringBuffer = new StringBuffer();
            while (this.loc < this.stream.length && by != 10) {
                stringBuffer.append((char)by);
                by = this.stream[this.loc++];
            }
            if (this.loc < this.stream.length && (by = this.stream[this.loc++]) == 13) {
                by = this.stream[this.loc++];
            }
            PDFParser.debug("Read comment: " + stringBuffer.toString(), -1);
        }
        if (by == 91) {
            this.tok.type = 9;
        } else if (by == 93) {
            this.tok.type = 8;
        } else if (by == 40) {
            this.tok.type = 7;
            this.tok.name = this.readString();
        } else if (by == 123) {
            this.tok.type = 5;
        } else if (by == 125) {
            this.tok.type = 4;
        } else if (by == 60 && this.stream[this.loc++] == 60) {
            this.tok.type = 11;
        } else if (by == 62 && this.stream[this.loc++] == 62) {
            this.tok.type = 10;
        } else if (by == 60) {
            --this.loc;
            this.tok.type = 7;
            this.tok.name = this.readByteArray();
        } else if (by == 47) {
            this.tok.type = 1;
            this.tok.name = this.readName();
        } else if (by == 46 || by == 45 || by >= 48 && by <= 57) {
            --this.loc;
            this.tok.type = 3;
            this.tok.value = this.readNum();
        } else if (by >= 97 && by <= 122 || by >= 65 && by <= 90 || by == 39 || by == 34) {
            --this.loc;
            this.tok.type = 2;
            this.tok.name = this.readName();
        } else {
            System.out.println("Encountered character: " + by + " (" + (char)by + ")");
            this.tok.type = 0;
        }
        PDFParser.debug("Read token: " + this.tok, -1);
        return this.tok;
    }

    private String readName() {
        int n = this.loc;
        while (this.loc < this.stream.length && PDFFile.isRegularCharacter(this.stream[this.loc])) {
            ++this.loc;
        }
        return new String(this.stream, n, this.loc - n);
    }

    private double readNum() {
        double d;
        boolean bl;
        block5: {
            byte by;
            bl = (by = this.stream[this.loc++]) == 45;
            boolean bl2 = by == 46;
            double d2 = bl2 ? 0.1 : 1.0;
            double d3 = d = by >= 48 && by <= 57 ? (double)(by - 48) : 0.0;
            while (true) {
                if ((by = this.stream[this.loc++]) == 46) {
                    if (bl2) {
                        --this.loc;
                        break block5;
                    }
                    bl2 = true;
                    d2 = 0.1;
                    continue;
                }
                if (by < 48 || by > 57) break;
                int n = by - 48;
                if (bl2) {
                    d += (double)n * d2;
                    d2 *= 0.1;
                    continue;
                }
                d = d * 10.0 + (double)n;
            }
            --this.loc;
        }
        if (bl) {
            d = -d;
        }
        return d;
    }

    private String readString() {
        int n = this.loc;
        int n2 = 0;
        StringBuffer stringBuffer = new StringBuffer();
        while (this.loc < this.stream.length) {
            int n3;
            if ((n3 = this.stream[this.loc++]) == 41) {
                if (n2-- == 0) {
                    break;
                }
            } else if (n3 == 40) {
                ++n2;
            } else if (n3 == 92) {
                if ((n3 = this.stream[this.loc++]) >= 48 && n3 <= 57) {
                    int n4 = 0;
                    for (int i = 0; n3 >= 48 && n3 <= 57 && i < 3; ++i) {
                        n4 = n4 * 8 + n3 - 48;
                        n3 = this.stream[this.loc++];
                    }
                    --this.loc;
                    n3 = n4;
                } else if (n3 == 110) {
                    n3 = 10;
                } else if (n3 == 114) {
                    n3 = 13;
                } else if (n3 == 116) {
                    n3 = 9;
                } else if (n3 == 98) {
                    n3 = 8;
                } else if (n3 == 102) {
                    n3 = 12;
                } else if (n3 == 92) {
                    n3 = 92;
                } else if (n3 == 40) {
                    n3 = 40;
                } else if (n3 == 41) {
                    n3 = 41;
                }
            }
            stringBuffer.append((char)n3);
        }
        return stringBuffer.toString();
    }

    private String readByteArray() {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        char c = '\u0000';
        while (this.loc < this.stream.length && this.stream[this.loc] != 62) {
            char c2 = (char)this.stream[this.loc];
            byte by = 0;
            if (c2 >= '0' && c2 <= '9') {
                by = (byte)(c2 - 48);
            } else if (c2 >= 'a' && c2 <= 'f') {
                by = (byte)(10 + (c2 - 97));
            } else if (c2 >= 'A' && c2 <= 'F') {
                by = (byte)(10 + (c2 - 65));
            } else {
                ++this.loc;
                continue;
            }
            int n2 = 1 - n % 2;
            c = (char)(c | (0xF & by) << n2 * 4);
            if (n2 == 0) {
                stringBuffer.append(c);
                c = '\u0000';
            }
            ++n;
            ++this.loc;
        }
        ++this.loc;
        return stringBuffer.toString();
    }

    @Override
    public void setup() {
        this.stack = new Stack();
        this.parserStates = new Stack();
        this.state = new ParserState();
        this.path = new GeneralPath();
        this.loc = 0;
        this.clip = 0;
        this.state.fillCS = PDFColorSpace.getColorSpace(0);
        this.state.strokeCS = PDFColorSpace.getColorSpace(0);
        this.state.textFormat = new PDFTextFormat();
    }

    @Override
    public int iterate() throws Exception {
        this.cmds = (PDFPage)this.pageRef.get();
        if (this.cmds == null) {
            System.out.println("Page gone.  Stopping");
            return 5;
        }
        Object object = this.parseObject();
        if (object == null) {
            return 6;
        }
        if (object instanceof Tok) {
            String string = ((Tok)object).name;
            PDFParser.debug("Command: " + string + " (stack size is " + this.stack.size() + ")", 0);
            if (string.equals("q")) {
                this.parserStates.push((ParserState)this.state.clone());
                this.cmds.addPush();
            } else if (string.equals("Q")) {
                this.processQCmd();
            } else if (string.equals("cm")) {
                float[] fArray = this.popFloat(6);
                AffineTransform affineTransform = new AffineTransform(fArray);
                this.cmds.addXform(affineTransform);
            } else if (string.equals("w")) {
                this.cmds.addStrokeWidth(this.popFloat());
            } else if (string.equals("J")) {
                this.cmds.addEndCap(this.popInt());
            } else if (string.equals("j")) {
                this.cmds.addLineJoin(this.popInt());
            } else if (string.equals("M")) {
                this.cmds.addMiterLimit(this.popInt());
            } else if (string.equals("d")) {
                float f = this.popFloat();
                float[] fArray = this.popFloatArray();
                this.cmds.addDash(fArray, f);
            } else if (!string.equals("ri")) {
                if (string.equals("i")) {
                    this.popFloat();
                } else if (string.equals("gs")) {
                    this.setGSState(this.popString());
                } else if (string.equals("m")) {
                    float f = this.popFloat();
                    float f2 = this.popFloat();
                    this.path.moveTo(f2, f);
                } else if (string.equals("l")) {
                    float f = this.popFloat();
                    float f3 = this.popFloat();
                    this.path.lineTo(f3, f);
                } else if (string.equals("c")) {
                    float[] fArray = this.popFloat(6);
                    this.path.curveTo(fArray[0], fArray[1], fArray[2], fArray[3], fArray[4], fArray[5]);
                } else if (string.equals("v")) {
                    float[] fArray = this.popFloat(4);
                    Point2D point2D = this.path.getCurrentPoint();
                    this.path.curveTo((float)point2D.getX(), (float)point2D.getY(), fArray[0], fArray[1], fArray[2], fArray[3]);
                } else if (string.equals("y")) {
                    float[] fArray = this.popFloat(4);
                    this.path.curveTo(fArray[0], fArray[1], fArray[2], fArray[3], fArray[2], fArray[3]);
                } else if (string.equals("h")) {
                    this.path.closePath();
                } else if (string.equals("re")) {
                    float[] fArray = this.popFloat(4);
                    this.path.moveTo(fArray[0], fArray[1]);
                    this.path.lineTo(fArray[0] + fArray[2], fArray[1]);
                    this.path.lineTo(fArray[0] + fArray[2], fArray[1] + fArray[3]);
                    this.path.lineTo(fArray[0], fArray[1] + fArray[3]);
                    this.path.closePath();
                } else if (string.equals("S")) {
                    this.cmds.addPath(this.path, 1 | this.clip);
                    this.clip = 0;
                    this.path = new GeneralPath();
                } else if (string.equals("s")) {
                    this.path.closePath();
                    this.cmds.addPath(this.path, 1 | this.clip);
                    this.clip = 0;
                    this.path = new GeneralPath();
                } else if (string.equals("f") || string.equals("F")) {
                    this.cmds.addPath(this.path, 2 | this.clip);
                    this.clip = 0;
                    this.path = new GeneralPath();
                } else if (string.equals("f*")) {
                    this.path.setWindingRule(0);
                    this.cmds.addPath(this.path, 2 | this.clip);
                    this.clip = 0;
                    this.path = new GeneralPath();
                } else if (string.equals("B")) {
                    this.cmds.addPath(this.path, 3 | this.clip);
                    this.clip = 0;
                    this.path = new GeneralPath();
                } else if (string.equals("B*")) {
                    this.path.setWindingRule(0);
                    this.cmds.addPath(this.path, 3 | this.clip);
                    this.clip = 0;
                    this.path = new GeneralPath();
                } else if (string.equals("b")) {
                    this.path.closePath();
                    this.cmds.addPath(this.path, 3 | this.clip);
                    this.clip = 0;
                    this.path = new GeneralPath();
                } else if (string.equals("b*")) {
                    this.path.closePath();
                    this.path.setWindingRule(0);
                    this.cmds.addPath(this.path, 3 | this.clip);
                    this.clip = 0;
                    this.path = new GeneralPath();
                } else if (string.equals("n")) {
                    if (this.clip != 0) {
                        this.cmds.addPath(this.path, this.clip);
                    }
                    this.clip = 0;
                    this.path = new GeneralPath();
                } else if (string.equals("W")) {
                    this.clip = 4;
                } else if (string.equals("W*")) {
                    this.path.setWindingRule(0);
                    this.clip = 4;
                } else if (string.equals("sh")) {
                    String string2 = this.popString();
                    PDFObject pDFObject = this.findResource(string2, "Shading");
                    this.doShader(pDFObject);
                } else if (string.equals("CS")) {
                    this.state.strokeCS = this.parseColorSpace(new PDFObject(this.stack.pop()));
                } else if (string.equals("cs")) {
                    this.state.fillCS = this.parseColorSpace(new PDFObject(this.stack.pop()));
                } else if (string.equals("SC")) {
                    int n = this.state.strokeCS.getNumComponents();
                    this.cmds.addStrokePaint(this.state.strokeCS.getPaint(this.popFloat(n)));
                } else if (string.equals("SCN")) {
                    if (this.state.strokeCS instanceof PatternSpace) {
                        this.cmds.addFillPaint(this.doPattern((PatternSpace)this.state.strokeCS));
                    } else {
                        int n = this.state.strokeCS.getNumComponents();
                        this.cmds.addStrokePaint(this.state.strokeCS.getPaint(this.popFloat(n)));
                    }
                } else if (string.equals("sc")) {
                    int n = this.state.fillCS.getNumComponents();
                    this.cmds.addFillPaint(this.state.fillCS.getPaint(this.popFloat(n)));
                } else if (string.equals("scn")) {
                    if (this.state.fillCS instanceof PatternSpace) {
                        this.cmds.addFillPaint(this.doPattern((PatternSpace)this.state.fillCS));
                    } else {
                        int n = this.state.fillCS.getNumComponents();
                        this.cmds.addFillPaint(this.state.fillCS.getPaint(this.popFloat(n)));
                    }
                } else if (string.equals("G")) {
                    this.state.strokeCS = PDFColorSpace.getColorSpace(0);
                    this.cmds.addStrokePaint(this.state.strokeCS.getPaint(this.popFloat(1)));
                } else if (string.equals("g")) {
                    this.state.fillCS = PDFColorSpace.getColorSpace(0);
                    this.cmds.addFillPaint(this.state.fillCS.getPaint(this.popFloat(1)));
                } else if (string.equals("RG")) {
                    this.state.strokeCS = PDFColorSpace.getColorSpace(1);
                    this.cmds.addStrokePaint(this.state.strokeCS.getPaint(this.popFloat(3)));
                } else if (string.equals("rg")) {
                    this.state.fillCS = PDFColorSpace.getColorSpace(1);
                    this.cmds.addFillPaint(this.state.fillCS.getPaint(this.popFloat(3)));
                } else if (string.equals("K")) {
                    this.state.strokeCS = PDFColorSpace.getColorSpace(2);
                    this.cmds.addStrokePaint(this.state.strokeCS.getPaint(this.popFloat(4)));
                } else if (string.equals("k")) {
                    this.state.fillCS = PDFColorSpace.getColorSpace(2);
                    this.cmds.addFillPaint(this.state.fillCS.getPaint(this.popFloat(4)));
                } else if (string.equals("Do")) {
                    PDFObject pDFObject = this.findResource(this.popString(), "XObject");
                    this.doXObject(pDFObject);
                } else if (string.equals("BT")) {
                    this.processBTCmd();
                } else if (string.equals("ET")) {
                    this.state.textFormat.end();
                } else if (string.equals("Tc")) {
                    this.state.textFormat.setCharSpacing(this.popFloat());
                } else if (string.equals("Tw")) {
                    this.state.textFormat.setWordSpacing(this.popFloat());
                } else if (string.equals("Tz")) {
                    this.state.textFormat.setHorizontalScale(this.popFloat());
                } else if (string.equals("TL")) {
                    this.state.textFormat.setLeading(this.popFloat());
                } else if (string.equals("Tf")) {
                    float f = this.popFloat();
                    String string3 = this.popString();
                    this.state.textFormat.setFont(this.getFontFrom(string3), f);
                } else if (string.equals("Tr")) {
                    this.state.textFormat.setMode(this.popInt());
                } else if (string.equals("Ts")) {
                    this.state.textFormat.setRise(this.popFloat());
                } else if (string.equals("Td")) {
                    float f = this.popFloat();
                    float f4 = this.popFloat();
                    this.state.textFormat.carriageReturn(f4, f);
                } else if (string.equals("TD")) {
                    float f = this.popFloat();
                    float f5 = this.popFloat();
                    this.state.textFormat.setLeading(-f);
                    this.state.textFormat.carriageReturn(f5, f);
                } else if (string.equals("Tm")) {
                    this.state.textFormat.setMatrix(this.popFloat(6));
                } else if (string.equals("T*")) {
                    this.state.textFormat.carriageReturn();
                } else if (string.equals("Tj")) {
                    this.state.textFormat.doText(this.cmds, this.popString());
                } else if (string.equals("'")) {
                    this.state.textFormat.carriageReturn();
                    this.state.textFormat.doText(this.cmds, this.popString());
                } else if (string.equals("\"")) {
                    String string4 = this.popString();
                    float f = this.popFloat();
                    float f6 = this.popFloat();
                    this.state.textFormat.setWordSpacing(f6);
                    this.state.textFormat.setCharSpacing(f);
                    this.state.textFormat.doText(this.cmds, string4);
                } else if (string.equals("TJ")) {
                    this.state.textFormat.doText(this.cmds, this.popArray());
                } else if (string.equals("BI")) {
                    this.parseInlineImage();
                } else if (string.equals("BX")) {
                    this.catchexceptions = true;
                } else if (string.equals("EX")) {
                    this.catchexceptions = false;
                } else if (string.equals("MP")) {
                    this.popString();
                } else if (string.equals("DP")) {
                    Object object2 = this.stack.pop();
                    this.popString();
                } else if (string.equals("BMC")) {
                    this.popString();
                } else if (string.equals("BDC")) {
                    Object object3 = this.stack.pop();
                    this.popString();
                } else if (!string.equals("EMC")) {
                    if (string.equals("d0")) {
                        this.popFloat(2);
                    } else if (string.equals("d1")) {
                        this.popFloat(6);
                    } else if (string.equals("QBT")) {
                        this.processQCmd();
                        this.processBTCmd();
                    } else if (this.catchexceptions) {
                        PDFParser.debug("**** WARNING: Unknown command: " + string + " **************************", 10);
                    } else {
                        throw new PDFParseException("Unknown command: " + string);
                    }
                }
            }
            if (this.stack.size() != 0) {
                PDFParser.debug("**** WARNING! Stack not zero! (cmd=" + string + ", size=" + this.stack.size() + ") *************************", 4);
                this.stack.setSize(0);
            }
        } else {
            this.stack.push(object);
        }
        this.cmds = null;
        return 4;
    }

    private void processQCmd() {
        this.cmds.addPop();
        this.state = this.parserStates.pop();
    }

    private void processBTCmd() {
        this.state.textFormat.reset();
    }

    @Override
    public void cleanup() {
        this.state.textFormat.flush();
        this.cmds.finish();
        this.stack = null;
        this.parserStates = null;
        this.state = null;
        this.path = null;
        this.cmds = null;
    }

    public void dumpStreamToError() {
        if (this.errorwritten) {
            return;
        }
        this.errorwritten = true;
        try {
            File file = File.createTempFile("PDFError", ".err");
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            fileOutputStream.write(this.stream);
            fileOutputStream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public String dumpStream() {
        return PDFParser.escape(new String(this.stream).replace('\r', '\n'));
    }

    public static void emitDataFile(byte[] byArray, String string) {
        try {
            File file = File.createTempFile("DateFile", string);
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            System.out.println("Write: " + file.getPath());
            fileOutputStream.write(byArray);
            fileOutputStream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private PDFObject findResource(String string, String string2) throws IOException {
        if (string2 != null) {
            PDFObject pDFObject = this.resources.get(string2);
            if (pDFObject == null || pDFObject.getType() != 6) {
                throw new PDFParseException("No dictionary called " + string2 + " found in the resources");
            }
            return pDFObject.getDictRef(string);
        }
        return this.resources.get(string);
    }

    private void doXObject(PDFObject pDFObject) throws IOException {
        String string = pDFObject.getDictRef("Subtype").getStringValue();
        if (string == null) {
            string = pDFObject.getDictRef("S").getStringValue();
        }
        if (string.equals("Image")) {
            this.doImage(pDFObject);
        } else if (string.equals("Form")) {
            this.doForm(pDFObject);
        } else {
            throw new PDFParseException("Unknown XObject subtype: " + string);
        }
    }

    private void doImage(PDFObject pDFObject) throws IOException {
        this.cmds.addImage(PDFImage.createImage(pDFObject, this.resources));
    }

    private void doForm(PDFObject pDFObject) throws IOException {
        PDFPage pDFPage = (PDFPage)pDFObject.getCache();
        if (pDFPage == null) {
            Object object;
            AffineTransform affineTransform;
            PDFObject pDFObject2 = pDFObject.getDictRef("Matrix");
            if (pDFObject2 == null) {
                affineTransform = new AffineTransform();
            } else {
                object = new float[6];
                for (int i = 0; i < ((float[])object).length; ++i) {
                    object[i] = pDFObject2.getAt(i).getFloatValue();
                }
                affineTransform = new AffineTransform((float[])object);
            }
            object = pDFObject.getDictRef("BBox");
            Rectangle2D.Float float_ = new Rectangle2D.Float(((PDFObject)object).getAt(0).getFloatValue(), ((PDFObject)object).getAt(1).getFloatValue(), ((PDFObject)object).getAt(2).getFloatValue(), ((PDFObject)object).getAt(3).getFloatValue());
            pDFPage = new PDFPage(float_, 0);
            pDFPage.addXform(affineTransform);
            HashMap<String, PDFObject> hashMap = new HashMap<String, PDFObject>(this.resources);
            PDFObject pDFObject3 = pDFObject.getDictRef("Resources");
            if (pDFObject3 != null) {
                hashMap.putAll(pDFObject3.getDictionary());
            }
            PDFParser pDFParser = new PDFParser(pDFPage, pDFObject.getStream(), hashMap);
            pDFParser.go(true);
            pDFObject.setCache(pDFPage);
        }
        this.cmds.addPush();
        this.cmds.addCommands(pDFPage);
        this.cmds.addPop();
    }

    private PDFPaint doPattern(PatternSpace patternSpace) throws IOException {
        float[] fArray = null;
        String string = this.popString();
        PDFObject pDFObject = this.findResource(string, "Pattern");
        if (pDFObject == null) {
            throw new PDFParseException("Unknown pattern : " + string);
        }
        if (this.stack.size() > 0) {
            fArray = this.popFloat(this.stack.size());
        }
        return patternSpace.getPaint(pDFObject, fArray, this.resources);
    }

    private Object parseObject() throws PDFParseException {
        Tok tok = this.nextToken();
        if (tok.type == 3) {
            return new Double(this.tok.value);
        }
        if (tok.type == 7) {
            return this.tok.name;
        }
        if (tok.type == 1) {
            return this.tok.name;
        }
        if (tok.type == 11) {
            Object object;
            HashMap<String, PDFObject> hashMap = new HashMap<String, PDFObject>();
            String string = null;
            while ((object = this.parseObject()) != null) {
                if (string == null) {
                    string = (String)object;
                    continue;
                }
                hashMap.put(string, new PDFObject(object));
                string = null;
            }
            if (this.tok.type != 10) {
                throw new PDFParseException("Inline dict should have ended with '>>'");
            }
            return hashMap;
        }
        if (tok.type == 9) {
            Object object;
            ArrayList<Object> arrayList = new ArrayList<Object>();
            while ((object = this.parseObject()) != null) {
                arrayList.add(object);
            }
            if (this.tok.type != 8) {
                throw new PDFParseException("Expected ']'");
            }
            return arrayList.toArray();
        }
        if (tok.type == 2) {
            return tok;
        }
        PDFParser.debug("**** WARNING! parseObject unknown token! (t.type=" + tok.type + ") *************************", 4);
        return null;
    }

    private void parseInlineImage() throws IOException {
        Object object;
        Double[] doubleArray;
        Object object2;
        HashMap<String, PDFObject> hashMap = new HashMap<String, PDFObject>();
        while (true) {
            object2 = this.nextToken();
            if (((Tok)object2).type == 2 && ((Tok)object2).name.equals("ID")) break;
            doubleArray = ((Tok)object2).name;
            PDFParser.debug("ParseInlineImage, token: " + (String)doubleArray, 1000);
            if (doubleArray.equals("BPC")) {
                doubleArray = "BitsPerComponent";
            } else if (doubleArray.equals("CS")) {
                doubleArray = "ColorSpace";
            } else if (doubleArray.equals("D")) {
                doubleArray = "Decode";
            } else if (doubleArray.equals("DP")) {
                doubleArray = "DecodeParms";
            } else if (doubleArray.equals("F")) {
                doubleArray = "Filter";
            } else if (doubleArray.equals("H")) {
                doubleArray = "Height";
            } else if (doubleArray.equals("IM")) {
                doubleArray = "ImageMask";
            } else if (doubleArray.equals("W")) {
                doubleArray = "Width";
            } else if (doubleArray.equals("I")) {
                doubleArray = "Interpolate";
            }
            object = this.parseObject();
            hashMap.put((String)doubleArray, new PDFObject(object));
        }
        if (this.stream[this.loc] == 13) {
            ++this.loc;
        }
        if (this.stream[this.loc] == 10 || this.stream[this.loc] == 32) {
            ++this.loc;
        }
        if ((object2 = (PDFObject)hashMap.get("ImageMask")) != null && ((PDFObject)object2).getBooleanValue()) {
            doubleArray = new Double[]{new Double(0.0), new Double(1.0)};
            object = (PDFObject)hashMap.get("Decode");
            if (object != null) {
                doubleArray[0] = new Double(((PDFObject)object).getAt(0).getDoubleValue());
                doubleArray[1] = new Double(((PDFObject)object).getAt(1).getDoubleValue());
            }
            hashMap.put("Decode", new PDFObject(doubleArray));
        }
        doubleArray = new PDFObject(null, 6, hashMap);
        int n = this.loc;
        while (!this.isEndOfImageData(this.stream, this.loc)) {
            ++this.loc;
        }
        byte[] byArray = new byte[this.loc - n];
        System.arraycopy(this.stream, n, byArray, 0, this.loc - n);
        doubleArray.setStream(ByteBuffer.wrap(byArray));
        this.loc += 3;
        this.doImage((PDFObject)doubleArray);
    }

    private boolean isEndOfImageData(byte[] byArray, int n) {
        if (n + 3 >= byArray.length) {
            return true;
        }
        if (byArray[n + 1] == 69 && byArray[n + 2] == 73 && byArray[n + 3] == 10) {
            return true;
        }
        return PDFFile.isWhiteSpace(byArray[n]) && byArray[n + 1] == 69 && byArray[n + 2] == 73 && PDFFile.isWhiteSpace(byArray[n + 3]);
    }

    private void doShader(PDFObject pDFObject) throws IOException {
        PDFShader pDFShader = PDFShader.getShader(pDFObject, this.resources);
        this.cmds.addPush();
        Rectangle2D rectangle2D = pDFShader.getBBox();
        if (rectangle2D != null) {
            this.cmds.addFillPaint(pDFShader.getPaint());
            this.cmds.addPath(new GeneralPath(rectangle2D), 2);
        }
        this.cmds.addPop();
    }

    private PDFFont getFontFrom(String string) throws IOException {
        PDFObject pDFObject = this.findResource(string, "Font");
        return PDFFont.getFont(pDFObject, this.resources);
    }

    private void setGSState(String string) throws IOException {
        PDFObject pDFObject = this.findResource(string, "ExtGState");
        PDFObject pDFObject2 = pDFObject.getDictRef("LW");
        if (pDFObject2 != null) {
            this.cmds.addStrokeWidth(pDFObject2.getFloatValue());
        }
        if ((pDFObject2 = pDFObject.getDictRef("LC")) != null) {
            this.cmds.addEndCap(pDFObject2.getIntValue());
        }
        if ((pDFObject2 = pDFObject.getDictRef("LJ")) != null) {
            this.cmds.addLineJoin(pDFObject2.getIntValue());
        }
        if ((pDFObject2 = pDFObject.getDictRef("Font")) != null) {
            this.state.textFormat.setFont(this.getFontFrom(pDFObject2.getAt(0).getStringValue()), pDFObject2.getAt(1).getFloatValue());
        }
        if ((pDFObject2 = pDFObject.getDictRef("ML")) != null) {
            this.cmds.addMiterLimit(pDFObject2.getFloatValue());
        }
        if ((pDFObject2 = pDFObject.getDictRef("D")) != null) {
            PDFObject[] pDFObjectArray = pDFObject2.getAt(0).getArray();
            float[] fArray = new float[pDFObjectArray.length];
            for (int i = 0; i < pDFObjectArray.length; ++i) {
                fArray[i] = pDFObjectArray[i].getFloatValue();
            }
            this.cmds.addDash(fArray, pDFObject2.getAt(1).getFloatValue());
        }
        if ((pDFObject2 = pDFObject.getDictRef("CA")) != null) {
            this.cmds.addStrokeAlpha(pDFObject2.getFloatValue());
        }
        if ((pDFObject2 = pDFObject.getDictRef("ca")) != null) {
            this.cmds.addFillAlpha(pDFObject2.getFloatValue());
        }
    }

    private PDFColorSpace parseColorSpace(PDFObject pDFObject) throws IOException {
        if (pDFObject == null) {
            return this.state.fillCS;
        }
        return PDFColorSpace.getColorSpace(pDFObject, this.resources);
    }

    private float popFloat() throws PDFParseException {
        Object object = this.stack.pop();
        if (object instanceof Double) {
            return ((Double)object).floatValue();
        }
        throw new PDFParseException("Expected a number here.");
    }

    private float[] popFloat(int n) throws PDFParseException {
        float[] fArray = new float[n];
        for (int i = n - 1; i >= 0; --i) {
            fArray[i] = this.popFloat();
        }
        return fArray;
    }

    private int popInt() throws PDFParseException {
        Object object = this.stack.pop();
        if (object instanceof Double) {
            return ((Double)object).intValue();
        }
        throw new PDFParseException("Expected a number here.");
    }

    private float[] popFloatArray() throws PDFParseException {
        Object object = this.stack.pop();
        if (!(object instanceof Object[])) {
            throw new PDFParseException("Expected an [array] here.");
        }
        Object[] objectArray = (Object[])object;
        float[] fArray = new float[objectArray.length];
        for (int i = 0; i < fArray.length; ++i) {
            if (!(objectArray[i] instanceof Double)) {
                throw new PDFParseException("This array doesn't consist only of floats.");
            }
            fArray[i] = ((Double)objectArray[i]).floatValue();
        }
        return fArray;
    }

    private String popString() throws PDFParseException {
        Object object = this.stack.pop();
        if (!(object instanceof String)) {
            throw new PDFParseException("Expected string here: " + object.toString());
        }
        return (String)object;
    }

    private PDFObject popObject() throws PDFParseException {
        Object object = this.stack.pop();
        if (!(object instanceof PDFObject)) {
            throw new PDFParseException("Expected a reference here: " + object.toString());
        }
        return (PDFObject)object;
    }

    private Object[] popArray() throws PDFParseException {
        Object object = this.stack.pop();
        if (!(object instanceof Object[])) {
            throw new PDFParseException("Expected an [array] here: " + object.toString());
        }
        return (Object[])object;
    }

    class ParserState
    implements Cloneable {
        PDFColorSpace fillCS;
        PDFColorSpace strokeCS;
        PDFTextFormat textFormat;

        ParserState() {
        }

        public Object clone() {
            ParserState parserState = new ParserState();
            parserState.fillCS = this.fillCS;
            parserState.strokeCS = this.strokeCS;
            parserState.textFormat = (PDFTextFormat)this.textFormat.clone();
            return parserState;
        }
    }

    class Tok {
        public static final int BRKB = 11;
        public static final int BRKE = 10;
        public static final int ARYB = 9;
        public static final int ARYE = 8;
        public static final int STR = 7;
        public static final int BRCB = 5;
        public static final int BRCE = 4;
        public static final int NUM = 3;
        public static final int CMD = 2;
        public static final int NAME = 1;
        public static final int UNK = 0;
        public static final int EOF = -1;
        public String name;
        public double value;
        public int type;

        Tok() {
        }

        public String toString() {
            if (this.type == 3) {
                return "NUM: " + this.value;
            }
            if (this.type == 2) {
                return "CMD: " + this.name;
            }
            if (this.type == 0) {
                return "UNK";
            }
            if (this.type == -1) {
                return "EOF";
            }
            if (this.type == 1) {
                return "NAME: " + this.name;
            }
            if (this.type == 2) {
                return "CMD: " + this.name;
            }
            if (this.type == 7) {
                return "STR: (" + this.name;
            }
            if (this.type == 9) {
                return "ARY [";
            }
            if (this.type == 8) {
                return "ARY ]";
            }
            return "some kind of brace (" + this.type + ")";
        }
    }
}

