/*
 * Decompiled with CFR 0.152.
 */
package com.sun.pdfview;

import com.sun.pdfview.BaseWatchable;
import com.sun.pdfview.Cache;
import com.sun.pdfview.ImageInfo;
import com.sun.pdfview.PDFChangeStrokeCmd;
import com.sun.pdfview.PDFCmd;
import com.sun.pdfview.PDFFillAlphaCmd;
import com.sun.pdfview.PDFFillPaintCmd;
import com.sun.pdfview.PDFImage;
import com.sun.pdfview.PDFImageCmd;
import com.sun.pdfview.PDFPaint;
import com.sun.pdfview.PDFPopCmd;
import com.sun.pdfview.PDFPushCmd;
import com.sun.pdfview.PDFRenderer;
import com.sun.pdfview.PDFShapeCmd;
import com.sun.pdfview.PDFStrokeAlphaCmd;
import com.sun.pdfview.PDFStrokePaintCmd;
import com.sun.pdfview.PDFXformCmd;
import com.sun.pdfview.RefImage;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.ImageObserver;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PDFPage {
    private List<PDFCmd> commands;
    private boolean finished = false;
    private int pageNumber;
    private Rectangle2D bbox;
    private int rotation;
    private Cache cache;
    private Map<ImageInfo, WeakReference> renderers;

    public PDFPage(Rectangle2D rectangle2D, int n) {
        this(-1, rectangle2D, n, null);
    }

    public PDFPage(int n, Rectangle2D rectangle2D, int n2, Cache cache) {
        this.pageNumber = n;
        this.cache = cache;
        if (rectangle2D == null) {
            rectangle2D = new Rectangle2D.Float(0.0f, 0.0f, 1.0f, 1.0f);
        }
        if (n2 < 0) {
            n2 += 360;
        }
        this.rotation = n2;
        if (n2 == 90 || n2 == 270) {
            rectangle2D = new Rectangle2D.Double(rectangle2D.getX(), rectangle2D.getY(), rectangle2D.getHeight(), rectangle2D.getWidth());
        }
        this.bbox = rectangle2D;
        this.renderers = Collections.synchronizedMap(new HashMap());
        this.commands = Collections.synchronizedList(new ArrayList(250));
    }

    public Dimension getUnstretchedSize(int n, int n2, Rectangle2D rectangle2D) {
        if (rectangle2D == null) {
            rectangle2D = this.bbox;
        } else if (this.getRotation() == 90 || this.getRotation() == 270) {
            rectangle2D = new Rectangle2D.Double(rectangle2D.getX(), rectangle2D.getY(), rectangle2D.getHeight(), rectangle2D.getWidth());
        }
        double d = rectangle2D.getHeight() / rectangle2D.getWidth();
        double d2 = (double)n2 / (double)n;
        if (d2 > d) {
            n2 = (int)((double)n * d + 0.5);
        } else {
            n = (int)((double)n2 / d + 0.5);
        }
        return new Dimension(n, n2);
    }

    public Image getImage(int n, int n2, Rectangle2D rectangle2D, ImageObserver imageObserver) {
        return this.getImage(n, n2, rectangle2D, imageObserver, true, false);
    }

    public Image getImage(int n, int n2, Rectangle2D rectangle2D, ImageObserver imageObserver, boolean bl, boolean bl2) {
        BufferedImage bufferedImage = null;
        BaseWatchable baseWatchable = null;
        ImageInfo imageInfo = new ImageInfo(n, n2, rectangle2D, null);
        if (this.cache != null) {
            bufferedImage = this.cache.getImage(this, imageInfo);
            baseWatchable = this.cache.getImageRenderer(this, imageInfo);
        }
        if (bufferedImage == null) {
            if (bl) {
                imageInfo.bgColor = Color.WHITE;
            }
            bufferedImage = new RefImage(imageInfo.width, imageInfo.height, 2);
            baseWatchable = new PDFRenderer(this, imageInfo, bufferedImage);
            if (this.cache != null) {
                this.cache.addImage(this, imageInfo, bufferedImage, (PDFRenderer)baseWatchable);
            }
            this.renderers.put(imageInfo, new WeakReference<BaseWatchable>(baseWatchable));
        }
        if (baseWatchable != null) {
            if (imageObserver != null) {
                ((PDFRenderer)baseWatchable).addObserver(imageObserver);
            }
            if (!baseWatchable.isFinished()) {
                baseWatchable.go(bl2);
            }
        }
        return bufferedImage;
    }

    public int getPageNumber() {
        return this.pageNumber;
    }

    public float getAspectRatio() {
        return this.getWidth() / this.getHeight();
    }

    public Rectangle2D getBBox() {
        return this.bbox;
    }

    public float getWidth() {
        return (float)this.bbox.getWidth();
    }

    public float getHeight() {
        return (float)this.bbox.getHeight();
    }

    public int getRotation() {
        return this.rotation;
    }

    public AffineTransform getInitialTransform(int n, int n2, Rectangle2D rectangle2D) {
        AffineTransform affineTransform = new AffineTransform();
        switch (this.getRotation()) {
            case 0: {
                affineTransform = new AffineTransform(1.0f, 0.0f, 0.0f, -1.0f, 0.0f, n2);
                break;
            }
            case 90: {
                affineTransform = new AffineTransform(0.0f, 1.0f, 1.0f, 0.0f, 0.0f, 0.0f);
                break;
            }
            case 180: {
                affineTransform = new AffineTransform(-1.0f, 0.0f, 0.0f, 1.0f, n, 0.0f);
                break;
            }
            case 270: {
                affineTransform = new AffineTransform(0.0f, -1.0f, -1.0f, 0.0f, n, n2);
            }
        }
        if (rectangle2D == null) {
            rectangle2D = this.getBBox();
        } else if (this.getRotation() == 90 || this.getRotation() == 270) {
            int n3 = n;
            n = n2;
            n2 = n3;
        }
        double d = (double)n / rectangle2D.getWidth();
        double d2 = (double)n2 / rectangle2D.getHeight();
        affineTransform.scale(d, d2);
        affineTransform.translate(-rectangle2D.getMinX(), -rectangle2D.getMinY());
        return affineTransform;
    }

    public int getCommandCount() {
        return this.commands.size();
    }

    public PDFCmd getCommand(int n) {
        return this.commands.get(n);
    }

    public List<PDFCmd> getCommands() {
        return this.commands;
    }

    public List getCommands(int n) {
        return this.getCommands(n, this.getCommandCount());
    }

    public List getCommands(int n, int n2) {
        return this.commands.subList(n, n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addCommand(PDFCmd pDFCmd) {
        List<PDFCmd> list = this.commands;
        synchronized (list) {
            this.commands.add(pDFCmd);
        }
        this.updateImages();
    }

    public void addCommands(PDFPage pDFPage) {
        this.addCommands(pDFPage, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addCommands(PDFPage pDFPage, AffineTransform affineTransform) {
        List<PDFCmd> list = this.commands;
        synchronized (list) {
            this.addPush();
            if (affineTransform != null) {
                this.addXform(affineTransform);
            }
            this.commands.addAll(pDFPage.getCommands());
            this.addPop();
        }
        this.updateImages();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearCommands() {
        List<PDFCmd> list = this.commands;
        synchronized (list) {
            this.commands.clear();
        }
        this.updateImages();
    }

    public boolean isFinished() {
        return this.finished;
    }

    public synchronized void waitForFinish() throws InterruptedException {
        if (!this.finished) {
            this.wait();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop(int n, int n2, Rectangle2D rectangle2D) {
        ImageInfo imageInfo = new ImageInfo(n, n2, rectangle2D);
        Map<ImageInfo, WeakReference> map = this.renderers;
        synchronized (map) {
            PDFRenderer pDFRenderer;
            WeakReference weakReference = this.renderers.get(imageInfo);
            if (weakReference != null && (pDFRenderer = (PDFRenderer)weakReference.get()) != null) {
                pDFRenderer.stop();
            }
        }
    }

    public synchronized void finish() {
        this.finished = true;
        this.notifyAll();
        this.updateImages();
    }

    public void addPush() {
        this.addCommand(new PDFPushCmd());
    }

    public void addPop() {
        this.addCommand(new PDFPopCmd());
    }

    public void addXform(AffineTransform affineTransform) {
        this.addCommand(new PDFXformCmd(new AffineTransform(affineTransform)));
    }

    public void addStrokeWidth(float f) {
        PDFChangeStrokeCmd pDFChangeStrokeCmd = new PDFChangeStrokeCmd();
        pDFChangeStrokeCmd.setWidth(f);
        this.addCommand(pDFChangeStrokeCmd);
    }

    public void addEndCap(int n) {
        PDFChangeStrokeCmd pDFChangeStrokeCmd = new PDFChangeStrokeCmd();
        int n2 = 0;
        switch (n) {
            case 0: {
                n2 = 0;
                break;
            }
            case 1: {
                n2 = 1;
                break;
            }
            case 2: {
                n2 = 2;
            }
        }
        pDFChangeStrokeCmd.setEndCap(n2);
        this.addCommand(pDFChangeStrokeCmd);
    }

    public void addLineJoin(int n) {
        PDFChangeStrokeCmd pDFChangeStrokeCmd = new PDFChangeStrokeCmd();
        int n2 = 0;
        switch (n) {
            case 0: {
                n2 = 0;
                break;
            }
            case 1: {
                n2 = 1;
                break;
            }
            case 2: {
                n2 = 2;
            }
        }
        pDFChangeStrokeCmd.setLineJoin(n2);
        this.addCommand(pDFChangeStrokeCmd);
    }

    public void addMiterLimit(float f) {
        PDFChangeStrokeCmd pDFChangeStrokeCmd = new PDFChangeStrokeCmd();
        pDFChangeStrokeCmd.setMiterLimit(f);
        this.addCommand(pDFChangeStrokeCmd);
    }

    public void addDash(float[] fArray, float f) {
        PDFChangeStrokeCmd pDFChangeStrokeCmd = new PDFChangeStrokeCmd();
        pDFChangeStrokeCmd.setDash(fArray, f);
        this.addCommand(pDFChangeStrokeCmd);
    }

    public void addPath(GeneralPath generalPath, int n) {
        this.addCommand(new PDFShapeCmd(generalPath, n));
    }

    public void addFillPaint(PDFPaint pDFPaint) {
        this.addCommand(new PDFFillPaintCmd(pDFPaint));
    }

    public void addStrokePaint(PDFPaint pDFPaint) {
        this.addCommand(new PDFStrokePaintCmd(pDFPaint));
    }

    public void addFillAlpha(float f) {
        this.addCommand(new PDFFillAlphaCmd(f));
    }

    public void addStrokeAlpha(float f) {
        this.addCommand(new PDFStrokeAlphaCmd(f));
    }

    public void addImage(PDFImage pDFImage) {
        this.addCommand(new PDFImageCmd(pDFImage));
    }

    public void updateImages() {
        for (WeakReference weakReference : this.renderers.values()) {
            PDFRenderer pDFRenderer = (PDFRenderer)weakReference.get();
            if (pDFRenderer == null || pDFRenderer.getStatus() != 3) continue;
            pDFRenderer.setStatus(2);
        }
    }
}

