/*
 * Decompiled with CFR 0.152.
 */
package com.sun.pdfview.pattern;

import com.sun.pdfview.PDFObject;
import com.sun.pdfview.PDFPaint;
import com.sun.pdfview.PDFParseException;
import com.sun.pdfview.colorspace.PDFColorSpace;
import com.sun.pdfview.pattern.ShaderType2;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.util.Map;

public abstract class PDFShader {
    public static final int FUNCTION_SHADING = 1;
    public static final int AXIAL_SHADING = 2;
    public static final int RADIAL_SHADING = 3;
    public static final int FREE_FORM_SHADING = 4;
    public static final int LATTICE_SHADING = 5;
    public static final int COONS_PATCH_MESH_SHADING = 6;
    public static final int TENSOR_PRODUCTS_MESH_SHADING = 7;
    private int type;
    private PDFColorSpace colorSpace;
    private PDFPaint background;
    private Rectangle2D bbox;

    protected PDFShader(int n) {
        this.type = n;
    }

    public static PDFShader getShader(PDFObject pDFObject, Map map) throws IOException {
        Object[] objectArray;
        Object object;
        PDFShader pDFShader = (PDFShader)pDFObject.getCache();
        if (pDFShader != null) {
            return pDFShader;
        }
        PDFObject pDFObject2 = pDFObject.getDictRef("ShadingType");
        if (pDFObject2 == null) {
            throw new PDFParseException("No shader type defined!");
        }
        int n = pDFObject2.getIntValue();
        switch (n) {
            case 2: {
                pDFShader = new ShaderType2();
                break;
            }
            default: {
                throw new PDFParseException("Unsupported shader type: " + n);
            }
        }
        PDFObject pDFObject3 = pDFObject.getDictRef("ColorSpace");
        if (pDFObject3 == null) {
            throw new PDFParseException("No colorspace defined!");
        }
        PDFColorSpace pDFColorSpace = PDFColorSpace.getColorSpace(pDFObject3, map);
        pDFShader.setColorSpace(pDFColorSpace);
        PDFObject pDFObject4 = pDFObject.getDictRef("Background");
        if (pDFObject4 != null) {
            object = pDFObject4.getArray();
            objectArray = new float[((PDFObject[])object).length];
            for (int i = 0; i < objectArray.length; ++i) {
                objectArray[i] = ((PDFObject)object[i]).getFloatValue();
            }
            PDFPaint pDFPaint = pDFColorSpace.getPaint((float[])objectArray);
            pDFShader.setBackground(pDFPaint);
        }
        if ((object = pDFObject.getDictRef("BBox")) != null) {
            objectArray = ((PDFObject)object).getArray();
            float f = objectArray[0].getFloatValue();
            float f2 = objectArray[1].getFloatValue();
            float f3 = objectArray[2].getFloatValue();
            float f4 = objectArray[3].getFloatValue();
            Rectangle2D.Float float_ = new Rectangle2D.Float(f, f2, f3 - f, f4 - f2);
            pDFShader.setBBox(float_);
        }
        pDFShader.parse(pDFObject);
        pDFObject.setCache(pDFShader);
        return pDFShader;
    }

    public int getType() {
        return this.type;
    }

    public PDFColorSpace getColorSpace() {
        return this.colorSpace;
    }

    protected void setColorSpace(PDFColorSpace pDFColorSpace) {
        this.colorSpace = pDFColorSpace;
    }

    public PDFPaint getBackground() {
        return this.background;
    }

    protected void setBackground(PDFPaint pDFPaint) {
        this.background = pDFPaint;
    }

    public Rectangle2D getBBox() {
        return this.bbox;
    }

    protected void setBBox(Rectangle2D rectangle2D) {
        this.bbox = rectangle2D;
    }

    public abstract void parse(PDFObject var1) throws IOException;

    public abstract PDFPaint getPaint();
}

