/*
 * Decompiled with CFR 0.152.
 */
package com.sun.pdfview.font.ttf;

import com.sun.pdfview.font.ttf.Glyf;
import com.sun.pdfview.font.ttf.LocaTable;
import com.sun.pdfview.font.ttf.MaxpTable;
import com.sun.pdfview.font.ttf.TrueTypeFont;
import com.sun.pdfview.font.ttf.TrueTypeTable;
import java.nio.ByteBuffer;

public class GlyfTable
extends TrueTypeTable {
    private Object[] glyphs;
    private LocaTable loca;

    protected GlyfTable(TrueTypeFont trueTypeFont) {
        super(1735162214);
        this.loca = (LocaTable)trueTypeFont.getTable("loca");
        MaxpTable maxpTable = (MaxpTable)trueTypeFont.getTable("maxp");
        int n = maxpTable.getNumGlyphs();
        this.glyphs = new Object[n];
    }

    public Glyf getGlyph(int n) {
        Object object = this.glyphs[n];
        if (object == null) {
            return null;
        }
        if (object instanceof ByteBuffer) {
            Glyf glyf = Glyf.getGlyf((ByteBuffer)object);
            this.glyphs[n] = glyf;
            return glyf;
        }
        return (Glyf)object;
    }

    @Override
    public ByteBuffer getData() {
        int n = this.getLength();
        ByteBuffer byteBuffer = ByteBuffer.allocate(n);
        for (int i = 0; i < this.glyphs.length; ++i) {
            Object object = this.glyphs[i];
            if (object == null) continue;
            ByteBuffer byteBuffer2 = null;
            byteBuffer2 = object instanceof ByteBuffer ? (ByteBuffer)object : ((Glyf)object).getData();
            byteBuffer2.rewind();
            byteBuffer.put(byteBuffer2);
            byteBuffer2.flip();
        }
        byteBuffer.flip();
        return byteBuffer;
    }

    @Override
    public void setData(ByteBuffer byteBuffer) {
        for (int i = 0; i < this.glyphs.length; ++i) {
            int n = this.loca.getOffset(i);
            int n2 = this.loca.getSize(i);
            if (n2 == 0) continue;
            byteBuffer.position(n);
            ByteBuffer byteBuffer2 = byteBuffer.slice();
            byteBuffer2.limit(n2);
            this.glyphs[i] = byteBuffer2;
        }
    }

    @Override
    public int getLength() {
        int n = 0;
        for (int i = 0; i < this.glyphs.length; ++i) {
            Object object = this.glyphs[i];
            if (object == null) continue;
            if (object instanceof ByteBuffer) {
                n += ((ByteBuffer)object).remaining();
                continue;
            }
            n += ((Glyf)object).getLength();
        }
        return n;
    }

    @Override
    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        String string = "    ";
        stringBuffer.append(string + "Glyf Table: (" + this.glyphs.length + " glyphs)\n");
        stringBuffer.append(string + "  Glyf 0: " + this.getGlyph(0));
        return stringBuffer.toString();
    }
}

