/*
 * Decompiled with CFR 0.152.
 */
package com.sun.pdfview.font;

import com.sun.pdfview.PDFObject;
import com.sun.pdfview.font.FontSupport;
import com.sun.pdfview.font.PDFCMap;
import com.sun.pdfview.font.PDFFont;
import com.sun.pdfview.font.PDFGlyph;
import com.sun.pdfview.font.Type0Font;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PDFFontEncoding {
    private static final int TYPE_ENCODING = 0;
    private static final int TYPE_CMAP = 1;
    private int[] baseEncoding;
    private Map<Character, String> differences;
    private PDFCMap cmap;
    private int type;

    public PDFFontEncoding(String string, PDFObject pDFObject) throws IOException {
        if (pDFObject.getType() == 4) {
            if (string.equals("Type0")) {
                this.type = 1;
                this.cmap = PDFCMap.getCMap(pDFObject.getStringValue());
            } else {
                this.type = 0;
                this.differences = new HashMap<Character, String>();
                this.baseEncoding = this.getBaseEncoding(pDFObject.getStringValue());
            }
        } else {
            String string2 = pDFObject.getDictRef("Type").getStringValue();
            if (string2.equals("Encoding")) {
                this.type = 0;
                this.parseEncoding(pDFObject);
            } else if (string2.equals("CMap")) {
                this.type = 1;
                this.cmap = PDFCMap.getCMap(pDFObject);
            } else {
                throw new IllegalArgumentException("Uknown encoding type: " + this.type);
            }
        }
    }

    public List<PDFGlyph> getGlyphs(PDFFont pDFFont, String string) {
        ArrayList<PDFGlyph> arrayList = new ArrayList<PDFGlyph>(string.length());
        char[] cArray = string.toCharArray();
        block4: for (int i = 0; i < cArray.length; ++i) {
            switch (this.type) {
                case 0: {
                    arrayList.add(this.getGlyphFromEncoding(pDFFont, cArray[i]));
                    continue block4;
                }
                case 1: {
                    char c = (char)((cArray[i] & 0xFF) << 8);
                    if (i < cArray.length - 1) {
                        c = (char)(c | (char)(cArray[++i] & 0xFF));
                    }
                    arrayList.add(this.getGlyphFromCMap(pDFFont, c));
                }
            }
        }
        return arrayList;
    }

    private PDFGlyph getGlyphFromEncoding(PDFFont pDFFont, char c) {
        String string = null;
        if (this.differences.containsKey(new Character(c = (char)(c & 0xFF)))) {
            string = this.differences.get(new Character(c));
        } else if (this.baseEncoding != null) {
            int n = this.baseEncoding[c];
            string = FontSupport.getName(n);
        }
        return pDFFont.getCachedGlyph(c, string);
    }

    private PDFGlyph getGlyphFromCMap(PDFFont pDFFont, char c) {
        int n = this.cmap.getFontID(c);
        char c2 = this.cmap.map(c);
        if (pDFFont instanceof Type0Font) {
            pDFFont = ((Type0Font)pDFFont).getDescendantFont(n);
        }
        return pDFFont.getCachedGlyph(c2, null);
    }

    public void parseEncoding(PDFObject pDFObject) throws IOException {
        PDFObject pDFObject2;
        this.differences = new HashMap<Character, String>();
        PDFObject pDFObject3 = pDFObject.getDictRef("BaseEncoding");
        if (pDFObject3 != null) {
            this.baseEncoding = this.getBaseEncoding(pDFObject3.getStringValue());
        }
        if ((pDFObject2 = pDFObject.getDictRef("Differences")) != null) {
            PDFObject[] pDFObjectArray = pDFObject2.getArray();
            int n = -1;
            for (int i = 0; i < pDFObjectArray.length; ++i) {
                if (pDFObjectArray[i].getType() == 2) {
                    n = pDFObjectArray[i].getIntValue();
                    continue;
                }
                if (pDFObjectArray[i].getType() == 4) {
                    Character c = new Character((char)n);
                    this.differences.put(c, pDFObjectArray[i].getStringValue());
                    ++n;
                    continue;
                }
                throw new IllegalArgumentException("Unexpected type in diff array: " + pDFObjectArray[i]);
            }
        }
    }

    private int[] getBaseEncoding(String string) {
        if (string.equals("MacRomanEncoding")) {
            return FontSupport.macRomanEncoding;
        }
        if (string.equals("MacExpertEncoding")) {
            return FontSupport.type1CExpertCharset;
        }
        if (string.equals("WinAnsiEncoding")) {
            return FontSupport.winAnsiEncoding;
        }
        throw new IllegalArgumentException("Unknown encoding: " + string);
    }

    public boolean isTypeCmap() {
        return this.type == 1;
    }
}

