/*
 * Decompiled with CFR 0.152.
 */
package com.sun.pdfview.font;

import com.sun.pdfview.PDFObject;
import com.sun.pdfview.font.NativeFont;
import com.sun.pdfview.font.PDFFontDescriptor;
import com.sun.pdfview.font.Type1Font;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public class BuiltinFont
extends Type1Font {
    private static final String FONT_BASE_URL = "com.sun.pdfview.font.fontBaseURL";
    private static Properties props;
    private static Map<String, byte[]> fonts;
    private static final String[] baseFonts;
    private static final String[] mappedFonts;

    public BuiltinFont(String string, PDFObject pDFObject) throws IOException {
        super(string, pDFObject, null);
        this.parseFont(string);
    }

    public BuiltinFont(String string, PDFObject pDFObject, PDFFontDescriptor pDFFontDescriptor) throws IOException {
        super(string, pDFObject, pDFFontDescriptor);
        int n;
        int n2;
        String string2 = pDFFontDescriptor.getFontName();
        for (n2 = 0; n2 < baseFonts.length; ++n2) {
            if (!string2.equalsIgnoreCase(baseFonts[n2])) continue;
            this.parseFont(string2);
            return;
        }
        for (n2 = 0; n2 < mappedFonts.length; n2 += 2) {
            if (!string2.equalsIgnoreCase(mappedFonts[n2])) continue;
            this.parseFont(mappedFonts[n2 + 1]);
            return;
        }
        n2 = pDFFontDescriptor.getFlags();
        int n3 = n = (n2 & 0x40000) != 0 ? 1 : 0;
        if (string2.indexOf("Bold") > 0) {
            n |= 1;
        }
        if (pDFFontDescriptor.getItalicAngle() != 0 || (n2 & 0x40) != 0) {
            n |= 2;
        }
        String string3 = null;
        string3 = (n2 & 1) != 0 ? ((n & 1) > 0 && (n & 2) > 0 ? "Courier-BoldOblique" : ((n & 1) > 0 ? "Courier-Bold" : ((n & 2) > 0 ? "Courier-Oblique" : "Courier"))) : ((n2 & 2) != 0 ? ((n & 1) > 0 && (n & 2) > 0 ? "Times-BoldItalic" : ((n & 1) > 0 ? "Times-Bold" : ((n & 2) > 0 ? "Times-Italic" : "Times-Roman"))) : ((n & 1) > 0 && (n & 2) > 0 ? "Helvetica-BoldOblique" : ((n & 1) > 0 ? "Helvetica-Bold" : ((n & 2) > 0 ? "Helvetica-Oblique" : "Helvetica"))));
        this.parseFont(string3);
    }

    private void parseFont(String string) throws IOException {
        if (props == null) {
            props = new Properties();
            props.load(BuiltinFont.class.getResourceAsStream("res/BaseFonts.properties"));
        }
        if (!props.containsKey(string + ".file")) {
            throw new IllegalArgumentException("Unknown Base Font: " + string);
        }
        String string2 = props.getProperty(string + ".file");
        int n = Integer.parseInt(props.getProperty(string + ".length"));
        int n2 = 0;
        int n3 = 0;
        byte[] byArray = BuiltinFont.loadFontFile(string2, n);
        if ((byArray[0] & 0xFF) == 128) {
            n2 = byArray[2] & 0xFF;
            n2 |= (byArray[3] & 0xFF) << 8;
            n2 |= (byArray[4] & 0xFF) << 16;
            n2 |= (byArray[5] & 0xFF) << 24;
            n3 = byArray[(n2 += 6) + 2] & 0xFF;
            n3 |= (byArray[n2 + 3] & 0xFF) << 8;
            n3 |= (byArray[n2 + 4] & 0xFF) << 16;
            n3 |= (byArray[n2 + 5] & 0xFF) << 24;
            n2 += 6;
        } else {
            n2 = Integer.parseInt(props.getProperty(string + ".length1"));
            n3 = props.containsKey(string + ".length2") ? Integer.parseInt(props.getProperty(string + ".lenth2")) : n - n2;
        }
        this.parseFont(byArray, n2, n3);
    }

    private static byte[] loadFontFile(String string, int n) throws IOException {
        byte[] byArray = fonts.get(string);
        if (byArray == null) {
            byArray = new byte[n];
            InputStream inputStream = NativeFont.class.getResourceAsStream("res/" + string);
            if (inputStream == null) {
                inputStream = BuiltinFont.getResourceAsStreamFromURL(string);
            }
            for (int i = 0; i < n; i += inputStream.read(byArray, i, n - i)) {
            }
            inputStream.close();
            fonts.put(string, byArray);
        }
        return byArray;
    }

    private static InputStream getResourceAsStreamFromURL(String string) throws IOException {
        String string2 = System.getProperty(FONT_BASE_URL);
        if (string2 == null) {
            return null;
        }
        URL uRL = new URL(string2 + "/" + string);
        return uRL.openStream();
    }

    static {
        fonts = new HashMap<String, byte[]>();
        baseFonts = new String[]{"Courier", "Courier-Bold", "Courier-BoldOblique", "Courier-Oblique", "Helvetica", "Helvetica-Bold", "Helvetica-BoldOblique", "Helvetica-Oblique", "Times-Roman", "Times-Bold", "Times-BoldItalic", "Times-Italic", "Symbol", "ZapfDingbats"};
        mappedFonts = new String[]{"Arial", "Helvetica", "Arial,Bold", "Helvetica-Bold", "Arial,BoldItalic", "Helvetica-BoldOblique", "Arial,Italic", "Helvetica-Oblique", "TimesNewRoman", "Times-Roman", "TimesNewRoman,Bold", "Times-Bold", "TimesNewRoman,BoldItalic", "Times-BoldItalic", "TimesNewRoman,Italic", "Times-Italic"};
    }
}

