/*
 * Decompiled with CFR 0.152.
 */
package com.sun.pdfview.colorspace;

import java.awt.color.ColorSpace;

public class CMYKColorSpace
extends ColorSpace {
    public CMYKColorSpace() {
        super(9, 4);
    }

    @Override
    public float[] fromCIEXYZ(float[] fArray) {
        return new float[3];
    }

    @Override
    public float[] fromRGB(float[] fArray) {
        float[] fArray2 = new float[4];
        float f = 1.0f - fArray[0];
        float f2 = 1.0f - fArray[1];
        float f3 = 1.0f - fArray[2];
        float f4 = Math.min(f, Math.min(f2, f3));
        float f5 = 1.0f - f4;
        if (f5 == 0.0f) {
            f = 1.0f;
            f2 = 1.0f;
            f3 = 1.0f;
        } else {
            f = (f - f4) / f5;
            f2 = (f2 - f4) / f5;
            f3 = (f3 - f4) / f5;
        }
        fArray2[0] = f;
        fArray2[1] = f2;
        fArray2[2] = f3;
        fArray2[3] = f4;
        return fArray2;
    }

    @Override
    public int getNumComponents() {
        return 4;
    }

    @Override
    public String getName(int n) {
        return "CMYK";
    }

    @Override
    public int getType() {
        return 9;
    }

    @Override
    public float[] toCIEXYZ(float[] fArray) {
        return new float[3];
    }

    @Override
    public float[] toRGB(float[] fArray) {
        if (fArray.length == 4) {
            float[] fArray2 = new float[3];
            float f = fArray[3];
            float f2 = 1.0f - f;
            fArray2[0] = 1.0f - (fArray[0] * f2 + f);
            fArray2[1] = 1.0f - (fArray[1] * f2 + f);
            fArray2[2] = 1.0f - (fArray[2] * f2 + f);
            return fArray2;
        }
        return new float[3];
    }
}

