/*
 * Decompiled with CFR 0.152.
 */
package com.sun.pdfview;

import com.sun.pdfview.PDFObject;
import com.sun.pdfview.PDFParseException;
import com.sun.pdfview.colorspace.IndexedColor;
import com.sun.pdfview.colorspace.PDFColorSpace;
import com.sun.pdfview.function.FunctionType0;
import java.awt.Color;
import java.awt.Point;
import java.awt.color.ColorSpace;
import java.awt.color.ICC_ColorSpace;
import java.awt.image.BufferedImage;
import java.awt.image.ColorConvertOp;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.DataBufferByte;
import java.awt.image.IndexColorModel;
import java.awt.image.MultiPixelPackedSampleModel;
import java.awt.image.Raster;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class PDFImage {
    private int[] colorKeyMask = null;
    private int width;
    private int height;
    private PDFColorSpace colorSpace;
    private int bpc;
    private boolean imageMask = false;
    private PDFImage sMask;
    private float[] decode;
    private PDFObject imageObj;

    public static void dump(PDFObject pDFObject) throws IOException {
        PDFImage.p("dumping PDF object: " + pDFObject);
        if (pDFObject == null) {
            return;
        }
        HashMap<String, PDFObject> hashMap = pDFObject.getDictionary();
        PDFImage.p("   dict = " + hashMap);
        for (String string : hashMap.keySet()) {
            PDFImage.p("key = " + string + " value = " + hashMap.get(string));
        }
    }

    public static void p(String string) {
        System.out.println(string);
    }

    protected PDFImage(PDFObject pDFObject) {
        this.imageObj = pDFObject;
    }

    public static PDFImage createImage(PDFObject pDFObject, Map map) throws IOException {
        Object object;
        Object object2;
        Object object3;
        PDFImage pDFImage = new PDFImage(pDFObject);
        PDFObject pDFObject2 = pDFObject.getDictRef("Width");
        if (pDFObject2 == null) {
            throw new PDFParseException("Unable to read image width: " + pDFObject);
        }
        pDFImage.setWidth(pDFObject2.getIntValue());
        PDFObject pDFObject3 = pDFObject.getDictRef("Height");
        if (pDFObject3 == null) {
            throw new PDFParseException("Unable to get image height: " + pDFObject);
        }
        pDFImage.setHeight(pDFObject3.getIntValue());
        PDFObject pDFObject4 = pDFObject.getDictRef("ImageMask");
        if (pDFObject4 != null) {
            pDFImage.setImageMask(pDFObject4.getBooleanValue());
        }
        if (pDFImage.isImageMask()) {
            float f;
            pDFImage.setBitsPerComponent(1);
            object3 = new Color[]{Color.BLACK, Color.WHITE};
            object2 = pDFObject.getDictRef("Decode");
            if (object2 != null && (f = (object = ((PDFObject)object2).getArray())[0].getFloatValue()) == 1.0f) {
                object3 = new Color[]{Color.WHITE, Color.BLACK};
            }
            pDFImage.setColorSpace(new IndexedColor((Color[])object3));
        } else {
            object3 = pDFObject.getDictRef("BitsPerComponent");
            if (object3 == null) {
                throw new PDFParseException("Unable to get bits per component: " + pDFObject);
            }
            pDFImage.setBitsPerComponent(((PDFObject)object3).getIntValue());
            object2 = pDFObject.getDictRef("ColorSpace");
            if (object2 == null) {
                throw new PDFParseException("No ColorSpace for image: " + pDFObject);
            }
            object = PDFColorSpace.getColorSpace((PDFObject)object2, map);
            pDFImage.setColorSpace((PDFColorSpace)object);
        }
        object3 = pDFObject.getDictRef("Decode");
        if (object3 != null) {
            object2 = ((PDFObject)object3).getArray();
            object = new float[((PDFObject[])object2).length];
            for (int i = 0; i < ((PDFObject[])object2).length; ++i) {
                object[i] = (PDFObject)((PDFObject)object2[i]).getFloatValue();
            }
            pDFImage.setDecode((float[])object);
        }
        if (pDFObject4 == null) {
            object2 = pDFObject.getDictRef("SMask");
            if (object2 == null) {
                object2 = pDFObject.getDictRef("Mask");
            }
            if (object2 != null) {
                if (((PDFObject)object2).getType() == 7) {
                    try {
                        object = PDFImage.createImage((PDFObject)object2, map);
                        pDFImage.setSMask((PDFImage)object);
                    }
                    catch (IOException iOException) {
                        PDFImage.p("ERROR: there was a problem parsing the mask for this object");
                        PDFImage.dump(pDFObject);
                        iOException.printStackTrace(System.out);
                    }
                } else if (((PDFObject)object2).getType() == 5) {
                    try {
                        pDFImage.setColorKeyMask((PDFObject)object2);
                    }
                    catch (IOException iOException) {
                        PDFImage.p("ERROR: there was a problem parsing the color mask for this object");
                        PDFImage.dump(pDFObject);
                        iOException.printStackTrace(System.out);
                    }
                }
            }
        }
        return pDFImage;
    }

    public BufferedImage getImage() {
        try {
            BufferedImage bufferedImage = (BufferedImage)this.imageObj.getCache();
            if (bufferedImage == null) {
                bufferedImage = this.parseData(this.imageObj.getStream());
                this.imageObj.setCache(bufferedImage);
            }
            return bufferedImage;
        }
        catch (IOException iOException) {
            System.out.println("Error reading image");
            iOException.printStackTrace();
            return null;
        }
    }

    protected BufferedImage parseData(byte[] byArray) {
        BufferedImage bufferedImage;
        Object object;
        Object object2;
        DataBufferByte dataBufferByte = new DataBufferByte(byArray, byArray.length);
        ColorModel colorModel = this.getColorModel();
        SampleModel sampleModel = colorModel.createCompatibleSampleModel(this.getWidth(), this.getHeight());
        WritableRaster writableRaster = Raster.createWritableRaster(sampleModel, dataBufferByte, new Point(0, 0));
        BufferedImage bufferedImage2 = null;
        if (colorModel instanceof IndexColorModel) {
            object2 = (IndexColorModel)colorModel;
            int n = 12;
            if (this.getBitsPerComponent() == 8) {
                n = 13;
            }
            bufferedImage2 = new BufferedImage(this.getWidth(), this.getHeight(), n, (IndexColorModel)object2);
            bufferedImage2.setData(writableRaster);
        } else {
            bufferedImage2 = new BufferedImage(colorModel, writableRaster, true, null);
        }
        object2 = colorModel.getColorSpace();
        ColorSpace colorSpace = ColorSpace.getInstance(1000);
        if (!this.isImageMask() && object2 instanceof ICC_ColorSpace && !object2.equals(colorSpace)) {
            object = new ColorConvertOp((ColorSpace)object2, colorSpace, null);
            bufferedImage = new BufferedImage(this.getWidth(), this.getHeight(), 2);
            bufferedImage2 = ((ColorConvertOp)object).filter(bufferedImage2, bufferedImage);
        }
        if ((object = this.getSMask()) != null) {
            bufferedImage = ((PDFImage)object).getImage();
            BufferedImage bufferedImage3 = new BufferedImage(this.getWidth(), this.getHeight(), 2);
            int[] nArray = new int[this.width];
            int[] nArray2 = new int[this.width];
            for (int i = 0; i < this.height; ++i) {
                bufferedImage2.getRGB(0, i, this.width, 1, nArray, 0, this.width);
                bufferedImage.getRGB(0, i, this.width, 1, nArray2, 0, this.width);
                for (int j = 0; j < this.width; ++j) {
                    int n = -16777216;
                    nArray2[j] = (nArray2[j] & 0xFF) << 24 | nArray[j] & ~n;
                }
                bufferedImage3.setRGB(0, i, this.width, 1, nArray2, 0, this.width);
            }
            bufferedImage2 = bufferedImage3;
        }
        return bufferedImage2;
    }

    public int getWidth() {
        return this.width;
    }

    protected void setWidth(int n) {
        this.width = n;
    }

    public int getHeight() {
        return this.height;
    }

    protected void setHeight(int n) {
        this.height = n;
    }

    private void setColorKeyMask(PDFObject pDFObject) throws IOException {
        PDFObject[] pDFObjectArray = pDFObject.getArray();
        this.colorKeyMask = null;
        int[] nArray = new int[pDFObjectArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = pDFObjectArray[i].getIntValue();
        }
        this.colorKeyMask = nArray;
    }

    protected PDFColorSpace getColorSpace() {
        return this.colorSpace;
    }

    protected void setColorSpace(PDFColorSpace pDFColorSpace) {
        this.colorSpace = pDFColorSpace;
    }

    protected int getBitsPerComponent() {
        return this.bpc;
    }

    protected void setBitsPerComponent(int n) {
        this.bpc = n;
    }

    public boolean isImageMask() {
        return this.imageMask;
    }

    public void setImageMask(boolean bl) {
        this.imageMask = bl;
    }

    public PDFImage getSMask() {
        return this.sMask;
    }

    protected void setSMask(PDFImage pDFImage) {
        this.sMask = pDFImage;
    }

    protected float[] getDecode() {
        return this.decode;
    }

    protected void setDecode(float[] fArray) {
        this.decode = fArray;
    }

    private ColorModel getColorModel() {
        PDFColorSpace pDFColorSpace = this.getColorSpace();
        if (pDFColorSpace instanceof IndexedColor) {
            int n;
            int n2;
            int n3;
            IndexedColor indexedColor = (IndexedColor)pDFColorSpace;
            byte[] byArray = indexedColor.getColorComponents();
            int n4 = indexedColor.getCount();
            if (this.decode != null) {
                byte[] byArray2 = new byte[byArray.length];
                for (int i = 0; i < n4; ++i) {
                    byte[] byArray3 = new byte[]{(byte)i};
                    float[] fArray = this.normalize(byArray3, null, 0);
                    n3 = (int)fArray[0];
                    byArray2[i * 3] = byArray[n3 * 3];
                    byArray2[i * 3 + 1] = byArray[n3 * 3 + 1];
                    byArray2[i * 3 + 2] = byArray[n3 * 3 + 2];
                }
                byArray = byArray2;
            }
            if ((n2 = 1 << this.getBitsPerComponent()) < n4) {
                byte[] byArray4 = new byte[n2 * 3];
                System.arraycopy(byArray, 0, byArray4, 0, n2 * 3);
                byArray = byArray4;
                n4 = n2;
            }
            if (this.colorKeyMask == null || this.colorKeyMask.length == 0) {
                return new IndexColorModel(this.getBitsPerComponent(), n4, byArray, 0, false);
            }
            byte[] byArray5 = new byte[n4 * 4];
            int n5 = 0;
            for (n = 0; n < n4; ++n) {
                byArray5[n5++] = byArray[n * 3];
                byArray5[n5++] = byArray[n * 3 + 1];
                byArray5[n5++] = byArray[n * 3 + 2];
                byArray5[n5++] = -1;
            }
            for (n = 0; n < this.colorKeyMask.length; n += 2) {
                for (n3 = this.colorKeyMask[n]; n3 <= this.colorKeyMask[n + 1]; ++n3) {
                    byArray5[n3 * 4 + 3] = 0;
                }
            }
            return new IndexColorModel(this.getBitsPerComponent(), n4, byArray5, 0, true);
        }
        int[] nArray = new int[pDFColorSpace.getNumComponents()];
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = this.getBitsPerComponent();
        }
        return new DecodeComponentColorModel(pDFColorSpace.getColorSpace(), nArray);
    }

    private float[] normalize(byte[] byArray, float[] fArray, int n) {
        if (fArray == null) {
            fArray = new float[n + byArray.length];
        }
        float[] fArray2 = this.getDecode();
        for (int i = 0; i < byArray.length; ++i) {
            int n2 = byArray[i] & 0xFF;
            int n3 = (int)Math.pow(2.0, this.getBitsPerComponent()) - 1;
            float f = fArray2[i * 2];
            float f2 = fArray2[i * 2 + 1];
            fArray[n + i] = FunctionType0.interpolate(n2, 0.0f, n3, f, f2);
        }
        return fArray;
    }

    class DecodeComponentColorModel
    extends ComponentColorModel {
        public DecodeComponentColorModel(ColorSpace colorSpace, int[] nArray) {
            super(colorSpace, nArray, false, false, 1, 0);
            if (nArray != null) {
                this.pixel_bits = nArray.length * nArray[0];
            }
        }

        @Override
        public SampleModel createCompatibleSampleModel(int n, int n2) {
            if (this.getNumComponents() == 1 && this.getPixelSize() < 8) {
                return new MultiPixelPackedSampleModel(this.getTransferType(), n, n2, this.getPixelSize());
            }
            return super.createCompatibleSampleModel(n, n2);
        }

        @Override
        public boolean isCompatibleRaster(Raster raster) {
            if (this.getNumComponents() == 1 && this.getPixelSize() < 8) {
                SampleModel sampleModel = raster.getSampleModel();
                if (sampleModel instanceof MultiPixelPackedSampleModel) {
                    return sampleModel.getSampleSize(0) == this.getPixelSize();
                }
                return false;
            }
            return super.isCompatibleRaster(raster);
        }

        @Override
        public float[] getNormalizedComponents(Object object, float[] fArray, int n) {
            if (PDFImage.this.getDecode() == null) {
                return super.getNormalizedComponents(object, fArray, n);
            }
            return PDFImage.this.normalize((byte[])object, fArray, n);
        }
    }
}

