/*
 * Decompiled with CFR 0.152.
 */
package com.sun.pdfview.pattern;

import com.sun.pdfview.PDFObject;
import com.sun.pdfview.PDFPaint;
import com.sun.pdfview.PDFParseException;
import com.sun.pdfview.function.PDFFunction;
import com.sun.pdfview.pattern.PDFShader;
import java.awt.Paint;
import java.awt.PaintContext;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.color.ColorSpace;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.io.IOException;

public class ShaderType2
extends PDFShader {
    private Point2D axisStart;
    private Point2D axisEnd;
    private float minT = 0.0f;
    private float maxT = 1.0f;
    private boolean extendStart = false;
    private boolean extendEnd = false;
    private PDFFunction[] functions;

    public ShaderType2() {
        super(2);
    }

    @Override
    public void parse(PDFObject pDFObject) throws IOException {
        Object object;
        PDFObject pDFObject2 = pDFObject.getDictRef("Coords");
        if (pDFObject2 == null) {
            throw new PDFParseException("No coordinates found!");
        }
        PDFObject[] pDFObjectArray = pDFObject2.getArray();
        Point2D.Float float_ = new Point2D.Float(pDFObjectArray[0].getFloatValue(), pDFObjectArray[1].getFloatValue());
        Point2D.Float float_2 = new Point2D.Float(pDFObjectArray[2].getFloatValue(), pDFObjectArray[3].getFloatValue());
        this.setAxisStart(float_);
        this.setAxisEnd(float_2);
        PDFObject pDFObject3 = pDFObject.getDictRef("Domain");
        if (pDFObject3 != null) {
            object = pDFObject3.getArray();
            this.setMinT(object[0].getFloatValue());
            this.setMaxT(((PDFObject)object[1]).getFloatValue());
        }
        if ((object = pDFObject.getDictRef("Function")) == null) {
            throw new PDFParseException("No function defined for shader!");
        }
        PDFObject[] pDFObjectArray2 = ((PDFObject)object).getArray();
        PDFFunction[] pDFFunctionArray = new PDFFunction[pDFObjectArray2.length];
        for (int i = 0; i < pDFFunctionArray.length; ++i) {
            pDFFunctionArray[i] = PDFFunction.getFunction(pDFObjectArray2[i]);
        }
        this.setFunctions(pDFFunctionArray);
        PDFObject pDFObject4 = pDFObject.getDictRef("Extend");
        if (pDFObject4 != null) {
            PDFObject[] pDFObjectArray3 = pDFObject4.getArray();
            this.setExtendStart(pDFObjectArray3[0].getBooleanValue());
            this.setExtendEnd(pDFObjectArray3[1].getBooleanValue());
        }
    }

    @Override
    public PDFPaint getPaint() {
        return PDFPaint.getPaint(new Type2Paint());
    }

    public Point2D getAxisStart() {
        return this.axisStart;
    }

    protected void setAxisStart(Point2D point2D) {
        this.axisStart = point2D;
    }

    public Point2D getAxisEnd() {
        return this.axisEnd;
    }

    protected void setAxisEnd(Point2D point2D) {
        this.axisEnd = point2D;
    }

    public float getMinT() {
        return this.minT;
    }

    protected void setMinT(float f) {
        this.minT = f;
    }

    public float getMaxT() {
        return this.maxT;
    }

    protected void setMaxT(float f) {
        this.maxT = f;
    }

    public boolean getExtendStart() {
        return this.extendStart;
    }

    protected void setExtendStart(boolean bl) {
        this.extendStart = bl;
    }

    public boolean getExtendEnd() {
        return this.extendEnd;
    }

    protected void setExtendEnd(boolean bl) {
        this.extendEnd = bl;
    }

    public PDFFunction[] getFunctions() {
        return this.functions;
    }

    protected void setFunctions(PDFFunction[] pDFFunctionArray) {
        this.functions = pDFFunctionArray;
    }

    class Type2PaintContext
    implements PaintContext {
        private ColorModel colorModel;
        private Point2D start;
        private Point2D end;

        Type2PaintContext(ColorModel colorModel, Point2D point2D, Point2D point2D2) {
            this.colorModel = colorModel;
            this.start = point2D;
            this.end = point2D2;
        }

        @Override
        public void dispose() {
            this.colorModel = null;
        }

        @Override
        public ColorModel getColorModel() {
            return this.colorModel;
        }

        @Override
        public Raster getRaster(int n, int n2, int n3, int n4) {
            ColorSpace colorSpace = this.getColorModel().getColorSpace();
            PDFFunction[] pDFFunctionArray = ShaderType2.this.getFunctions();
            int n5 = colorSpace.getNumComponents();
            float f = (float)this.start.getX();
            float f2 = (float)this.end.getX();
            float f3 = (float)this.start.getY();
            float f4 = (float)this.end.getY();
            float[] fArray = new float[1];
            float[] fArray2 = new float[n5];
            int[] nArray = new int[n3 * n4 * (n5 + 1)];
            for (int i = 0; i < n4; ++i) {
                for (int j = 0; j < n3 + 8; j += 8) {
                    int n6;
                    float f5;
                    float f6 = this.getXPrime(j + n, i + n2, f, f3, f2, f4);
                    fArray[0] = f5 = this.getT(f6);
                    if (pDFFunctionArray.length == 1) {
                        pDFFunctionArray[0].calculate(fArray, 0, fArray2, 0);
                    } else {
                        for (n6 = 0; n6 < pDFFunctionArray.length; ++n6) {
                            pDFFunctionArray[n6].calculate(fArray, 0, fArray2, n6);
                        }
                    }
                    for (n6 = j; n6 < j + 8 && n6 < n3; ++n6) {
                        int n7 = (i * n3 + n6) * (n5 + 1);
                        for (int k = 0; k < n5; ++k) {
                            nArray[n7 + k] = (int)(fArray2[k] * 255.0f);
                        }
                        nArray[n7 + n5] = 255;
                    }
                }
            }
            WritableRaster writableRaster = this.getColorModel().createCompatibleWritableRaster(n3, n4);
            writableRaster.setPixels(0, 0, n3, n4, nArray);
            Raster raster = writableRaster.createTranslatedChild(n, n2);
            return raster;
        }

        private float getXPrime(float f, float f2, float f3, float f4, float f5, float f6) {
            double d = (double)((f5 - f3) * (f - f3) + (f6 - f4) * (f2 - f4)) / (Math.pow(f5 - f3, 2.0) + Math.pow(f6 - f4, 2.0));
            return (float)d;
        }

        private float getT(float f) {
            float f2 = ShaderType2.this.getMinT();
            float f3 = ShaderType2.this.getMaxT();
            if (f < 0.0f) {
                return f2;
            }
            if (f > 1.0f) {
                return f3;
            }
            return f2 + (f3 - f2) * f;
        }
    }

    class Type2Paint
    implements Paint {
        @Override
        public PaintContext createContext(ColorModel colorModel, Rectangle rectangle, Rectangle2D rectangle2D, AffineTransform affineTransform, RenderingHints renderingHints) {
            ColorSpace colorSpace = ColorSpace.getInstance(1000);
            ComponentColorModel componentColorModel = new ComponentColorModel(colorSpace, true, false, 3, 0);
            Point2D point2D = affineTransform.transform(ShaderType2.this.getAxisStart(), null);
            Point2D point2D2 = affineTransform.transform(ShaderType2.this.getAxisEnd(), null);
            return new Type2PaintContext(componentColorModel, point2D, point2D2);
        }

        @Override
        public int getTransparency() {
            return 3;
        }
    }
}

