/*
 * Decompiled with CFR 0.152.
 */
package com.sun.pdfview.font.ttf;

import com.sun.pdfview.font.ttf.TrueTypeTable;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.SortedMap;
import java.util.TreeMap;

public class NameTable
extends TrueTypeTable {
    public static final short PLATFORMID_UNICODE = 0;
    public static final short PLATFORMID_MACINTOSH = 1;
    public static final short PLATFORMID_MICROSOFT = 3;
    public static final short ENCODINGID_MAC_ROMAN = 0;
    public static final short ENCODINGID_UNICODE_DEFAULT = 0;
    public static final short ENCODINGID_UNICODE_V11 = 1;
    public static final short ENCODINGID_UNICODE_V2 = 3;
    public static final short LANGUAGEID_MAC_ENGLISH = 0;
    public static final short NAMEID_COPYRIGHT = 0;
    public static final short NAMEID_FAMILY = 1;
    public static final short NAMEID_SUBFAMILY = 2;
    public static final short NAMEID_SUBFAMILY_UNIQUE = 3;
    public static final short NAMEID_FULL_NAME = 4;
    public static final short NAMEID_VERSION = 5;
    public static final short NAMEID_POSTSCRIPT_NAME = 6;
    public static final short NAMEID_TRADEMARK = 7;
    private short format;
    private SortedMap<NameRecord, String> records = Collections.synchronizedSortedMap(new TreeMap());

    protected NameTable() {
        super(1851878757);
    }

    public void addRecord(short s, short s2, short s3, short s4, String string) {
        NameRecord nameRecord = new NameRecord(s, s2, s3, s4);
        this.records.put(nameRecord, string);
    }

    public String getRecord(short s, short s2, short s3, short s4) {
        NameRecord nameRecord = new NameRecord(s, s2, s3, s4);
        return (String)this.records.get(nameRecord);
    }

    public void removeRecord(short s, short s2, short s3, short s4) {
        NameRecord nameRecord = new NameRecord(s, s2, s3, s4);
        this.records.remove(nameRecord);
    }

    public boolean hasRecords(short s) {
        for (NameRecord nameRecord : this.records.keySet()) {
            if (nameRecord.platformID != s) continue;
            return true;
        }
        return false;
    }

    public boolean hasRecords(short s, short s2) {
        for (NameRecord nameRecord : this.records.keySet()) {
            if (nameRecord.platformID != s || nameRecord.platformSpecificID != s2) continue;
            return true;
        }
        return false;
    }

    @Override
    public void setData(ByteBuffer byteBuffer) {
        this.setFormat(byteBuffer.getShort());
        int n = byteBuffer.getShort();
        short s = byteBuffer.getShort();
        for (int i = 0; i < n; ++i) {
            short s2 = byteBuffer.getShort();
            short s3 = byteBuffer.getShort();
            short s4 = byteBuffer.getShort();
            short s5 = byteBuffer.getShort();
            int n2 = byteBuffer.getShort() & 0xFFFF;
            int n3 = byteBuffer.getShort() & 0xFFFF;
            byteBuffer.mark();
            byteBuffer.position(s + n3);
            ByteBuffer byteBuffer2 = byteBuffer.slice();
            byteBuffer2.limit(n2);
            byteBuffer.reset();
            String string = NameTable.getCharsetName(s2, s3);
            Charset charset = Charset.forName(string);
            String string2 = charset.decode(byteBuffer2).toString();
            this.addRecord(s2, s3, s4, s5, string2);
        }
    }

    @Override
    public ByteBuffer getData() {
        ByteBuffer byteBuffer = ByteBuffer.allocate(this.getLength());
        short s = (short)(6 + 12 * this.getCount());
        byteBuffer.putShort(this.getFormat());
        byteBuffer.putShort(this.getCount());
        byteBuffer.putShort(s);
        short s2 = 0;
        for (NameRecord nameRecord : this.records.keySet()) {
            String string = (String)this.records.get(nameRecord);
            String string2 = NameTable.getCharsetName(nameRecord.platformID, nameRecord.platformSpecificID);
            Charset charset = Charset.forName(string2);
            ByteBuffer byteBuffer2 = charset.encode(string);
            short s3 = (short)(byteBuffer2.remaining() & 0xFFFF);
            byteBuffer.putShort(nameRecord.platformID);
            byteBuffer.putShort(nameRecord.platformSpecificID);
            byteBuffer.putShort(nameRecord.languageID);
            byteBuffer.putShort(nameRecord.nameID);
            byteBuffer.putShort(s3);
            byteBuffer.putShort(s2);
            byteBuffer.mark();
            byteBuffer.position(s + s2);
            byteBuffer.put(byteBuffer2);
            byteBuffer.reset();
            s2 = (short)(s2 + s3);
        }
        byteBuffer.position(s + s2);
        byteBuffer.flip();
        return byteBuffer;
    }

    @Override
    public int getLength() {
        int n = 6 + 12 * this.getCount();
        for (NameRecord nameRecord : this.records.keySet()) {
            String string = (String)this.records.get(nameRecord);
            String string2 = NameTable.getCharsetName(nameRecord.platformID, nameRecord.platformSpecificID);
            Charset charset = Charset.forName(string2);
            ByteBuffer byteBuffer = charset.encode(string);
            n += byteBuffer.remaining();
        }
        return n;
    }

    public short getFormat() {
        return this.format;
    }

    public void setFormat(short s) {
        this.format = s;
    }

    public short getCount() {
        return (short)this.records.size();
    }

    public static String getCharsetName(int n, int n2) {
        String string = "US-ASCII";
        switch (n) {
            case 0: {
                string = "UTF-16";
                break;
            }
            case 3: {
                string = "UTF-16";
            }
        }
        return string;
    }

    @Override
    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        String string = "    ";
        stringBuffer.append(string + "Format: " + this.getFormat() + "\n");
        stringBuffer.append(string + "Count : " + this.getCount() + "\n");
        for (NameRecord nameRecord : this.records.keySet()) {
            stringBuffer.append(string + " platformID: " + nameRecord.platformID);
            stringBuffer.append(" platformSpecificID: " + nameRecord.platformSpecificID);
            stringBuffer.append(" languageID: " + nameRecord.languageID);
            stringBuffer.append(" nameID: " + nameRecord.nameID + "\n");
            stringBuffer.append(string + "  " + (String)this.records.get(nameRecord) + "\n");
        }
        return stringBuffer.toString();
    }

    class NameRecord
    implements Comparable {
        short platformID;
        short platformSpecificID;
        short languageID;
        short nameID;

        NameRecord(short s, short s2, short s3, short s4) {
            this.platformID = s;
            this.platformSpecificID = s2;
            this.languageID = s3;
            this.nameID = s4;
        }

        public boolean equals(Object object) {
            return this.compareTo(object) == 0;
        }

        public int compareTo(Object object) {
            if (!(object instanceof NameRecord)) {
                return -1;
            }
            NameRecord nameRecord = (NameRecord)object;
            if (this.platformID > nameRecord.platformID) {
                return 1;
            }
            if (this.platformID < nameRecord.platformID) {
                return -1;
            }
            if (this.platformSpecificID > nameRecord.platformSpecificID) {
                return 1;
            }
            if (this.platformSpecificID < nameRecord.platformSpecificID) {
                return -1;
            }
            if (this.languageID > nameRecord.languageID) {
                return 1;
            }
            if (this.languageID < nameRecord.languageID) {
                return -1;
            }
            if (this.nameID > nameRecord.nameID) {
                return 1;
            }
            if (this.nameID < nameRecord.nameID) {
                return -1;
            }
            return 0;
        }
    }
}

