/*
 * Decompiled with CFR 0.152.
 */
package com.sun.pdfview.font;

import com.sun.pdfview.PDFFile;
import com.sun.pdfview.PDFObject;
import com.sun.pdfview.font.FlPoint;
import com.sun.pdfview.font.FontSupport;
import com.sun.pdfview.font.OutlineFont;
import com.sun.pdfview.font.PDFFontDescriptor;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Path2D;
import java.awt.geom.Point2D;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;

public class Type1Font
extends OutlineFont {
    String[] chr2name;
    int password;
    byte[][] subrs;
    int lenIV;
    Map<String, Object> name2outline;
    Map<String, FlPoint> name2width;
    AffineTransform at;
    float[] stack = new float[100];
    int sloc = 0;
    float[] psStack = new float[3];
    int psLoc = 0;
    int callcount = 0;

    public Type1Font(String string, PDFObject pDFObject, PDFFontDescriptor pDFFontDescriptor) throws IOException {
        super(string, pDFObject, pDFFontDescriptor);
        if (pDFFontDescriptor != null && pDFFontDescriptor.getFontFile() != null) {
            int n = pDFFontDescriptor.getFontFile().getDictRef("Length1").getIntValue();
            int n2 = pDFFontDescriptor.getFontFile().getDictRef("Length2").getIntValue();
            byte[] byArray = pDFFontDescriptor.getFontFile().getStream();
            this.parseFont(byArray, n, n2);
        }
    }

    protected void parseFont(byte[] byArray, int n, int n2) {
        this.name2width = new HashMap<String, FlPoint>();
        byte[] byArray2 = null;
        if (this.isASCII(byArray, n)) {
            byte[] byArray3 = this.readASCII(byArray, n, n + n2);
            byArray2 = this.decrypt(byArray3, 0, byArray3.length, 55665, 4);
        } else {
            byArray2 = this.decrypt(byArray, n, n + n2, 55665, 4);
        }
        this.chr2name = this.readEncoding(byArray);
        int n3 = this.findSlashName(byArray2, "lenIV");
        PSParser pSParser = new PSParser(byArray2, 0);
        if (n3 < 0) {
            this.lenIV = 4;
        } else {
            pSParser.setLoc(n3 + 6);
            this.lenIV = Integer.parseInt(pSParser.readThing());
        }
        this.password = 4330;
        int n4 = this.findSlashName(byArray, "FontMatrix");
        if (n4 < 0) {
            System.out.println("No FontMatrix!");
            this.at = new AffineTransform(0.001f, 0.0f, 0.0f, 0.001f, 0.0f, 0.0f);
        } else {
            PSParser pSParser2 = new PSParser(byArray, n4 + 11);
            float[] fArray = pSParser2.readArray(6);
            this.at = new AffineTransform(fArray);
        }
        this.subrs = this.readSubrs(byArray2);
        this.name2outline = new TreeMap<String, byte[]>(this.readChars(byArray2));
    }

    private String[] readEncoding(byte[] byArray) {
        byte[][] byArray2 = this.readArray(byArray, "Encoding", "def");
        String[] stringArray = new String[256];
        for (int i = 0; i < byArray2.length; ++i) {
            if (byArray2[i] != null) {
                if (byArray2[i][0] == 47) {
                    stringArray[i] = new String(byArray2[i]).substring(1);
                    continue;
                }
                stringArray[i] = new String(byArray2[i]);
                continue;
            }
            stringArray[i] = null;
        }
        return stringArray;
    }

    private byte[][] readSubrs(byte[] byArray) {
        return this.readArray(byArray, "Subrs", "index");
    }

    private byte[][] readArray(byte[] byArray, String string, String string2) {
        int n = this.findSlashName(byArray, string);
        if (n < 0) {
            return new byte[0][];
        }
        PSParser pSParser = new PSParser(byArray, n);
        String string3 = pSParser.readThing();
        string3 = pSParser.readThing();
        if (string3.equals("StandardEncoding")) {
            byte[][] byArrayArray = new byte[FontSupport.standardEncoding.length][];
            for (n = 0; n < byArrayArray.length; ++n) {
                byArrayArray[n] = FontSupport.getName(FontSupport.standardEncoding[n]).getBytes();
            }
            return byArrayArray;
        }
        int n2 = Integer.parseInt(string3);
        byte[][] byArrayArray = new byte[n2][];
        while (true) {
            String string4;
            if ((string4 = pSParser.readThing()).equals("dup")) {
                int n3 = Integer.parseInt(pSParser.readThing());
                String string5 = pSParser.readThing();
                byte[] byArray2 = string5.getBytes();
                if (Character.isDigit(string5.charAt(0))) {
                    int n4 = Integer.parseInt(string5);
                    String string6 = pSParser.readThing();
                    if (string6.equals("-|") || string6.equals("RD")) {
                        pSParser.setLoc(pSParser.getLoc() + 1);
                        byArray2 = pSParser.getNEncodedBytes(n4, this.password, this.lenIV);
                    }
                }
                byArrayArray[n3] = byArray2;
                continue;
            }
            if (string4.equals(string2)) break;
        }
        return byArrayArray;
    }

    private byte[] decrypt(byte[] byArray, int n, int n2, int n3, int n4) {
        if (n2 - n - n4 < 0) {
            n4 = 0;
        }
        byte[] byArray2 = new byte[n2 - n - n4];
        int n5 = n3;
        int n6 = 52845;
        int n7 = 22719;
        for (int i = n; i < n2; ++i) {
            int n8 = byArray[i] & 0xFF;
            int n9 = (n8 ^ n5 >> 8) & 0xFF;
            n5 = (n8 + n5) * n6 + n7 & 0xFFFF;
            if (i - n - n4 < 0) continue;
            byArray2[i - n - n4] = (byte)n9;
        }
        return byArray2;
    }

    private byte[] readASCII(byte[] byArray, int n, int n2) {
        byte[] byArray2 = new byte[(n2 - n) / 2];
        int n3 = 0;
        int n4 = 0;
        for (int i = n; i < n2; ++i) {
            char c = (char)(byArray[i] & 0xFF);
            byte by = 0;
            if (c >= '0' && c <= '9') {
                by = (byte)(c - 48);
            } else if (c >= 'a' && c <= 'f') {
                by = (byte)(10 + (c - 97));
            } else {
                if (c < 'A' || c > 'F') continue;
                by = (byte)(10 + (c - 65));
            }
            if (n4++ % 2 == 0) {
                byArray2[n3] = (byte)(by << 4);
                continue;
            }
            int n5 = n3++;
            byArray2[n5] = (byte)(byArray2[n5] | by);
        }
        return byArray2;
    }

    private boolean isASCII(byte[] byArray, int n) {
        for (int i = n; i < n + 4; ++i) {
            char c = (char)(byArray[i] & 0xFF);
            if (c >= '0' && c <= '9' || c >= 'a' && c <= 'f' || c >= 'A' && c <= 'F') continue;
            return false;
        }
        return true;
    }

    private int findSlashName(byte[] byArray, String string) {
        for (int i = 0; i < byArray.length; ++i) {
            if (byArray[i] != 47) continue;
            boolean bl = true;
            for (int j = 0; j < string.length(); ++j) {
                if (byArray[i + j + 1] == string.charAt(j)) continue;
                bl = false;
                break;
            }
            if (!bl) continue;
            return i;
        }
        return -1;
    }

    private HashMap<String, byte[]> readChars(byte[] byArray) {
        HashMap<String, byte[]> hashMap = new HashMap<String, byte[]>();
        int n = this.findSlashName(byArray, "CharStrings");
        if (n < 0) {
            return hashMap;
        }
        PSParser pSParser = new PSParser(byArray, n);
        while (true) {
            String string;
            char c;
            if ((c = (string = pSParser.readThing()).charAt(0)) == '/') {
                int n2 = Integer.parseInt(pSParser.readThing());
                String string2 = pSParser.readThing();
                if (!string2.equals("-|") && !string2.equals("RD")) continue;
                pSParser.setLoc(pSParser.getLoc() + 1);
                byte[] byArray2 = pSParser.getNEncodedBytes(n2, this.password, this.lenIV);
                hashMap.put(string.substring(1), byArray2);
                continue;
            }
            if (string.equals("end")) break;
        }
        return hashMap;
    }

    private float pop() {
        float f = 0.0f;
        if (this.sloc > 0) {
            f = this.stack[--this.sloc];
        }
        return f;
    }

    private void parse(byte[] byArray, GeneralPath generalPath, FlPoint flPoint, FlPoint flPoint2) {
        int n = 0;
        block27: while (n < byArray.length) {
            int n2;
            if ((n2 = byArray[n++] & 0xFF) == 255) {
                this.stack[this.sloc++] = ((byArray[n] & 0xFF) << 24) + ((byArray[n + 1] & 0xFF) << 16) + ((byArray[n + 2] & 0xFF) << 8) + (byArray[n + 3] & 0xFF);
                n += 4;
                continue;
            }
            if (n2 >= 251) {
                this.stack[this.sloc++] = -(n2 - 251 << 8) - (byArray[n] & 0xFF) - 108;
                ++n;
                continue;
            }
            if (n2 >= 247) {
                this.stack[this.sloc++] = (n2 - 247 << 8) + (byArray[n] & 0xFF) + 108;
                ++n;
                continue;
            }
            if (n2 >= 32) {
                this.stack[this.sloc++] = n2 - 139;
                continue;
            }
            block0 : switch (n2) {
                case 0: {
                    throw new RuntimeException("Bad command (" + n2 + ")");
                }
                case 1: {
                    this.sloc = 0;
                    break;
                }
                case 2: {
                    throw new RuntimeException("Bad command (" + n2 + ")");
                }
                case 3: {
                    this.sloc = 0;
                    break;
                }
                case 4: {
                    flPoint.y += this.pop();
                    generalPath.moveTo(flPoint.x, flPoint.y);
                    this.sloc = 0;
                    break;
                }
                case 5: {
                    flPoint.y += this.pop();
                    flPoint.x += this.pop();
                    generalPath.lineTo(flPoint.x, flPoint.y);
                    this.sloc = 0;
                    break;
                }
                case 6: {
                    flPoint.x += this.pop();
                    generalPath.lineTo(flPoint.x, flPoint.y);
                    this.sloc = 0;
                    break;
                }
                case 7: {
                    flPoint.y += this.pop();
                    generalPath.lineTo(flPoint.x, flPoint.y);
                    this.sloc = 0;
                    break;
                }
                case 8: {
                    float f = this.pop();
                    float f2 = this.pop();
                    float f3 = this.pop();
                    float f4 = this.pop();
                    float f5 = this.pop();
                    float f6 = this.pop();
                    generalPath.curveTo(flPoint.x + f6, flPoint.y + f5, flPoint.x + f6 + f4, flPoint.y + f5 + f3, flPoint.x + f6 + f4 + f2, flPoint.y + f5 + f3 + f);
                    flPoint.x += f6 + f4 + f2;
                    flPoint.y += f5 + f3 + f;
                    this.sloc = 0;
                    break;
                }
                case 9: {
                    generalPath.closePath();
                    this.sloc = 0;
                    break;
                }
                case 10: {
                    int n3 = (int)this.pop();
                    if (this.subrs[n3] == null) {
                        System.out.println("No subroutine #" + n3);
                        break;
                    }
                    ++this.callcount;
                    if (this.callcount > 10) {
                        System.out.println("Call stack too large");
                    } else {
                        this.parse(this.subrs[n3], generalPath, flPoint, flPoint2);
                    }
                    --this.callcount;
                    break;
                }
                case 11: {
                    return;
                }
                case 12: {
                    int n4;
                    int n5;
                    n2 = byArray[n++] & 0xFF;
                    if (n2 == 6) {
                        n5 = (int)this.pop();
                        n4 = (int)this.pop();
                        float f = this.pop();
                        float f7 = this.pop();
                        this.buildAccentChar(f7, f, (char)n4, (char)n5, generalPath);
                        this.sloc = 0;
                        break;
                    }
                    if (n2 == 7) {
                        flPoint2.y = this.pop();
                        flPoint2.x = this.pop();
                        flPoint.y = this.pop();
                        flPoint.x = this.pop();
                        this.sloc = 0;
                        break;
                    }
                    if (n2 == 12) {
                        float f = this.pop();
                        float f8 = this.pop();
                        this.stack[this.sloc++] = f8 / f;
                        break;
                    }
                    if (n2 == 33) {
                        flPoint.y = this.pop();
                        flPoint.x = this.pop();
                        generalPath.moveTo(flPoint.x, flPoint.y);
                        this.sloc = 0;
                        break;
                    }
                    if (n2 == 0) {
                        this.sloc = 0;
                        break;
                    }
                    if (n2 == 1) {
                        this.sloc = 0;
                        break;
                    }
                    if (n2 == 2) {
                        this.sloc = 0;
                        break;
                    }
                    if (n2 == 16) {
                        n5 = (int)this.pop();
                        n4 = (int)this.pop();
                        switch (n5) {
                            case 0: {
                                this.psStack[this.psLoc++] = this.pop();
                                this.psStack[this.psLoc++] = this.pop();
                                this.pop();
                                break block0;
                            }
                            case 3: {
                                this.psStack[this.psLoc++] = 3.0f;
                                break block0;
                            }
                        }
                        for (int i = 0; i > n4; --i) {
                            this.psStack[this.psLoc++] = this.pop();
                        }
                        continue block27;
                    }
                    if (n2 == 17) {
                        this.stack[this.sloc++] = this.psStack[this.psLoc - 1];
                        --this.psLoc;
                        break;
                    }
                    throw new RuntimeException("Bad command (" + n2 + ")");
                }
                case 13: {
                    flPoint2.x = this.pop();
                    flPoint2.y = 0.0f;
                    flPoint.x = this.pop();
                    flPoint.y = 0.0f;
                    this.sloc = 0;
                    break;
                }
                case 14: {
                    break;
                }
                case 15: 
                case 16: 
                case 17: 
                case 18: 
                case 19: 
                case 20: {
                    throw new RuntimeException("Bad command (" + n2 + ")");
                }
                case 21: {
                    flPoint.y += this.pop();
                    flPoint.x += this.pop();
                    generalPath.moveTo(flPoint.x, flPoint.y);
                    this.sloc = 0;
                    break;
                }
                case 22: {
                    flPoint.x += this.pop();
                    generalPath.moveTo(flPoint.x, flPoint.y);
                    this.sloc = 0;
                    break;
                }
                case 23: 
                case 24: 
                case 25: 
                case 26: 
                case 27: 
                case 28: 
                case 29: {
                    throw new RuntimeException("Bad command (" + n2 + ")");
                }
                case 30: {
                    float f2 = this.pop();
                    float f3 = this.pop();
                    float f4 = this.pop();
                    float f5 = this.pop();
                    float f = 0.0f;
                    float f6 = 0.0f;
                    generalPath.curveTo(flPoint.x, flPoint.y + f5, flPoint.x + f4, flPoint.y + f5 + f3, flPoint.x + f4 + f2, flPoint.y + f5 + f3);
                    flPoint.x += f4 + f2;
                    flPoint.y += f5 + f3;
                    this.sloc = 0;
                    break;
                }
                case 31: {
                    float f = this.pop();
                    float f3 = this.pop();
                    float f4 = this.pop();
                    float f6 = this.pop();
                    float f2 = 0.0f;
                    float f5 = 0.0f;
                    generalPath.curveTo(flPoint.x + f6, flPoint.y, flPoint.x + f6 + f4, flPoint.y + f3, flPoint.x + f6 + f4, flPoint.y + f3 + f);
                    flPoint.x += f6 + f4;
                    flPoint.y += f3 + f;
                    this.sloc = 0;
                }
            }
        }
    }

    private void buildAccentChar(float f, float f2, char c, char c2, GeneralPath generalPath) {
        Cloneable cloneable;
        GeneralPath generalPath2 = (GeneralPath)this.getOutline(c, this.getWidth(c, null)).clone();
        try {
            cloneable = this.at.createInverse();
            generalPath2.transform((AffineTransform)cloneable);
        }
        catch (NoninvertibleTransformException noninvertibleTransformException) {
            generalPath2.transform(AffineTransform.getTranslateInstance(f, f2));
        }
        cloneable = this.getOutline(c2, this.getWidth(c2, null));
        try {
            AffineTransform affineTransform = this.at.createInverse();
            ((Path2D.Float)cloneable).transform(affineTransform);
        }
        catch (NoninvertibleTransformException noninvertibleTransformException) {
            // empty catch block
        }
        generalPath.append((Shape)((Object)cloneable), false);
        generalPath.append(generalPath2, false);
    }

    @Override
    public float getWidth(char c, String string) {
        if (this.getFirstChar() == -1 || this.getLastChar() == -1) {
            String string2 = this.chr2name[c & 0xFF];
            if (string != null) {
                string2 = string;
            }
            if (string2 != null && this.name2outline.containsKey(string2)) {
                FlPoint flPoint;
                if (!this.name2width.containsKey(string2)) {
                    this.getOutline(string2, 0.0f);
                }
                if ((flPoint = this.name2width.get(string2)) != null) {
                    return flPoint.x / (float)this.getDefaultWidth();
                }
            }
            return 0.0f;
        }
        return super.getWidth(c, string);
    }

    private synchronized GeneralPath parseGlyph(byte[] byArray, FlPoint flPoint, AffineTransform affineTransform) {
        GeneralPath generalPath = new GeneralPath();
        FlPoint flPoint2 = new FlPoint();
        this.sloc = 0;
        this.parse(byArray, generalPath, flPoint2, flPoint);
        generalPath.transform(affineTransform);
        return generalPath;
    }

    @Override
    protected GeneralPath getOutline(String string, float f) {
        Object object;
        if (string == null || !this.name2outline.containsKey(string)) {
            string = ".notdef";
        }
        if ((object = this.name2outline.get(string)) instanceof GeneralPath) {
            return (GeneralPath)object;
        }
        byte[] byArray = (byte[])object;
        FlPoint flPoint = new FlPoint();
        GeneralPath generalPath = this.parseGlyph(byArray, flPoint, this.at);
        if (f != 0.0f && flPoint.x != 0.0f) {
            Point2D.Float float_ = new Point2D.Float(flPoint.x, flPoint.y);
            this.at.transform(float_, float_);
            double d = (double)f / ((Point2D)float_).getX();
            AffineTransform affineTransform = AffineTransform.getScaleInstance(d, 1.0);
            generalPath.transform(affineTransform);
        }
        this.name2outline.put(string, generalPath);
        this.name2width.put(string, flPoint);
        return generalPath;
    }

    @Override
    protected GeneralPath getOutline(char c, float f) {
        return this.getOutline(this.chr2name[c & 0xFF], f);
    }

    class PSParser {
        byte[] data;
        int loc;

        public PSParser(byte[] byArray, int n) {
            this.data = byArray;
            this.loc = n;
        }

        public String readThing() {
            while (PDFFile.isWhiteSpace(this.data[this.loc])) {
                ++this.loc;
            }
            int n = this.loc;
            while (!PDFFile.isWhiteSpace(this.data[this.loc])) {
                ++this.loc;
                if (PDFFile.isRegularCharacter(this.data[this.loc])) continue;
            }
            String string = new String(this.data, n, this.loc - n);
            return string;
        }

        public float[] readArray(int n) {
            float[] fArray = new float[n];
            int n2 = 0;
            while (n2 < n) {
                String string = this.readThing();
                if (string.charAt(0) == '[') {
                    string = string.substring(1);
                }
                if (string.endsWith("]")) {
                    string = string.substring(0, string.length() - 1);
                }
                if (string.length() <= 0) continue;
                fArray[n2++] = Float.valueOf(string).floatValue();
            }
            return fArray;
        }

        public int getLoc() {
            return this.loc;
        }

        public void setLoc(int n) {
            this.loc = n;
        }

        public byte[] getNEncodedBytes(int n, int n2, int n3) {
            byte[] byArray = Type1Font.this.decrypt(this.data, this.loc, this.loc + n, n2, n3);
            this.loc += n;
            return byArray;
        }
    }
}

