/*
 * Decompiled with CFR 0.152.
 */
package com.sun.pdfview.font;

import com.sun.pdfview.PDFObject;
import com.sun.pdfview.font.OutlineFont;
import com.sun.pdfview.font.PDFFontDescriptor;
import com.sun.pdfview.font.ttf.AdobeGlyphList;
import com.sun.pdfview.font.ttf.CMap;
import com.sun.pdfview.font.ttf.CmapTable;
import com.sun.pdfview.font.ttf.Glyf;
import com.sun.pdfview.font.ttf.GlyfCompound;
import com.sun.pdfview.font.ttf.GlyfSimple;
import com.sun.pdfview.font.ttf.GlyfTable;
import com.sun.pdfview.font.ttf.HeadTable;
import com.sun.pdfview.font.ttf.HmtxTable;
import com.sun.pdfview.font.ttf.PostTable;
import com.sun.pdfview.font.ttf.TrueTypeFont;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.io.IOException;

public class TTFFont
extends OutlineFont {
    private TrueTypeFont font;
    private float unitsPerEm;

    public TTFFont(String string, PDFObject pDFObject, PDFFontDescriptor pDFFontDescriptor) throws IOException {
        super(string, pDFObject, pDFFontDescriptor);
        String string2 = pDFFontDescriptor.getFontName();
        PDFObject pDFObject2 = pDFFontDescriptor.getFontFile2();
        if (pDFObject2 != null) {
            this.font = TrueTypeFont.parseFont(pDFObject2.getStreamBuffer());
            HeadTable headTable = (HeadTable)this.font.getTable("head");
            this.unitsPerEm = headTable.getUnitsPerEm();
        } else {
            this.font = null;
        }
    }

    @Override
    protected synchronized GeneralPath getOutline(char c, float f) {
        CmapTable cmapTable = (CmapTable)this.font.getTable("cmap");
        if (cmapTable == null) {
            return this.getOutline((int)c, f);
        }
        CMap[] cMapArray = cmapTable.getCMaps();
        for (int i = 0; i < cMapArray.length; ++i) {
            char c2;
            boolean bl;
            int n = this.getDescriptor().getFlags();
            boolean bl2 = bl = (n & 4) != 0;
            if (bl && cMapArray[i].getFormat() == 4) {
                c = (char)(c + 61440);
            }
            if ((c2 = cMapArray[i].map(c)) == '\u0000') continue;
            return this.getOutline((int)c2, f);
        }
        return this.getOutline(0, f);
    }

    protected synchronized GeneralPath getOutlineFromCMaps(char c, float f) {
        char c2;
        CmapTable cmapTable = (CmapTable)this.font.getTable("cmap");
        if (cmapTable == null) {
            return null;
        }
        CMap cMap = cmapTable.getCMap((short)3, (short)1);
        if (cMap == null) {
            cMap = cmapTable.getCMap((short)1, (short)0);
        }
        if ((c2 = cMap.map(c)) != '\u0000') {
            return this.getOutline((int)c2, f);
        }
        return null;
    }

    @Override
    protected synchronized GeneralPath getOutline(String string, float f) {
        PostTable postTable = (PostTable)this.font.getTable("post");
        if (postTable != null) {
            short s = postTable.getGlyphNameIndex(string);
            if (s != 0) {
                return this.getOutline(s, f);
            }
            return null;
        }
        Integer n = AdobeGlyphList.getGlyphNameIndex(string);
        if (n != null) {
            int n2 = n;
            return this.getOutlineFromCMaps((char)n2, f);
        }
        return null;
    }

    protected synchronized GeneralPath getOutline(int n, float f) {
        GlyfTable glyfTable = (GlyfTable)this.font.getTable("glyf");
        Glyf glyf = glyfTable.getGlyph(n);
        GeneralPath generalPath = null;
        generalPath = glyf instanceof GlyfSimple ? this.renderSimpleGlyph((GlyfSimple)glyf) : (glyf instanceof GlyfCompound ? this.renderCompoundGlyph(glyfTable, (GlyfCompound)glyf) : new GeneralPath());
        HmtxTable hmtxTable = (HmtxTable)this.font.getTable("hmtx");
        float f2 = (float)hmtxTable.getAdvance(n) / this.unitsPerEm;
        float f3 = f / f2;
        AffineTransform affineTransform = AffineTransform.getScaleInstance(1.0f / this.unitsPerEm, 1.0f / this.unitsPerEm);
        generalPath.transform(affineTransform);
        return generalPath;
    }

    protected GeneralPath renderSimpleGlyph(GlyfSimple glyfSimple) {
        int n = 0;
        RenderState renderState = new RenderState();
        renderState.gp = new GeneralPath();
        for (int i = 0; i < glyfSimple.getNumPoints(); ++i) {
            PointRec pointRec = new PointRec(glyfSimple, i);
            if (pointRec.onCurve) {
                this.addOnCurvePoint(pointRec, renderState);
            } else {
                this.addOffCurvePoint(pointRec, renderState);
            }
            if (i != glyfSimple.getContourEndPoint(n)) continue;
            ++n;
            if (renderState.firstOff != null) {
                this.addOffCurvePoint(renderState.firstOff, renderState);
            }
            if (renderState.firstOn != null) {
                this.addOnCurvePoint(renderState.firstOn, renderState);
            }
            renderState.firstOn = null;
            renderState.firstOff = null;
            renderState.prevOff = null;
        }
        return renderState.gp;
    }

    protected GeneralPath renderCompoundGlyph(GlyfTable glyfTable, GlyfCompound glyfCompound) {
        GeneralPath generalPath = new GeneralPath();
        for (int i = 0; i < glyfCompound.getNumComponents(); ++i) {
            GlyfSimple glyfSimple = (GlyfSimple)glyfTable.getGlyph(glyfCompound.getGlyphIndex(i));
            GeneralPath generalPath2 = this.renderSimpleGlyph(glyfSimple);
            double[] dArray = glyfCompound.getTransform(i);
            generalPath2.transform(new AffineTransform(dArray));
            generalPath.append(generalPath2, false);
        }
        return generalPath;
    }

    private void addOnCurvePoint(PointRec pointRec, RenderState renderState) {
        if (renderState.firstOn == null) {
            renderState.firstOn = pointRec;
            renderState.gp.moveTo(pointRec.x, pointRec.y);
        } else if (renderState.prevOff != null) {
            renderState.gp.quadTo(renderState.prevOff.x, renderState.prevOff.y, pointRec.x, pointRec.y);
            renderState.prevOff = null;
        } else {
            renderState.gp.lineTo(pointRec.x, pointRec.y);
        }
    }

    private void addOffCurvePoint(PointRec pointRec, RenderState renderState) {
        if (renderState.prevOff != null) {
            PointRec pointRec2 = new PointRec((pointRec.x + renderState.prevOff.x) / 2, (pointRec.y + renderState.prevOff.y) / 2, true);
            this.addOnCurvePoint(pointRec2, renderState);
        } else if (renderState.firstOn == null) {
            renderState.firstOff = pointRec;
        }
        renderState.prevOff = pointRec;
    }

    class PointRec {
        int x;
        int y;
        boolean onCurve;

        public PointRec(int n, int n2, boolean bl) {
            this.x = n;
            this.y = n2;
            this.onCurve = bl;
        }

        public PointRec(GlyfSimple glyfSimple, int n) {
            this.x = glyfSimple.getXCoord(n);
            this.y = glyfSimple.getYCoord(n);
            this.onCurve = glyfSimple.onCurve(n);
        }
    }

    class RenderState {
        GeneralPath gp;
        PointRec firstOn;
        PointRec firstOff;
        PointRec prevOff;

        RenderState() {
        }
    }
}

