/*
 * Decompiled with CFR 0.152.
 */
package com.sun.pdfview.font;

import com.sun.pdfview.PDFObject;
import com.sun.pdfview.font.PDFFont;
import com.sun.pdfview.font.PDFFontDescriptor;
import com.sun.pdfview.font.PDFGlyph;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.io.IOException;

public abstract class OutlineFont
extends PDFFont {
    private int firstChar = -1;
    private int lastChar = -1;
    private float[] widths;

    public OutlineFont(String string, PDFObject pDFObject, PDFFontDescriptor pDFFontDescriptor) throws IOException {
        super(string, pDFFontDescriptor);
        PDFObject pDFObject2 = pDFObject.getDictRef("FirstChar");
        PDFObject pDFObject3 = pDFObject.getDictRef("LastChar");
        PDFObject pDFObject4 = pDFObject.getDictRef("Widths");
        if (pDFObject2 != null) {
            this.firstChar = pDFObject2.getIntValue();
        }
        if (pDFObject3 != null) {
            this.lastChar = pDFObject3.getIntValue();
        }
        if (pDFObject4 != null) {
            PDFObject[] pDFObjectArray = pDFObject4.getArray();
            this.widths = new float[pDFObjectArray.length];
            for (int i = 0; i < pDFObjectArray.length; ++i) {
                this.widths[i] = pDFObjectArray[i].getFloatValue() / (float)this.getDefaultWidth();
            }
        }
    }

    public int getFirstChar() {
        return this.firstChar;
    }

    public int getLastChar() {
        return this.lastChar;
    }

    public int getDefaultWidth() {
        return 1000;
    }

    public int getCharCount() {
        return this.getLastChar() - this.getFirstChar() + 1;
    }

    public float getWidth(char c, String string) {
        int n = (c & 0xFF) - this.getFirstChar();
        if (n < 0 || this.widths == null || n >= this.widths.length) {
            if (this.getDescriptor() != null) {
                return this.getDescriptor().getMissingWidth();
            }
            return 0.0f;
        }
        return this.widths[n];
    }

    @Override
    protected PDFGlyph getGlyph(char c, String string) {
        GeneralPath generalPath = null;
        float f = this.getWidth(c, string);
        if (string != null) {
            generalPath = this.getOutline(string, f);
        }
        if (generalPath == null) {
            generalPath = this.getOutline(c, f);
        }
        Point2D.Float float_ = new Point2D.Float(f, 0.0f);
        return new PDFGlyph(c, string, generalPath, float_);
    }

    protected abstract GeneralPath getOutline(String var1, float var2);

    protected abstract GeneralPath getOutline(char var1, float var2);
}

