/*
 * Decompiled with CFR 0.152.
 */
package com.sun.pdfview.decrypt;

import com.sun.pdfview.PDFObject;
import com.sun.pdfview.PDFParseException;
import com.sun.pdfview.PDFStringUtil;
import com.sun.pdfview.decrypt.EncryptionUnsupportedByPlatformException;
import com.sun.pdfview.decrypt.EncryptionUnsupportedByProductException;
import com.sun.pdfview.decrypt.PDFAuthenticationFailureException;
import com.sun.pdfview.decrypt.PDFDecrypter;
import com.sun.pdfview.decrypt.PDFPassword;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.security.GeneralSecurityException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.List;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.ShortBufferException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public class StandardDecrypter
implements PDFDecrypter {
    private static final byte[] AESV2_SALT = new byte[]{115, 65, 108, 84};
    private static final byte[] PW_PADDING = new byte[]{40, -65, 78, 94, 78, 117, -118, 65, 100, 0, 78, 86, -1, -6, 1, 8, 46, 46, 0, -74, -48, 104, 62, -128, 47, 12, -87, -2, 100, 83, 105, 122};
    private static final String CIPHER_RC4 = "RC4";
    private static final String KEY_RC4 = "RC4";
    private static final String CIPHER_AES = "AES/CBC/PKCS5Padding";
    private static final String KEY_AES = "AES";
    private boolean ownerAuthorised = false;
    private byte[] generalKeyBytes;
    private EncryptionAlgorithm encryptionAlgorithm;

    public StandardDecrypter(EncryptionAlgorithm encryptionAlgorithm, PDFObject pDFObject, int n, int n2, byte[] byArray, byte[] byArray2, int n3, boolean bl, PDFPassword pDFPassword) throws IOException, EncryptionUnsupportedByProductException, EncryptionUnsupportedByPlatformException {
        this.encryptionAlgorithm = encryptionAlgorithm;
        byte[] byArray3 = pDFObject == null ? null : pDFObject.getAt(0).getStream();
        this.testJceAvailability(n);
        try {
            List<byte[]> list = pDFPassword.getPasswordBytes(false);
            for (int i = 0; this.generalKeyBytes == null && i < list.size(); ++i) {
                byte[] byArray4 = list.get(i);
                this.generalKeyBytes = this.checkOwnerPassword(byArray4, byArray3, n, n2, byArray, byArray2, n3, bl);
                if (this.generalKeyBytes != null) {
                    this.ownerAuthorised = true;
                    continue;
                }
                this.generalKeyBytes = this.checkUserPassword(byArray4, byArray3, n, n2, byArray, byArray2, n3, bl);
            }
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new PDFParseException("Unable to check passwords: " + generalSecurityException.getMessage(), generalSecurityException);
        }
        if (this.generalKeyBytes == null) {
            throw new PDFAuthenticationFailureException("Password failed authentication for both owner and user password");
        }
    }

    @Override
    public ByteBuffer decryptBuffer(String string, PDFObject pDFObject, ByteBuffer byteBuffer) throws PDFParseException {
        if (string != null) {
            throw new PDFParseException("This encryption version does not support Crypt filters");
        }
        if (pDFObject != null) {
            this.checkNums(pDFObject.getObjNum(), pDFObject.getObjGen());
        }
        byte[] byArray = pDFObject == null ? this.getUnsaltedDecryptionKey() : this.getObjectSaltedDecryptionKey(pDFObject.getObjNum(), pDFObject.getObjGen());
        return this.decryptBuffer(byteBuffer, byArray);
    }

    @Override
    public String decryptString(int n, int n2, String string) throws PDFParseException {
        byte[] byArray = PDFStringUtil.asBytes(string);
        byte[] byArray2 = this.getObjectSaltedDecryptionKey(n, n2);
        ByteBuffer byteBuffer = this.decryptBuffer(ByteBuffer.wrap(byArray), byArray2);
        return PDFStringUtil.asBasicString(byteBuffer.array(), byteBuffer.arrayOffset(), byteBuffer.limit());
    }

    @Override
    public boolean isOwnerAuthorised() {
        return this.ownerAuthorised;
    }

    @Override
    public boolean isEncryptionPresent() {
        return true;
    }

    private void testJceAvailability(int n) throws EncryptionUnsupportedByPlatformException, PDFParseException {
        byte[] byArray = new byte[16];
        Arrays.fill(byArray, (byte)-82);
        byte[] byArray2 = new byte[this.getSaltedContentKeyByteLength(n / 8)];
        Arrays.fill(byArray2, (byte)-82);
        try {
            this.createAndInitialiseContentCipher(ByteBuffer.wrap(byArray), byArray2);
        }
        catch (PDFParseException pDFParseException) {
            throw new PDFParseException("Internal error; failed to produce test cipher: " + pDFParseException.getMessage());
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new EncryptionUnsupportedByPlatformException("JCE does not offer required cipher", noSuchAlgorithmException);
        }
        catch (NoSuchPaddingException noSuchPaddingException) {
            throw new EncryptionUnsupportedByPlatformException("JCE does not offer required padding", noSuchPaddingException);
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new EncryptionUnsupportedByPlatformException("JCE does accept key size of " + this.getSaltedContentKeyByteLength() * 8 + " bits- could it be a policy restriction?", invalidKeyException);
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            throw new EncryptionUnsupportedByPlatformException("JCE did not accept cipher parameter", invalidAlgorithmParameterException);
        }
        try {
            this.createMD5Digest();
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new EncryptionUnsupportedByPlatformException("No MD5 digest available from JCE", noSuchAlgorithmException);
        }
        if (this.encryptionAlgorithm != EncryptionAlgorithm.RC4) {
            Cipher cipher;
            try {
                cipher = this.createRC4Cipher();
            }
            catch (GeneralSecurityException generalSecurityException) {
                throw new EncryptionUnsupportedByPlatformException("JCE did not offer RC4 cipher", generalSecurityException);
            }
            byte[] byArray3 = new byte[5];
            Arrays.fill(byArray2, (byte)-82);
            try {
                this.initDecryption(cipher, this.createRC4Key(byArray3));
            }
            catch (InvalidKeyException invalidKeyException) {
                throw new EncryptionUnsupportedByPlatformException("JCE did not accept 40-bit RC4 key; policy problem?", invalidKeyException);
            }
        }
    }

    private ByteBuffer decryptBuffer(ByteBuffer byteBuffer, byte[] byArray) throws PDFParseException {
        Cipher cipher;
        try {
            cipher = this.createAndInitialiseContentCipher(byteBuffer, byArray);
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new PDFParseException("Unable to create cipher due to platform limitation: " + generalSecurityException.getMessage(), generalSecurityException);
        }
        try {
            ByteBuffer byteBuffer2 = ByteBuffer.allocate(byteBuffer.remaining());
            cipher.doFinal(byteBuffer, byteBuffer2);
            byteBuffer2.flip();
            return byteBuffer2;
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new PDFParseException("Could not decrypt: " + generalSecurityException.getMessage(), generalSecurityException);
        }
    }

    private Cipher createAndInitialiseContentCipher(ByteBuffer byteBuffer, byte[] byArray) throws PDFParseException, NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeyException, InvalidAlgorithmParameterException {
        Cipher cipher;
        if (this.encryptionAlgorithm.isRC4()) {
            cipher = Cipher.getInstance("RC4");
            cipher.init(2, this.createRC4Key(byArray));
        } else if (this.encryptionAlgorithm.isAES()) {
            cipher = this.createAESCipher();
            byte[] byArray2 = new byte[16];
            if (byteBuffer.remaining() < byArray2.length) {
                throw new PDFParseException("AES encrypted stream too short - no room for initialisation vector");
            }
            byteBuffer.get(byArray2);
            SecretKeySpec secretKeySpec = new SecretKeySpec(byArray, KEY_AES);
            IvParameterSpec ivParameterSpec = new IvParameterSpec(byArray2);
            cipher.init(2, (Key)secretKeySpec, ivParameterSpec);
        } else {
            throw new PDFParseException("Internal error - unhandled cipher type: " + (Object)((Object)this.encryptionAlgorithm));
        }
        return cipher;
    }

    private byte[] getUnsaltedDecryptionKey() {
        return this.generalKeyBytes;
    }

    private byte[] getObjectSaltedDecryptionKey(int n, int n2) throws PDFParseException {
        MessageDigest messageDigest;
        try {
            messageDigest = this.createMD5Digest();
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new PDFParseException("Unable to get MD5 digester", noSuchAlgorithmException);
        }
        messageDigest.update(this.generalKeyBytes);
        messageDigest.update((byte)n);
        messageDigest.update((byte)(n >> 8));
        messageDigest.update((byte)(n >> 16));
        messageDigest.update((byte)n2);
        messageDigest.update((byte)(n2 >> 8));
        if (this.encryptionAlgorithm == EncryptionAlgorithm.AESV2) {
            messageDigest.update(AESV2_SALT);
        }
        byte[] byArray = messageDigest.digest();
        int n3 = this.getSaltedContentKeyByteLength();
        byte[] byArray2 = new byte[n3];
        System.arraycopy(byArray, 0, byArray2, 0, n3);
        return byArray2;
    }

    private int getSaltedContentKeyByteLength() {
        return this.getSaltedContentKeyByteLength(this.generalKeyBytes.length);
    }

    private int getSaltedContentKeyByteLength(int n) {
        return Math.min(n + 5, 16);
    }

    private void checkNums(int n, int n2) throws PDFParseException {
        if (n < 0) {
            throw new PDFParseException("Internal error: Object has bogus object number");
        }
        if (n2 < 0) {
            throw new PDFParseException("Internal error: Object has bogus generation number");
        }
    }

    private byte[] calculateUValue(byte[] byArray, byte[] byArray2, int n) throws GeneralSecurityException, EncryptionUnsupportedByProductException {
        if (n == 2) {
            Cipher cipher = this.createRC4Cipher();
            SecretKeySpec secretKeySpec = this.createRC4Key(byArray);
            this.initEncryption(cipher, secretKeySpec);
            return this.crypt(cipher, PW_PADDING);
        }
        if (n >= 3) {
            MessageDigest messageDigest = this.createMD5Digest();
            messageDigest.update(PW_PADDING);
            if (byArray2 != null) {
                messageDigest.update(byArray2);
            }
            byte[] byArray3 = messageDigest.digest();
            Cipher cipher = this.createRC4Cipher();
            SecretKeySpec secretKeySpec = this.createRC4Key(byArray);
            this.initEncryption(cipher, secretKeySpec);
            byte[] byArray4 = this.crypt(cipher, byArray3);
            this.rc4shuffle(byArray4, byArray, cipher);
            assert (byArray4.length == 16);
            byte[] byArray5 = new byte[32];
            System.arraycopy(byArray4, 0, byArray5, 0, byArray4.length);
            System.arraycopy(byArray4, 0, byArray5, 16, byArray4.length);
            return byArray5;
        }
        throw new EncryptionUnsupportedByProductException("Unsupported standard security handler revision " + n);
    }

    private byte[] calculuateOValue(byte[] byArray, byte[] byArray2, int n, int n2) throws GeneralSecurityException {
        byte[] byArray3 = this.getInitialOwnerPasswordKeyBytes(byArray, n, n2);
        Cipher cipher = this.createRC4Cipher();
        this.initEncryption(cipher, this.createRC4Key(byArray3));
        byte[] byArray4 = this.crypt(cipher, this.padPassword(byArray2));
        if (n2 >= 3) {
            this.rc4shuffle(byArray4, byArray3, cipher);
        }
        assert (byArray4.length == 32);
        return byArray4;
    }

    private byte[] checkOwnerPassword(byte[] byArray, byte[] byArray2, int n, int n2, byte[] byArray3, byte[] byArray4, int n3, boolean bl) throws GeneralSecurityException, EncryptionUnsupportedByProductException, PDFParseException {
        byte[] byArray5;
        byte[] byArray6 = this.getInitialOwnerPasswordKeyBytes(byArray, n, n2);
        Cipher cipher = this.createRC4Cipher();
        this.initDecryption(cipher, this.createRC4Key(byArray6));
        if (n2 == 2) {
            byArray5 = this.crypt(cipher, byArray3);
        } else if (n2 >= 3) {
            byArray5 = new byte[32];
            System.arraycopy(byArray3, 0, byArray5, 0, byArray5.length);
            this.rc4unshuffle(cipher, byArray5, byArray6);
        } else {
            throw new EncryptionUnsupportedByProductException("Unsupported revision: " + n2);
        }
        return this.checkUserPassword(byArray5, byArray2, n, n2, byArray3, byArray4, n3, bl);
    }

    private byte[] getInitialOwnerPasswordKeyBytes(byte[] byArray, int n, int n2) throws GeneralSecurityException {
        MessageDigest messageDigest = this.createMD5Digest();
        messageDigest.update(this.padPassword(byArray));
        byte[] byArray2 = messageDigest.digest();
        if (n2 >= 3) {
            for (int i = 0; i < 50; ++i) {
                messageDigest.update(byArray2);
                this.digestTo(messageDigest, byArray2);
            }
        }
        byte[] byArray3 = new byte[n / 8];
        System.arraycopy(byArray2, 0, byArray3, 0, byArray3.length);
        return byArray3;
    }

    private byte[] checkUserPassword(byte[] byArray, byte[] byArray2, int n, int n2, byte[] byArray3, byte[] byArray4, int n3, boolean bl) throws GeneralSecurityException, EncryptionUnsupportedByProductException, PDFParseException {
        byte[] byArray5 = this.calculateGeneralEncryptionKey(byArray, byArray2, n, n2, byArray3, n3, bl);
        byte[] byArray6 = this.calculateUValue(byArray5, byArray2, n2);
        assert (byArray6.length == 32);
        if (byArray4.length != byArray6.length) {
            throw new PDFParseException("Improper U entry length; expected 32, is " + byArray4.length);
        }
        int n4 = n2 == 2 ? 32 : 16;
        for (int i = 0; i < n4; ++i) {
            if (byArray4[i] == byArray6[i]) continue;
            return null;
        }
        return byArray5;
    }

    private byte[] calculateGeneralEncryptionKey(byte[] byArray, byte[] byArray2, int n, int n2, byte[] byArray3, int n3, boolean bl) throws GeneralSecurityException {
        byte[] byArray4 = this.padPassword(byArray);
        MessageDigest messageDigest = this.createMD5Digest();
        messageDigest.reset();
        messageDigest.update(byArray4);
        messageDigest.update(byArray3);
        messageDigest.update((byte)(n3 & 0xFF));
        messageDigest.update((byte)(n3 >> 8 & 0xFF));
        messageDigest.update((byte)(n3 >> 16 & 0xFF));
        messageDigest.update((byte)(n3 >> 24));
        if (byArray2 != null) {
            messageDigest.update(byArray2);
        }
        if (n2 >= 4 && !bl) {
            for (int i = 0; i < 4; ++i) {
                messageDigest.update((byte)-1);
            }
        }
        byte[] byArray5 = messageDigest.digest();
        int n4 = n2 == 2 ? 5 : n / 8;
        byte[] byArray6 = new byte[n4];
        if (n2 >= 3) {
            for (int i = 0; i < 50; ++i) {
                messageDigest.update(byArray5, 0, byArray6.length);
                this.digestTo(messageDigest, byArray5);
            }
        }
        System.arraycopy(byArray5, 0, byArray6, 0, byArray6.length);
        return byArray6;
    }

    private byte[] padPassword(byte[] byArray) {
        byte[] byArray2;
        if (byArray == null) {
            byArray = new byte[]{};
        }
        int n = byArray.length > (byArray2 = new byte[32]).length ? byArray2.length : byArray.length;
        System.arraycopy(byArray, 0, byArray2, 0, n);
        if (byArray.length < byArray2.length) {
            System.arraycopy(PW_PADDING, 0, byArray2, byArray.length, byArray2.length - byArray.length);
        }
        return byArray2;
    }

    private byte[] crypt(Cipher cipher, byte[] byArray) throws IllegalBlockSizeException, BadPaddingException {
        return cipher.doFinal(byArray);
    }

    private void initEncryption(Cipher cipher, SecretKey secretKey) throws InvalidKeyException {
        cipher.init(1, secretKey);
    }

    private void rc4shuffle(byte[] byArray, byte[] byArray2, Cipher cipher) throws GeneralSecurityException {
        byte[] byArray3 = new byte[byArray2.length];
        for (int i = 1; i <= 19; ++i) {
            for (int j = 0; j < byArray3.length; ++j) {
                byArray3[j] = (byte)(byArray2[j] ^ i);
            }
            this.initEncryption(cipher, this.createRC4Key(byArray3));
            this.cryptInPlace(cipher, byArray);
        }
    }

    private void rc4unshuffle(Cipher cipher, byte[] byArray, byte[] byArray2) throws GeneralSecurityException {
        byte[] byArray3 = new byte[byArray2.length];
        for (int i = 19; i >= 0; --i) {
            for (int j = 0; j < byArray3.length; ++j) {
                byArray3[j] = (byte)(byArray2[j] ^ i);
            }
            this.initDecryption(cipher, this.createRC4Key(byArray3));
            this.cryptInPlace(cipher, byArray);
        }
    }

    private void cryptInPlace(Cipher cipher, byte[] byArray) throws IllegalBlockSizeException, ShortBufferException, BadPaddingException {
        cipher.doFinal(byArray, 0, byArray.length, byArray);
    }

    private void initDecryption(Cipher cipher, Key key) throws InvalidKeyException {
        cipher.init(2, key);
    }

    private Cipher createRC4Cipher() throws NoSuchAlgorithmException, NoSuchPaddingException {
        return Cipher.getInstance("RC4");
    }

    private Cipher createAESCipher() throws NoSuchAlgorithmException, NoSuchPaddingException {
        return Cipher.getInstance(CIPHER_AES);
    }

    private MessageDigest createMD5Digest() throws NoSuchAlgorithmException {
        return MessageDigest.getInstance("MD5");
    }

    private SecretKeySpec createRC4Key(byte[] byArray) {
        return new SecretKeySpec(byArray, "RC4");
    }

    private void digestTo(MessageDigest messageDigest, byte[] byArray) throws GeneralSecurityException {
        messageDigest.digest(byArray, 0, byArray.length);
    }

    public static enum EncryptionAlgorithm {
        RC4,
        AESV2;


        boolean isRC4() {
            return this == RC4;
        }

        boolean isAES() {
            return this == AESV2;
        }
    }
}

