/*
 * Decompiled with CFR 0.152.
 */
package com.sun.pdfview.decode;

import com.sun.pdfview.PDFObject;
import com.sun.pdfview.PDFParseException;
import com.sun.pdfview.decode.PNGPredictor;
import java.io.IOException;
import java.nio.ByteBuffer;

public abstract class Predictor {
    public static final int TIFF = 0;
    public static final int PNG = 1;
    private int algorithm;
    private int colors = 1;
    private int bpc = 8;
    private int columns = 1;

    protected Predictor(int n) {
        this.algorithm = n;
    }

    public abstract ByteBuffer unpredict(ByteBuffer var1) throws IOException;

    public static Predictor getPredictor(PDFObject pDFObject) throws IOException {
        PDFObject pDFObject2;
        PDFObject pDFObject3;
        PDFObject pDFObject4 = pDFObject.getDictRef("Predictor");
        if (pDFObject4 == null) {
            return null;
        }
        int n = pDFObject4.getIntValue();
        PNGPredictor pNGPredictor = null;
        switch (n) {
            case 1: {
                return null;
            }
            case 2: {
                throw new PDFParseException("Tiff Predictor not supported");
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                pNGPredictor = new PNGPredictor();
                break;
            }
            default: {
                throw new PDFParseException("Unknown predictor: " + n);
            }
        }
        PDFObject pDFObject5 = pDFObject.getDictRef("Colors");
        if (pDFObject5 != null) {
            pNGPredictor.setColors(pDFObject5.getIntValue());
        }
        if ((pDFObject3 = pDFObject.getDictRef("BitsPerComponent")) != null) {
            pNGPredictor.setBitsPerComponent(pDFObject3.getIntValue());
        }
        if ((pDFObject2 = pDFObject.getDictRef("Columns")) != null) {
            pNGPredictor.setColumns(pDFObject2.getIntValue());
        }
        return pNGPredictor;
    }

    public int getAlgorithm() {
        return this.algorithm;
    }

    public int getColors() {
        return this.colors;
    }

    protected void setColors(int n) {
        this.colors = n;
    }

    public int getBitsPerComponent() {
        return this.bpc;
    }

    public void setBitsPerComponent(int n) {
        this.bpc = n;
    }

    public int getColumns() {
        return this.columns;
    }

    public void setColumns(int n) {
        this.columns = n;
    }
}

