/*
 * Decompiled with CFR 0.152.
 */
package com.sun.pdfview.decode;

import com.sun.pdfview.PDFObject;
import com.sun.pdfview.PDFParseException;
import com.sun.pdfview.decode.ASCII85Decode;
import com.sun.pdfview.decode.ASCIIHexDecode;
import com.sun.pdfview.decode.CCITTFaxDecode;
import com.sun.pdfview.decode.DCTDecode;
import com.sun.pdfview.decode.FlateDecode;
import com.sun.pdfview.decode.LZWDecode;
import com.sun.pdfview.decode.RunLengthDecode;
import java.io.IOException;
import java.nio.ByteBuffer;

public class PDFDecoder {
    private PDFDecoder() {
    }

    public static ByteBuffer decodeStream(PDFObject pDFObject, ByteBuffer byteBuffer) throws IOException {
        boolean bl;
        PDFObject[] pDFObjectArray;
        PDFObject[] pDFObjectArray2;
        PDFObject pDFObject2 = pDFObject.getDictRef("Filter");
        if (pDFObject2 == null) {
            return pDFObject.getDecrypter().decryptBuffer(null, pDFObject, byteBuffer);
        }
        if (pDFObject2.getType() == 4) {
            pDFObjectArray2 = new PDFObject[]{pDFObject2};
            pDFObjectArray = new PDFObject[]{pDFObject.getDictRef("DecodeParms")};
        } else {
            pDFObjectArray2 = pDFObject2.getArray();
            PDFObject pDFObject3 = pDFObject.getDictRef("DecodeParms");
            pDFObjectArray = pDFObject3 != null ? pDFObject3.getArray() : new PDFObject[pDFObjectArray2.length];
        }
        boolean bl2 = bl = pDFObjectArray2.length != 0 && pDFObjectArray2[0].getStringValue().equals("Crypt");
        if (!bl) {
            byteBuffer = pDFObject.getDecrypter().decryptBuffer(null, pDFObject, byteBuffer);
        }
        for (int i = 0; i < pDFObjectArray2.length; ++i) {
            String string = pDFObjectArray2[i].getStringValue();
            if (string == null) continue;
            if (string.equals("FlateDecode") || string.equals("Fl")) {
                byteBuffer = FlateDecode.decode(pDFObject, byteBuffer, pDFObjectArray[i]);
                continue;
            }
            if (string.equals("LZWDecode") || string.equals("LZW")) {
                byteBuffer = LZWDecode.decode(byteBuffer, pDFObjectArray[i]);
                continue;
            }
            if (string.equals("ASCII85Decode") || string.equals("A85")) {
                byteBuffer = ASCII85Decode.decode(byteBuffer, pDFObjectArray[i]);
                continue;
            }
            if (string.equals("ASCIIHexDecode") || string.equals("AHx")) {
                byteBuffer = ASCIIHexDecode.decode(byteBuffer, pDFObjectArray[i]);
                continue;
            }
            if (string.equals("RunLengthDecode") || string.equals("RL")) {
                byteBuffer = RunLengthDecode.decode(byteBuffer, pDFObjectArray[i]);
                continue;
            }
            if (string.equals("DCTDecode") || string.equals("DCT")) {
                byteBuffer = DCTDecode.decode(pDFObject, byteBuffer, pDFObjectArray[i]);
                continue;
            }
            if (string.equals("CCITTFaxDecode") || string.equals("CCF")) {
                byteBuffer = CCITTFaxDecode.decode(pDFObject, byteBuffer, pDFObjectArray[i]);
                continue;
            }
            if (string.equals("Crypt")) {
                PDFObject pDFObject4;
                String string2 = "Identity";
                if (pDFObjectArray[i] != null && (pDFObject4 = pDFObjectArray[i].getDictRef("Name")) != null && pDFObject4.getType() == 4) {
                    string2 = pDFObject4.getStringValue();
                }
                byteBuffer = pDFObject.getDecrypter().decryptBuffer(string2, null, byteBuffer);
                continue;
            }
            throw new PDFParseException("Unknown coding method:" + pDFObjectArray2[i].getStringValue());
        }
        return byteBuffer;
    }
}

