/*
 * Decompiled with CFR 0.152.
 */
package com.sun.pdfview.colorspace;

import com.sun.pdfview.PDFObject;
import com.sun.pdfview.PDFPaint;
import com.sun.pdfview.PDFParseException;
import com.sun.pdfview.colorspace.AlternateColorSpace;
import com.sun.pdfview.colorspace.CMYKColorSpace;
import com.sun.pdfview.colorspace.CalGrayColor;
import com.sun.pdfview.colorspace.CalRGBColor;
import com.sun.pdfview.colorspace.IndexedColor;
import com.sun.pdfview.colorspace.LabColor;
import com.sun.pdfview.colorspace.PatternSpace;
import com.sun.pdfview.function.PDFFunction;
import java.awt.Color;
import java.awt.color.ColorSpace;
import java.awt.color.ICC_ColorSpace;
import java.awt.color.ICC_Profile;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.Map;

public class PDFColorSpace {
    public static final int COLORSPACE_GRAY = 0;
    public static final int COLORSPACE_RGB = 1;
    public static final int COLORSPACE_CMYK = 2;
    public static final int COLORSPACE_PATTERN = 3;
    private static PDFColorSpace rgbSpace = new PDFColorSpace(ColorSpace.getInstance(1000));
    private static PDFColorSpace cmykSpace = new PDFColorSpace(new CMYKColorSpace());
    private static PDFColorSpace patternSpace = new PatternSpace();
    private static PDFColorSpace graySpace;
    ColorSpace cs;

    protected PDFColorSpace(ColorSpace colorSpace) {
        this.cs = colorSpace;
    }

    public static PDFColorSpace getColorSpace(int n) {
        switch (n) {
            case 0: {
                return graySpace;
            }
            case 1: {
                return rgbSpace;
            }
            case 2: {
                return cmykSpace;
            }
            case 3: {
                return patternSpace;
            }
        }
        throw new IllegalArgumentException("Unknown Color Space name: " + n);
    }

    public static PDFColorSpace getColorSpace(PDFObject pDFObject, Map map) throws IOException {
        String string;
        PDFObject pDFObject2 = null;
        if (map != null) {
            pDFObject2 = (PDFObject)map.get("ColorSpace");
        }
        if (pDFObject.getType() == 4) {
            string = pDFObject.getStringValue();
            if (string.equals("DeviceGray") || string.equals("G")) {
                return PDFColorSpace.getColorSpace(0);
            }
            if (string.equals("DeviceRGB") || string.equals("RGB")) {
                return PDFColorSpace.getColorSpace(1);
            }
            if (string.equals("DeviceCMYK") || string.equals("CMYK")) {
                return PDFColorSpace.getColorSpace(2);
            }
            if (string.equals("Pattern")) {
                return PDFColorSpace.getColorSpace(3);
            }
            if (pDFObject2 != null) {
                pDFObject = pDFObject2.getDictRef(string);
            }
        }
        if (pDFObject == null) {
            return null;
        }
        if (pDFObject.getCache() != null) {
            return (PDFColorSpace)pDFObject.getCache();
        }
        PDFColorSpace pDFColorSpace = null;
        PDFObject[] pDFObjectArray = pDFObject.getArray();
        string = pDFObjectArray[0].getStringValue();
        if (string.equals("CalGray")) {
            pDFColorSpace = new PDFColorSpace(new CalGrayColor(pDFObjectArray[1]));
        } else if (string.equals("CalRGB")) {
            pDFColorSpace = new PDFColorSpace(new CalRGBColor(pDFObjectArray[1]));
        } else if (string.equals("Lab")) {
            pDFColorSpace = new PDFColorSpace(new LabColor(pDFObjectArray[1]));
        } else if (string.equals("ICCBased")) {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(pDFObjectArray[1].getStream());
            ICC_Profile iCC_Profile = ICC_Profile.getInstance(byteArrayInputStream);
            pDFColorSpace = new PDFColorSpace(new ICC_ColorSpace(iCC_Profile));
        } else if (string.equals("Separation") || string.equals("DeviceN")) {
            PDFColorSpace pDFColorSpace2 = PDFColorSpace.getColorSpace(pDFObjectArray[2], map);
            PDFFunction pDFFunction = PDFFunction.getFunction(pDFObjectArray[3]);
            pDFColorSpace = new AlternateColorSpace(pDFColorSpace2, pDFFunction);
        } else if (string.equals("Indexed") || string.equals("I")) {
            PDFColorSpace pDFColorSpace3 = PDFColorSpace.getColorSpace(pDFObjectArray[1], map);
            int n = pDFObjectArray[2].getIntValue();
            pDFColorSpace = new IndexedColor(pDFColorSpace3, n, pDFObjectArray[3]);
        } else {
            if (string.equals("Pattern")) {
                if (pDFObjectArray.length == 1) {
                    return PDFColorSpace.getColorSpace(3);
                }
                PDFColorSpace pDFColorSpace4 = PDFColorSpace.getColorSpace(pDFObjectArray[1], map);
                return new PatternSpace(pDFColorSpace4);
            }
            throw new PDFParseException("Unknown color space: " + string + " with " + pDFObjectArray[1]);
        }
        pDFObject.setCache(pDFColorSpace);
        return pDFColorSpace;
    }

    public int getNumComponents() {
        return this.cs.getNumComponents();
    }

    public PDFPaint getPaint(float[] fArray) {
        float[] fArray2 = this.cs.toRGB(fArray);
        return PDFPaint.getColorPaint(new Color(fArray2[0], fArray2[1], fArray2[2]));
    }

    public ColorSpace getColorSpace() {
        return this.cs;
    }

    static {
        boolean bl = true;
        try {
            graySpace = new PDFColorSpace(!bl ? ColorSpace.getInstance(1003) : new ICC_ColorSpace(ICC_Profile.getInstance(PDFColorSpace.class.getResourceAsStream("sGray.icc"))));
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }
}

