/*
 * Decompiled with CFR 0.152.
 */
package com.sun.pdfview;

import com.sun.pdfview.PDFPage;
import com.sun.pdfview.PDFParseException;
import com.sun.pdfview.font.PDFFont;
import com.sun.pdfview.font.PDFGlyph;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.util.List;

public class PDFTextFormat
implements Cloneable {
    private float tc = 0.0f;
    private float tw = 0.0f;
    private float th = 1.0f;
    private float tl = 0.0f;
    private float tr = 0.0f;
    private int tm = 2;
    private float tk = 0.0f;
    private AffineTransform cur;
    private AffineTransform line;
    private PDFFont font;
    private float fsize = 1.0f;
    private boolean inuse = false;
    private StringBuffer word = new StringBuffer();
    private Point2D.Float wordStart;
    private Point2D.Float prevEnd;

    public PDFTextFormat() {
        this.cur = new AffineTransform();
        this.line = new AffineTransform();
        this.wordStart = new Point2D.Float(-100.0f, -100.0f);
        this.prevEnd = new Point2D.Float(-100.0f, -100.0f);
    }

    public void reset() {
        this.cur.setToIdentity();
        this.line.setToIdentity();
        this.inuse = true;
        this.word.setLength(0);
    }

    public void end() {
        this.inuse = false;
    }

    public float getCharSpacing() {
        return this.tc;
    }

    public void setCharSpacing(float f) {
        this.tc = f;
    }

    public float getWordSpacing() {
        return this.tw;
    }

    public void setWordSpacing(float f) {
        this.tw = f;
    }

    public float getHorizontalScale() {
        return this.th * 100.0f;
    }

    public void setHorizontalScale(float f) {
        this.th = f / 100.0f;
    }

    public float getLeading() {
        return this.tl;
    }

    public void setLeading(float f) {
        this.tl = f;
    }

    public PDFFont getFont() {
        return this.font;
    }

    public float getFontSize() {
        return this.fsize;
    }

    public void setFont(PDFFont pDFFont, float f) {
        this.font = pDFFont;
        this.fsize = f;
    }

    public int getMode() {
        return this.tm;
    }

    public void setMode(int n) {
        int n2 = 0;
        if ((n & 1) == 0) {
            n2 |= 2;
        }
        if ((n & 4) != 0) {
            n2 |= 4;
        }
        if ((n & 1 ^ (n & 2) >> 1) != 0) {
            n2 |= 1;
        }
        this.tm = n2;
    }

    public void setTextFormatMode(int n) {
        this.tm = n;
    }

    public float getRise() {
        return this.tr;
    }

    public void setRise(float f) {
        this.tr = f;
    }

    public void carriageReturn() {
        this.carriageReturn(0.0f, -this.tl);
    }

    public void carriageReturn(float f, float f2) {
        this.line.concatenate(AffineTransform.getTranslateInstance(f, f2));
        this.cur.setTransform(this.line);
    }

    public AffineTransform getTransform() {
        return this.cur;
    }

    public void setMatrix(float[] fArray) {
        this.line = new AffineTransform(fArray);
        this.cur.setTransform(this.line);
    }

    public void doText(PDFPage pDFPage, String string) {
        Point2D.Float float_ = new Point2D.Float();
        AffineTransform affineTransform = new AffineTransform(this.fsize, 0.0f, 0.0f, this.fsize * this.th, 0.0f, this.tr);
        AffineTransform affineTransform2 = new AffineTransform();
        List<PDFGlyph> list = this.font.getGlyphs(string);
        for (PDFGlyph pDFGlyph : list) {
            affineTransform2.setTransform(this.cur);
            affineTransform2.concatenate(affineTransform);
            Point2D point2D = pDFGlyph.addCommands(pDFPage, affineTransform2, this.tm);
            double d = point2D.getX() * (double)this.fsize + (double)this.tc;
            if (pDFGlyph.getChar() == ' ') {
                d += (double)this.tw;
            }
            this.cur.translate(d *= (double)this.th, point2D.getY());
        }
        this.cur.transform(float_, this.prevEnd);
    }

    public void doText(PDFPage pDFPage, Object[] objectArray) throws PDFParseException {
        for (int i = 0; i < objectArray.length; ++i) {
            if (objectArray[i] instanceof String) {
                this.doText(pDFPage, (String)objectArray[i]);
                continue;
            }
            if (objectArray[i] instanceof Double) {
                float f = ((Double)objectArray[i]).floatValue() / 1000.0f;
                this.cur.translate(-f * this.fsize * this.th, 0.0);
                continue;
            }
            throw new PDFParseException("Bad element in TJ array");
        }
    }

    public void flush() {
    }

    public Object clone() {
        PDFTextFormat pDFTextFormat = new PDFTextFormat();
        pDFTextFormat.setCharSpacing(this.getCharSpacing());
        pDFTextFormat.setWordSpacing(this.getWordSpacing());
        pDFTextFormat.setHorizontalScale(this.getHorizontalScale());
        pDFTextFormat.setLeading(this.getLeading());
        pDFTextFormat.setTextFormatMode(this.getMode());
        pDFTextFormat.setRise(this.getRise());
        pDFTextFormat.setFont(this.getFont(), this.getFontSize());
        return pDFTextFormat;
    }
}

