/*
 * Decompiled with CFR 0.152.
 */
package com.sun.pdfview;

import com.sun.pdfview.Cache;
import com.sun.pdfview.OutlineNode;
import com.sun.pdfview.PDFDestination;
import com.sun.pdfview.PDFObject;
import com.sun.pdfview.PDFPage;
import com.sun.pdfview.PDFParseException;
import com.sun.pdfview.PDFParser;
import com.sun.pdfview.PDFXref;
import com.sun.pdfview.action.GoToAction;
import com.sun.pdfview.action.PDFAction;
import com.sun.pdfview.decrypt.EncryptionUnsupportedByPlatformException;
import com.sun.pdfview.decrypt.EncryptionUnsupportedByProductException;
import com.sun.pdfview.decrypt.IdentityDecrypter;
import com.sun.pdfview.decrypt.PDFAuthenticationFailureException;
import com.sun.pdfview.decrypt.PDFDecrypter;
import com.sun.pdfview.decrypt.PDFDecrypterFactory;
import com.sun.pdfview.decrypt.PDFPassword;
import com.sun.pdfview.decrypt.UnsupportedEncryptionException;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;

public class PDFFile {
    public static final int NUL_CHAR = 0;
    public static final int FF_CHAR = 12;
    private String versionString = "1.1";
    private int majorVersion = 1;
    private int minorVersion = 1;
    private static final String VERSION_COMMENT = "%PDF-";
    ByteBuffer buf;
    PDFXref[] objIdx;
    PDFObject root = null;
    PDFObject encrypt = null;
    PDFObject info = null;
    Cache cache;
    private boolean printable = true;
    private boolean saveable = true;
    private PDFDecrypter defaultDecrypter = IdentityDecrypter.getInstance();

    public PDFFile(ByteBuffer byteBuffer) throws IOException {
        this(byteBuffer, null);
    }

    public PDFFile(ByteBuffer byteBuffer, PDFPassword pDFPassword) throws IOException {
        this.buf = byteBuffer;
        this.cache = new Cache();
        this.parseFile(pDFPassword);
    }

    public boolean isPrintable() {
        return this.printable;
    }

    public boolean isSaveable() {
        return this.saveable;
    }

    public PDFObject getRoot() {
        return this.root;
    }

    public int getNumPages() {
        try {
            return this.root.getDictRef("Pages").getDictRef("Count").getIntValue();
        }
        catch (Exception exception) {
            return 0;
        }
    }

    public String getStringMetadata(String string) throws IOException {
        if (this.info != null) {
            PDFObject pDFObject = this.info.getDictRef(string);
            return pDFObject != null ? pDFObject.getTextStringValue() : null;
        }
        return null;
    }

    public Iterator<String> getMetadataKeys() throws IOException {
        if (this.info != null) {
            return this.info.getDictKeys();
        }
        return Collections.emptyList().iterator();
    }

    public synchronized PDFObject dereference(PDFXref pDFXref, PDFDecrypter pDFDecrypter) throws IOException {
        int n = pDFXref.getID();
        if (n >= this.objIdx.length || this.objIdx[n] == null) {
            return PDFObject.nullObj;
        }
        PDFObject pDFObject = this.objIdx[n].getObject();
        if (pDFObject != null) {
            return pDFObject;
        }
        int n2 = this.objIdx[n].getFilePos();
        if (n2 < 0) {
            return PDFObject.nullObj;
        }
        int n3 = this.buf.position();
        this.buf.position(n2);
        pDFObject = this.readObject(pDFXref.getID(), pDFXref.getGeneration(), pDFDecrypter);
        if (pDFObject == null) {
            pDFObject = PDFObject.nullObj;
        }
        this.objIdx[n].setObject(pDFObject);
        this.buf.position(n3);
        return pDFObject;
    }

    public static boolean isWhiteSpace(int n) {
        switch (n) {
            case 0: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 32: {
                return true;
            }
        }
        return false;
    }

    public static boolean isDelimiter(int n) {
        switch (n) {
            case 37: 
            case 40: 
            case 41: 
            case 47: 
            case 60: 
            case 62: 
            case 91: 
            case 93: 
            case 123: 
            case 125: {
                return true;
            }
        }
        return false;
    }

    public static boolean isRegularCharacter(int n) {
        return !PDFFile.isWhiteSpace(n) && !PDFFile.isDelimiter(n);
    }

    private PDFObject readObject(int n, int n2, PDFDecrypter pDFDecrypter) throws IOException {
        return this.readObject(n, n2, false, pDFDecrypter);
    }

    private PDFObject readObject(int n, int n2, boolean bl, PDFDecrypter pDFDecrypter) throws IOException {
        PDFObject pDFObject = null;
        while (pDFObject == null) {
            byte by;
            while (PDFFile.isWhiteSpace(by = this.buf.get())) {
            }
            if (by == 60) {
                by = this.buf.get();
                if (by == 60) {
                    pDFObject = this.readDictionary(n, n2, pDFDecrypter);
                    continue;
                }
                this.buf.position(this.buf.position() - 1);
                pDFObject = this.readHexString(n, n2, pDFDecrypter);
                continue;
            }
            if (by == 40) {
                pDFObject = this.readLiteralString(n, n2, pDFDecrypter);
                continue;
            }
            if (by == 91) {
                pDFObject = this.readArray(n, n2, pDFDecrypter);
                continue;
            }
            if (by == 47) {
                pDFObject = this.readName();
                continue;
            }
            if (by == 37) {
                this.readLine();
                continue;
            }
            if (by >= 48 && by <= 57 || by == 45 || by == 43 || by == 46) {
                pDFObject = this.readNumber((char)by);
                if (bl) continue;
                int n3 = this.buf.position();
                PDFObject pDFObject2 = this.readObject(-1, -1, true, pDFDecrypter);
                if (pDFObject2 != null && pDFObject2.getType() == 2) {
                    PDFObject pDFObject3 = this.readObject(-1, -1, true, pDFDecrypter);
                    if (pDFObject3 != null && pDFObject3.getType() == 9 && pDFObject3.getStringValue().equals("R")) {
                        PDFXref pDFXref = new PDFXref(pDFObject.getIntValue(), pDFObject2.getIntValue());
                        pDFObject = new PDFObject(this, pDFXref);
                        continue;
                    }
                    if (pDFObject3 != null && pDFObject3.getType() == 9 && pDFObject3.getStringValue().equals("obj")) {
                        pDFObject = this.readObjectDescription(pDFObject.getIntValue(), pDFObject2.getIntValue(), pDFDecrypter);
                        continue;
                    }
                    this.buf.position(n3);
                    continue;
                }
                this.buf.position(n3);
                continue;
            }
            if (by >= 97 && by <= 122 || by >= 65 && by <= 90) {
                pDFObject = this.readKeyword((char)by);
                continue;
            }
            this.buf.position(this.buf.position() - 1);
            break;
        }
        return pDFObject;
    }

    private boolean nextItemIs(String string) throws IOException {
        byte by;
        while (PDFFile.isWhiteSpace(by = this.buf.get())) {
        }
        for (int i = 0; i < string.length(); ++i) {
            if (i > 0) {
                by = this.buf.get();
            }
            if (by == string.charAt(i)) continue;
            return false;
        }
        return true;
    }

    private void processVersion(String string) {
        try {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
            this.majorVersion = Integer.parseInt(stringTokenizer.nextToken());
            this.minorVersion = Integer.parseInt(stringTokenizer.nextToken());
            this.versionString = string;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public int getMajorVersion() {
        return this.majorVersion;
    }

    public int getMinorVersion() {
        return this.minorVersion;
    }

    public String getVersionString() {
        return this.versionString;
    }

    private PDFObject readDictionary(int n, int n2, PDFDecrypter pDFDecrypter) throws IOException {
        PDFObject pDFObject;
        HashMap<String, PDFObject> hashMap = new HashMap<String, PDFObject>();
        while ((pDFObject = this.readObject(n, n2, pDFDecrypter)) != null) {
            if (pDFObject.getType() != 4) {
                throw new PDFParseException("First item in dictionary must be a /Name.  (Was " + pDFObject + ")");
            }
            PDFObject pDFObject2 = this.readObject(n, n2, pDFDecrypter);
            if (pDFObject2 == null) continue;
            hashMap.put(pDFObject.getStringValue(), pDFObject2);
        }
        if (!this.nextItemIs(">>")) {
            throw new PDFParseException("End of dictionary wasn't '>>'");
        }
        return new PDFObject(this, 6, hashMap);
    }

    private int readHexDigit() throws IOException {
        int n;
        while (PDFFile.isWhiteSpace(n = this.buf.get())) {
        }
        switch (n) {
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: {
                n -= 48;
                break;
            }
            case 97: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 102: {
                n -= 87;
                break;
            }
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: {
                n -= 55;
                break;
            }
            default: {
                n = -1;
            }
        }
        return n;
    }

    private int readHexPair() throws IOException {
        int n = this.readHexDigit();
        if (n < 0) {
            this.buf.position(this.buf.position() - 1);
            return -1;
        }
        int n2 = this.readHexDigit();
        if (n2 < 0) {
            this.buf.position(this.buf.position() - 1);
            return n << 4;
        }
        return (n << 4) + n2;
    }

    private PDFObject readHexString(int n, int n2, PDFDecrypter pDFDecrypter) throws IOException {
        int n3;
        StringBuffer stringBuffer = new StringBuffer();
        while ((n3 = this.readHexPair()) >= 0) {
            stringBuffer.append((char)n3);
        }
        if (this.buf.get() != 62) {
            throw new PDFParseException("Bad character in Hex String");
        }
        String string = this.unicode(stringBuffer.toString());
        return new PDFObject(this, 3, pDFDecrypter.decryptString(n, n2, string));
    }

    private String unicode(String string) {
        if (string.length() < 2 || string.length() % 2 != 0) {
            return string;
        }
        int n = string.charAt(0) & 0xFF;
        int n2 = string.charAt(1) & 0xFF;
        if (n == 254 && n2 == 255 || n == 255 && n2 == 254) {
            boolean bl = string.charAt(1) == '\uffff';
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 2; i < string.length(); i += 2) {
                if (bl) {
                    stringBuffer.append((char)(((string.charAt(i + 1) & 0xFF) << 8) + (string.charAt(i) & 0xFF)));
                    continue;
                }
                stringBuffer.append((char)(((string.charAt(i) & 0xFF) << 8) + (string.charAt(i + 1) & 0xFF)));
            }
            return stringBuffer.toString();
        }
        return string;
    }

    private PDFObject readLiteralString(int n, int n2, PDFDecrypter pDFDecrypter) throws IOException {
        int n3 = 1;
        StringBuffer stringBuffer = new StringBuffer();
        while (n3 > 0) {
            int n4 = this.buf.get() & 0xFF;
            if (n4 == 40) {
                ++n3;
            } else if (n4 == 41) {
                if (--n3 == 0) {
                    n4 = -1;
                    break;
                }
            } else if (n4 == 92) {
                n4 = this.buf.get() & 0xFF;
                if (n4 >= 48 && n4 <= 57) {
                    int n5 = 0;
                    for (int i = 0; n4 >= 48 && n4 <= 56 && i < 3; ++i) {
                        n5 = n5 * 8 + n4 - 48;
                        n4 = this.buf.get() & 0xFF;
                    }
                    this.buf.position(this.buf.position() - 1);
                    n4 = n5;
                } else if (n4 == 114) {
                    n4 = 10;
                } else if (n4 == 110) {
                    n4 = 10;
                } else if (n4 == 116) {
                    n4 = 9;
                } else if (n4 == 98) {
                    n4 = 8;
                } else if (n4 == 102) {
                    n4 = 12;
                } else if (n4 == 13) {
                    n4 = this.buf.get() & 0xFF;
                    if (n4 != 10) {
                        this.buf.position(this.buf.position() - 1);
                    }
                    n4 = -1;
                } else if (n4 == 10) {
                    n4 = -1;
                }
            }
            if (n4 < 0) continue;
            stringBuffer.append((char)n4);
        }
        String string = this.unicode(stringBuffer.toString());
        return new PDFObject(this, 3, pDFDecrypter.decryptString(n, n2, string));
    }

    private String readLine() {
        StringBuffer stringBuffer = new StringBuffer();
        while (this.buf.remaining() > 0) {
            char c = (char)this.buf.get();
            if (c == '\r') {
                char c2;
                if (this.buf.remaining() <= 0 || (c2 = (char)this.buf.get(this.buf.position())) != '\n') break;
                this.buf.get();
                break;
            }
            if (c == '\n') break;
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }

    private PDFObject readArray(int n, int n2, PDFDecrypter pDFDecrypter) throws IOException {
        PDFObject pDFObject;
        ArrayList<PDFObject> arrayList = new ArrayList<PDFObject>();
        while ((pDFObject = this.readObject(n, n2, pDFDecrypter)) != null) {
            arrayList.add(pDFObject);
        }
        if (this.buf.get() != 93) {
            throw new PDFParseException("Array should end with ']'");
        }
        PDFObject[] pDFObjectArray = new PDFObject[arrayList.size()];
        for (int i = 0; i < pDFObjectArray.length; ++i) {
            pDFObjectArray[i] = (PDFObject)arrayList.get(i);
        }
        return new PDFObject(this, 5, pDFObjectArray);
    }

    private PDFObject readName() throws IOException {
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        while (PDFFile.isRegularCharacter(n = this.buf.get()) && (n >= 33 || n <= 126)) {
            if (n == 35 && this.majorVersion != 1 && this.minorVersion != 1) {
                int n2 = this.readHexPair();
                if (n2 >= 0) {
                    n = n2;
                } else {
                    throw new PDFParseException("Bad #hex in /Name");
                }
            }
            stringBuffer.append((char)n);
        }
        this.buf.position(this.buf.position() - 1);
        return new PDFObject(this, 4, stringBuffer.toString());
    }

    private PDFObject readNumber(char c) throws IOException {
        double d;
        boolean bl = c == '-';
        boolean bl2 = c == '.';
        double d2 = bl2 ? 0.1 : 1.0;
        double d3 = d = c >= '0' && c <= '9' ? (double)(c - 48) : 0.0;
        while (true) {
            byte by;
            if ((by = this.buf.get()) == 46) {
                if (bl2) {
                    throw new PDFParseException("Can't have two '.' in a number");
                }
                bl2 = true;
                d2 = 0.1;
                continue;
            }
            if (by < 48 || by > 57) break;
            int n = by - 48;
            if (bl2) {
                d += (double)n * d2;
                d2 *= 0.1;
                continue;
            }
            d = d * 10.0 + (double)n;
        }
        this.buf.position(this.buf.position() - 1);
        if (bl) {
            d = -d;
        }
        return new PDFObject(this, 2, new Double(d));
    }

    private PDFObject readKeyword(char c) throws IOException {
        byte by;
        StringBuffer stringBuffer = new StringBuffer(String.valueOf(c));
        while (PDFFile.isRegularCharacter(by = this.buf.get())) {
            stringBuffer.append((char)by);
        }
        this.buf.position(this.buf.position() - 1);
        return new PDFObject(this, 9, stringBuffer.toString());
    }

    private PDFObject readObjectDescription(int n, int n2, PDFDecrypter pDFDecrypter) throws IOException {
        Object object;
        long l = this.buf.position();
        PDFObject pDFObject = this.readObject(n, n2, pDFDecrypter);
        PDFObject pDFObject2 = this.readObject(n, n2, pDFDecrypter);
        if (pDFObject2.getType() != 9) {
            throw new PDFParseException("Expected 'stream' or 'endobj'");
        }
        if (pDFObject.getType() == 6 && pDFObject2.getStringValue().equals("stream")) {
            this.readLine();
            object = this.readStream(pDFObject);
            if (object == null) {
                object = ByteBuffer.allocate(0);
            }
            pDFObject.setStream((ByteBuffer)object);
            pDFObject2 = this.readObject(n, n2, pDFDecrypter);
        }
        if ((object = pDFObject2.getStringValue()) == null || !((String)object).equals("endobj")) {
            System.out.println("WARNING: object at " + l + " didn't end with 'endobj'");
        }
        pDFObject.setObjectId(n, n2);
        return pDFObject;
    }

    private ByteBuffer readStream(PDFObject pDFObject) throws IOException {
        PDFObject pDFObject2 = pDFObject.getDictRef("Length");
        int n = -1;
        if (pDFObject2 != null) {
            n = pDFObject2.getIntValue();
        }
        if (n < 0) {
            throw new PDFParseException("Unknown length for stream");
        }
        int n2 = this.buf.position();
        ByteBuffer byteBuffer = this.buf.slice();
        byteBuffer.limit(n);
        this.buf.position(this.buf.position() + n);
        int n3 = this.buf.position();
        if (!this.nextItemIs("endstream")) {
            System.out.println("read " + n + " chars from " + n2 + " to " + n3);
            throw new PDFParseException("Stream ended inappropriately");
        }
        return byteBuffer;
    }

    private void readTrailer(PDFPassword pDFPassword) throws IOException, PDFAuthenticationFailureException, EncryptionUnsupportedByProductException, EncryptionUnsupportedByPlatformException {
        PDFObject pDFObject;
        this.objIdx = new PDFXref[50];
        PDFDecrypter pDFDecrypter = null;
        while (true) {
            PDFObject pDFObject2;
            if (!this.nextItemIs("xref")) {
                throw new PDFParseException("Expected 'xref' at start of table");
            }
            while ((pDFObject = this.readObject(-1, -1, IdentityDecrypter.getInstance())).getType() != 9 || !pDFObject.getStringValue().equals("trailer")) {
                if (pDFObject.getType() != 2) {
                    throw new PDFParseException("Expected number for first xref entry");
                }
                int n = pDFObject.getIntValue();
                pDFObject = this.readObject(-1, -1, IdentityDecrypter.getInstance());
                if (pDFObject.getType() != 2) {
                    throw new PDFParseException("Expected number for length of xref table");
                }
                int n2 = pDFObject.getIntValue();
                this.readLine();
                if (n + n2 >= this.objIdx.length) {
                    PDFXref[] pDFXrefArray = new PDFXref[n + n2];
                    System.arraycopy(this.objIdx, 0, pDFXrefArray, 0, this.objIdx.length);
                    this.objIdx = pDFXrefArray;
                }
                for (int i = n; i < n + n2; ++i) {
                    byte[] byArray = new byte[20];
                    this.buf.get(byArray);
                    if (this.objIdx[i] != null) continue;
                    this.objIdx[i] = byArray[17] == 110 ? new PDFXref(byArray) : new PDFXref(null);
                }
            }
            pDFObject = this.readObject(-1, -1, IdentityDecrypter.getInstance());
            if (pDFObject.getType() != 6) {
                throw new IOException("Expected dictionary after \"trailer\"");
            }
            if (this.root == null) {
                this.root = pDFObject.getDictRef("Root");
                if (this.root != null) {
                    this.root.setObjectId(-1, -1);
                }
            }
            if (this.encrypt == null) {
                this.encrypt = pDFObject.getDictRef("Encrypt");
                if (this.encrypt != null) {
                    this.encrypt.setObjectId(-1, -1);
                }
                pDFDecrypter = PDFDecrypterFactory.createDecryptor(this.encrypt, pDFObject.getDictRef("ID"), pDFPassword);
            }
            if (this.info == null) {
                this.info = pDFObject.getDictRef("Info");
                if (this.info != null) {
                    if (!this.info.isIndirect()) {
                        throw new PDFParseException("Info in trailer must be an indirect reference");
                    }
                    this.info.setObjectId(-1, -1);
                }
            }
            if ((pDFObject2 = pDFObject.getDictRef("Prev")) == null) break;
            this.buf.position(pDFObject2.getIntValue());
            if (this.root.getDictRef("Version") == null) continue;
            this.processVersion(this.root.getDictRef("Version").getStringValue());
        }
        if (this.root == null) {
            throw new PDFParseException("No /Root key found in trailer dictionary");
        }
        if (this.encrypt != null) {
            pDFObject = this.encrypt.getDictRef("P");
            if (pDFObject != null && !pDFDecrypter.isOwnerAuthorised()) {
                int n;
                int n3 = n = pDFObject != null ? pDFObject.getIntValue() : 0;
                if (pDFObject != null) {
                    this.printable = (n & 4) != 0;
                    this.saveable = (n & 0x10) != 0;
                }
            }
            this.defaultDecrypter = pDFDecrypter;
        }
        this.root.dereference();
    }

    private void parseFile(PDFPassword pDFPassword) throws IOException {
        String string;
        int n;
        this.buf.rewind();
        String string2 = this.readLine();
        if (string2.startsWith(VERSION_COMMENT)) {
            this.processVersion(string2.substring(VERSION_COMMENT.length()));
        }
        this.buf.rewind();
        byte[] byArray = new byte[32];
        int n2 = 0;
        for (n = this.buf.remaining() - byArray.length; n >= 0; n -= byArray.length - 10) {
            this.buf.position(n);
            this.buf.get(byArray);
            string = new String(byArray);
            n2 = string.indexOf("startxref");
            if (n2 <= 0) continue;
            if (n + n2 + byArray.length > this.buf.limit()) break;
            n += n2;
            n2 = 0;
            break;
        }
        if (n < 0) {
            throw new IOException("This may not be a PDF File");
        }
        this.buf.position(n);
        this.buf.get(byArray);
        string = new String(byArray);
        if (string.charAt(n2 += 10) < ' ') {
            ++n2;
        }
        while (string.charAt(n2) == ' ') {
            ++n2;
        }
        int n3 = n2;
        while (n2 < string.length() && string.charAt(n2) >= '0' && string.charAt(n2) <= '9') {
            ++n2;
        }
        int n4 = Integer.parseInt(string.substring(n3, n2));
        this.buf.position(n4);
        try {
            this.readTrailer(pDFPassword);
        }
        catch (UnsupportedEncryptionException unsupportedEncryptionException) {
            throw new PDFParseException(unsupportedEncryptionException.getMessage(), unsupportedEncryptionException);
        }
    }

    public OutlineNode getOutline() throws IOException {
        PDFObject pDFObject = this.root.getDictRef("Outlines");
        OutlineNode outlineNode = null;
        OutlineNode outlineNode2 = null;
        if (pDFObject != null) {
            Object object = pDFObject.getDictRef("First");
            outlineNode2 = outlineNode = new OutlineNode("<top>");
            while (object != null) {
                Object object2;
                PDFObject pDFObject2;
                String string = ((PDFObject)object).getDictRef("Title").getTextStringValue();
                OutlineNode outlineNode3 = new OutlineNode(string);
                outlineNode.add(outlineNode3);
                PDFAction pDFAction = null;
                PDFObject pDFObject3 = ((PDFObject)object).getDictRef("A");
                if (pDFObject3 != null) {
                    pDFAction = PDFAction.getAction(pDFObject3, this.getRoot());
                } else {
                    pDFObject2 = ((PDFObject)object).getDictRef("Dest");
                    if (pDFObject2 != null) {
                        try {
                            object2 = PDFDestination.getDestination(pDFObject2, this.getRoot());
                            pDFAction = new GoToAction((PDFDestination)object2);
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                }
                if (pDFAction != null) {
                    outlineNode3.setAction(pDFAction);
                }
                if ((pDFObject2 = ((PDFObject)object).getDictRef("First")) != null) {
                    outlineNode = outlineNode3;
                    object = pDFObject2;
                    continue;
                }
                object2 = ((PDFObject)object).getDictRef("Next");
                while (object2 == null) {
                    object = ((PDFObject)object).getDictRef("Parent");
                    object2 = ((PDFObject)object).getDictRef("Next");
                    if ((outlineNode = (OutlineNode)outlineNode.getParent()) != null) continue;
                }
                object = object2;
            }
        }
        return outlineNode2;
    }

    public int getPageNumber(PDFObject pDFObject) throws IOException {
        PDFObject pDFObject2;
        PDFObject pDFObject3;
        if (pDFObject.getType() == 5) {
            pDFObject = pDFObject.getAt(0);
        }
        if ((pDFObject3 = pDFObject.getDictRef("Type")) == null || !pDFObject3.getStringValue().equals("Page")) {
            return 0;
        }
        int n = 0;
        while ((pDFObject2 = pDFObject.getDictRef("Parent")) != null) {
            PDFObject[] pDFObjectArray = pDFObject2.getDictRef("Kids").getArray();
            for (int i = 0; i < pDFObjectArray.length && !pDFObjectArray[i].equals(pDFObject); ++i) {
                PDFObject pDFObject4 = pDFObjectArray[i].getDictRef("Count");
                if (pDFObject4 != null) {
                    n += pDFObject4.getIntValue();
                    continue;
                }
                ++n;
            }
            pDFObject = pDFObject2;
        }
        return n;
    }

    public PDFPage getPage(int n) {
        return this.getPage(n, false);
    }

    public PDFPage getPage(int n, boolean bl) {
        Integer n2 = new Integer(n);
        HashMap<String, PDFObject> hashMap = null;
        PDFObject pDFObject = null;
        boolean bl2 = false;
        PDFPage pDFPage = this.cache.getPage(n2);
        PDFParser pDFParser = this.cache.getPageParser(n2);
        if (pDFPage == null) {
            try {
                hashMap = new HashMap<String, PDFObject>();
                PDFObject pDFObject2 = this.root.getDictRef("Pages");
                pDFObject = this.findPage(pDFObject2, 0, n, hashMap);
                if (pDFObject == null) {
                    return null;
                }
                pDFPage = this.createPage(n, pDFObject);
                byte[] byArray = this.getContents(pDFObject);
                pDFParser = new PDFParser(pDFPage, byArray, hashMap);
                this.cache.addPage(n2, pDFPage, pDFParser);
            }
            catch (IOException iOException) {
                System.out.println("GetPage inner loop:");
                iOException.printStackTrace();
                return null;
            }
        }
        if (pDFParser != null && !pDFParser.isFinished()) {
            pDFParser.go(bl);
        }
        return pDFPage;
    }

    public void stop(int n) {
        PDFParser pDFParser = this.cache.getPageParser(new Integer(n));
        if (pDFParser != null) {
            pDFParser.stop();
        }
    }

    private byte[] getContents(PDFObject pDFObject) throws IOException {
        PDFObject pDFObject2 = pDFObject.getDictRef("Contents");
        if (pDFObject2 == null) {
            throw new IOException("No page contents!");
        }
        PDFObject[] pDFObjectArray = pDFObject2.getArray();
        if (pDFObjectArray.length == 1) {
            return pDFObjectArray[0].getStream();
        }
        int n = 0;
        for (int i = 0; i < pDFObjectArray.length; ++i) {
            byte[] byArray = pDFObjectArray[i].getStream();
            if (byArray == null) {
                throw new PDFParseException("No stream on content " + i + ": " + pDFObjectArray[i]);
            }
            n += byArray.length;
        }
        byte[] byArray = new byte[n];
        n = 0;
        for (int i = 0; i < pDFObjectArray.length; ++i) {
            byte[] byArray2 = pDFObjectArray[i].getStream();
            System.arraycopy(byArray2, 0, byArray, n, byArray2.length);
            n += byArray2.length;
        }
        return byArray;
    }

    private PDFPage createPage(int n, PDFObject pDFObject) throws IOException {
        PDFObject pDFObject2;
        PDFObject pDFObject3;
        int n2 = 0;
        Rectangle2D.Float float_ = null;
        Rectangle2D.Float float_2 = null;
        PDFObject pDFObject4 = this.getInheritedValue(pDFObject, "MediaBox");
        if (pDFObject4 != null) {
            float_ = this.parseRect(pDFObject4);
        }
        if ((pDFObject3 = this.getInheritedValue(pDFObject, "CropBox")) != null) {
            float_2 = this.parseRect(pDFObject3);
        }
        if ((pDFObject2 = this.getInheritedValue(pDFObject, "Rotate")) != null) {
            n2 = pDFObject2.getIntValue();
        }
        Rectangle2D.Float float_3 = float_2 == null ? float_ : float_2;
        return new PDFPage(n, float_3, n2, this.cache);
    }

    private PDFObject findPage(PDFObject pDFObject, int n, int n2, Map<String, PDFObject> map) throws IOException {
        PDFObject pDFObject2;
        PDFObject pDFObject3 = pDFObject.getDictRef("Resources");
        if (pDFObject3 != null) {
            map.putAll(pDFObject3.getDictionary());
        }
        if ((pDFObject2 = pDFObject.getDictRef("Type")) != null && pDFObject2.getStringValue().equals("Page")) {
            return pDFObject;
        }
        PDFObject pDFObject4 = pDFObject.getDictRef("Kids");
        if (pDFObject4 != null) {
            PDFObject[] pDFObjectArray = pDFObject4.getArray();
            for (int i = 0; i < pDFObjectArray.length; ++i) {
                int n3 = 1;
                PDFObject pDFObject5 = pDFObjectArray[i].getDictRef("Count");
                if (pDFObject5 != null) {
                    n3 = pDFObject5.getIntValue();
                }
                if (n + n3 >= n2) {
                    return this.findPage(pDFObjectArray[i], n, n2, map);
                }
                n += n3;
            }
        }
        return null;
    }

    private PDFObject getInheritedValue(PDFObject pDFObject, String string) throws IOException {
        PDFObject pDFObject2 = pDFObject.getDictRef(string);
        if (pDFObject2 != null) {
            return pDFObject2;
        }
        PDFObject pDFObject3 = pDFObject.getDictRef("Parent");
        if (pDFObject3 != null) {
            return this.getInheritedValue(pDFObject3, string);
        }
        return null;
    }

    public Rectangle2D.Float parseRect(PDFObject pDFObject) throws IOException {
        if (pDFObject.getType() == 5) {
            PDFObject[] pDFObjectArray = pDFObject.getArray();
            if (pDFObjectArray.length == 4) {
                return new Rectangle2D.Float(pDFObjectArray[0].getFloatValue(), pDFObjectArray[1].getFloatValue(), pDFObjectArray[2].getFloatValue() - pDFObjectArray[0].getFloatValue(), pDFObjectArray[3].getFloatValue() - pDFObjectArray[1].getFloatValue());
            }
            throw new PDFParseException("Rectangle definition didn't have 4 elements");
        }
        throw new PDFParseException("Rectangle definition not an array");
    }

    public PDFDecrypter getDefaultDecrypter() {
        return this.defaultDecrypter;
    }
}

