/*
 * Decompiled with CFR 0.152.
 */
package com.sun.pdfview;

import com.sun.pdfview.PDFStringUtil;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import java.util.HashMap;
import java.util.Map;

public class PDFDocCharsetEncoder
extends CharsetEncoder {
    static final boolean[] IDENT_PDF_DOC_ENCODING_MAP = new boolean[256];
    static final Map<Character, Byte> EXTENDED_TO_PDF_DOC_ENCODING_MAP = new HashMap<Character, Byte>();

    public static boolean isIdentityEncoding(char c) {
        return c >= '\u0000' && c <= '\u00ff' && IDENT_PDF_DOC_ENCODING_MAP[c];
    }

    public PDFDocCharsetEncoder() {
        super(null, 1.0f, 1.0f);
    }

    @Override
    protected CoderResult encodeLoop(CharBuffer charBuffer, ByteBuffer byteBuffer) {
        while (charBuffer.remaining() > 0) {
            if (byteBuffer.remaining() < 1) {
                return CoderResult.OVERFLOW;
            }
            char c = charBuffer.get();
            if (c >= '\u0000' && c < '\u0100' && IDENT_PDF_DOC_ENCODING_MAP[c]) {
                byteBuffer.put((byte)c);
                continue;
            }
            Byte by = EXTENDED_TO_PDF_DOC_ENCODING_MAP.get(Character.valueOf(c));
            if (by != null) {
                byteBuffer.put(by);
                continue;
            }
            return CoderResult.unmappableForLength(1);
        }
        return CoderResult.UNDERFLOW;
    }

    @Override
    public boolean isLegalReplacement(byte[] byArray) {
        return true;
    }

    static {
        for (byte by = 0; by < PDFStringUtil.PDF_DOC_ENCODING_MAP.length; by = (byte)(by + 1)) {
            boolean bl;
            char c = PDFStringUtil.PDF_DOC_ENCODING_MAP[by];
            PDFDocCharsetEncoder.IDENT_PDF_DOC_ENCODING_MAP[by] = bl = c == by;
            if (bl) continue;
            EXTENDED_TO_PDF_DOC_ENCODING_MAP.put(Character.valueOf(c), by);
        }
    }
}

